function ilib_gen_loader(name,tables,libs)
// Copyright Enpc 
//------------------------------------
// generate a loader file for gateway
  if rhs < 3 then libs=[];end 

  if typeof(tables)<>'list' then 
    tables= list(tables)
  end
  L=length(tables); 

  for it=1:L 
    [mt,nt]=size(tables(it));
    if nt<>3 & nt<>2 then error('second argument has wrong size ');end 
  end
  
  comp_target = COMPILER;
  if getenv('WIN32','NO')=='OK' then
    select comp_target
     case 'VC++'   then lib_suf='dll';
     case 'gcc' then lib_suf='dll';
    else lib_suf='dll';
    end
  else
     lib_suf=ilib_unix_soname();
  end

  fd=mopen('loader.sce',"w");
  mfprintf(fd,"// generated by builder.sce: Please do not edit this file\n");
  mfprintf(fd,"// ------------------------------------------------------\n");
  mfprintf(fd,"%s_path=get_file_path(''loader.sce'');\n",name);

  nl=size(libs,'*') 
  for i=1:nl 
    mfprintf(fd,"link(%s_path+''/%s.%s'');\n",name,libs(i),lib_suf);
  end 

  if L == 1 then 
    // direct call to addinter 
    table = tables(1);
    mfprintf(fd,"functions=[ ''%s'';\n",table(1,1));
    for x=table(2:$,1)' ;mfprintf(fd,"            ''%s'';\n",x);end
    mfprintf(fd,"];\n");
    mfprintf(fd,"addinter(%s_path+''/%s.%s'',''%s'',functions);\n",name, ...
	     name,lib_suf,name);
  else
     // on link then a set of addinter 
     mfprintf(fd,"ilib=link(%s_path+''/%s.%s'');\n",name, ...
		name,lib_suf);
     for itable=1:L 
       // loop on a list of tables 
       table = tables(itable);
       mfprintf(fd,"functions=[ ''%s'';\n",table(1,1));
       for x=table(2:$,1)' ;mfprintf(fd,"            ''%s'';\n",x);end
       mfprintf(fd,"];\n");
       mfprintf(fd,"addinter(ilib,''%s'',functions);\n",name+ ...
		string(itable));
     end
  end
  mclose(fd);
endfunction

