/*
 *  Part of the shrinkta program, a dvd backup tool
 *
 *  Copyright (C) 2005  Daryl Gray
 *  E-Mail Daryl Gray darylgray1@dodo.com.au
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU Library General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 *
*/

/** $Revision: 1.01 $
 * Libdvd common header
 * @file dvd-title.h DvdTitleDisk header file
 * @ingroup core
 *
 * libdvd
 */

#if !defined (__DVD_H_INSIDE__) && !defined (LIBDVD_COMPILATION)
#error "Only <dvd.h> can be included directly."
#endif

#ifndef __DVD_TITLE_DISK_H__
#define __DVD_TITLE_DISK_H__


G_BEGIN_DECLS


/* --- type macros --- */
#define DVD_TITLE_DISK_TYPE			(dvd_title_disk_get_type())
#define DVD_TITLE_DISK(o)			(G_TYPE_CHECK_INSTANCE_CAST (o, DVD_TITLE_DISK_TYPE, DvdTitleDisk))
#define DVD_TITLE_DISK_CLASS(k)			(G_TYPE_CHECK_CLASS_CAST    (k, DVD_TITLE_DISK_TYPE, DvdTitleDiskClass))
#define DVD_TITLE_DISK_IS_TITLE(o)		(G_TYPE_CHECK_INSTANCE_TYPE (o, DVD_TITLE_DISK_TYPE))
#define DVD_TITLE_DISK_IS_TITLE_CLASS(k)	(G_TYPE_CHECK_CLASS_TYPE    (k, DVD_TITLE_DISK_TYPE))

/* --- typedefs & structures --- */
typedef struct	_DvdTitleDisk			DvdTitleDisk;
typedef struct	_DvdTitleDiskClass		DvdTitleDiskClass;

struct _DvdTitleDisk {
	DvdTitle	 parent;

	guint8		 title_set;
	gssize		 blocks;	/**< blocks (including nav packets) vobs size = blocks X 2048 bytes */
	gchar		*device;
	DvdTime		*elapsed_time;
	guint32		 start_ts;
	gboolean	 menu;
	
	/* For reading ops - always lock op_mutex before accessing op_* */
	GMutex		*op_mutex;
	gboolean	 op_reading;
	gboolean	 op_canned;
	DvdChapterDisk	*op_chapter;
};

/** Dvd title disk class definition */
struct _DvdTitleDiskClass {
	DvdTitleClass	parent;
	/**
	 * output_chapter Outputs all available data when title is being read.
	 * Bytes = -1 signals end of data stream.
	 * @param title Pointer to #DvdTitle emitting signal
	 * @param output DvdStream data output type
	 * @param track Track data belongs to as a gint
	 * @param bytes Bytes output as a gint
	 * @param buffer Pointer to guint8 output buffer
	 * @returns void
	*/
	void (*output_chapter)	(DvdTitle	*title,
				 DvdStream	 stream_type,
				 gint		 track,
				 gint		 bytes,
				 guint8		*buffer,
				 guint32	 pts,
				 guint64	 frame_clocks);
	/**
	 * title_time Outputs current cell, chapter and title times when title is being read.
	 * @param title Pointer to #DvdTitle emitting signal
	 * @param current_cell_time Const pointer to current cell #DvdTime
	 * @param current_chapter_time Const pointer to current chapter #DvdTime
	 * @param current_title_time Const pointer to current title #DvdTime
	 * @returns void
	*/
	void (*title_time)	(DvdTitle	*title,
				 const DvdTime	*current_cell_time,
				 const DvdTime	*current_chapter_time,
				 const DvdTime	*current_title_time);
};

/* --- prototypes --- */
GType		dvd_title_disk_get_type		(void);
DvdTitleDisk*   dvd_title_disk_new		(void);
guint32	    	dvd_title_disk_get_blocks	(DvdTitleDisk	 *title);
gboolean 	dvd_title_disk_read		(DvdTitleDisk	 *title,
						 GError		**error);
gboolean	dvd_title_disk_read_chapters	(DvdTitleDisk	 *title,
						 guint8		  start_chapter,
						 guint8		  end_chapter,
						 GError		**error);
void		dvd_title_disk_stop_read	(DvdTitleDisk	 *title);

G_END_DECLS

#endif /*__DVD_TITLE_DISK_H__*/
