/*  smplayer, GUI front-end for mplayer.
    Copyright (C) 2007 Ricardo Villalba <rvm@escomposlinux.org>

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
*/

#include "csmanager.h"
#include "client.h"
#include "server.h"

CSManager::CSManager( int port, QStringList files_to_open,  
                      QObject * parent, const char * name)
	: QObject(parent, name )
{
	_port = port;
	_files_to_open = files_to_open;

	// Client which will try to connect to other running instance
	client = new MyClient( _port, this, "client");
	connect( client, SIGNAL(connected()), this, SLOT(connectedToPort()) );
	connect( client, SIGNAL(notConnected()), this, SLOT(notConnectedToPort()) );
	connect( client, SIGNAL(serverIdentified()), 
             this, SLOT(connectedToInstance()) );
	connect( client, SIGNAL(connectionClosed()), 
             this, SLOT(connectionToInstanceClosed()) );
	connect( client, SIGNAL(unknownServer()),
             this, SLOT(connectedToUnknownServer()) );
	connect( client, SIGNAL(serverDontRespond()),
             this, SLOT(serverDontRespond()) );
}

CSManager::~CSManager() {
}

void CSManager::connectedToPort() {
	qDebug("CSManager::connectedToPort");
}

void CSManager::notConnectedToPort() {
	qDebug("CSManager::notConnectedToPort");

	server = new MyServer( _port, this);
	server->setActionsList( actions_list );

	connect(server, SIGNAL(receivedOpen(QString)),
            this, SIGNAL(requestOpen(QString)));
	connect(server, SIGNAL(receivedOpenFiles(QStringList)),
            this, SIGNAL(requestOpenFiles(QStringList)));
	connect(server, SIGNAL(receivedFunction(QString)),
            this, SIGNAL(requestFunction(QString)));

	emit mayStartUp( ServerStarted );
}

void CSManager::connectedToInstance() {
	qDebug("CSManager::connectedToInstance");

	if (!_files_to_open.empty()) {
		if (_files_to_open.count()==1) {
			client->sendToServer("open " + _files_to_open[0]);
			//client->sendToServer("open_utf8 " + _file_to_open.utf8());
		} else {
			client->sendToServer("open_files_start");
			for (int n=0; n < _files_to_open.count(); n++) {
				client->sendToServer("open_files " + _files_to_open[n]);
			}
			client->sendToServer("open_files_end");
		}
	}

	client->closeConnection();
}

void CSManager::connectionToInstanceClosed() {
	qDebug("CSManager::connectedToInstanceClosed");
	emit mayClose();
}

void CSManager::connectedToUnknownServer() {
	qDebug("CSManager::connectedToUnknownServer");
	qDebug("CSManager::connectedToUnknownServer: * Keeping running");

	emit mayStartUp( UnknownServerFound );
}

void CSManager::serverDontRespond() {
	qDebug("CSManager::serverDontRespond");

	emit mayStartUp( ServerDoesNotRespond );
}
