/*  smplayer, GUI front-end for mplayer.
    Copyright (C) 2007 Ricardo Villalba <rvm@escomposlinux.org>

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
*/

#include "filedialog.h"
#include <qwidget.h>
#include <qregexp.h>

#if KDE_SUPPORT
#include <kfiledialog.h>
#else
#include <qfiledialog.h>
#endif

QString MyFileDialog::getOpenFileName ( const QString & startWith,
                            const QString & filter,
                            QWidget * parent, const char * name,
                            const QString & caption,
                            QString * selectedFilter,
                            bool resolveSymlinks )
{
#if KDE_SUPPORT
	return KFileDialog::getOpenFileName( startWith, convertFilter(filter), 
                                         parent, caption );
#else
	return QFileDialog::getOpenFileName( startWith, filter, parent, name,
                                         caption, selectedFilter, 
                                         resolveSymlinks );
#endif
}

QString MyFileDialog::getExistingDirectory ( const QString & dir, 
                                 QWidget * parent, 
                                 const char * name, const QString & caption, 
                                 bool dirOnly, bool resolveSymlinks )
{
#if KDE_SUPPORT
	return KFileDialog::getExistingDirectory ( dir, parent, caption );
#else
	return QFileDialog::getExistingDirectory( dir, parent, name, caption,
                                              dirOnly, resolveSymlinks );
#endif
}

QString MyFileDialog::getSaveFileName ( const QString & startWith,
                            const QString & filter,
                            QWidget * parent, const char * name,
                            const QString & caption,
                            QString * selectedFilter,
                            bool resolveSymlinks ) 
{
#if KDE_SUPPORT
	return KFileDialog::getSaveFileName( startWith, convertFilter(filter), 
                                         parent, caption);
#else
	return QFileDialog::getSaveFileName( startWith, filter, parent, name,
                                         caption, selectedFilter, 
                                         resolveSymlinks );
#endif
}

QStringList MyFileDialog::getOpenFileNames ( const QString & filter,
                               const QString & dir,
                               QWidget * parent, const char * name,
                               const QString & caption,
                               QString * selectedFilter,
                               bool resolveSymlinks )
{
#if KDE_SUPPORT
	return KFileDialog::getOpenFileNames( dir, convertFilter(filter), 
                                          parent, caption);
#else
	return QFileDialog::getOpenFileNames( filter, dir, parent, name, caption, 
                                          selectedFilter, resolveSymlinks );
#endif
}

#if KDE_SUPPORT
QString MyFileDialog::convertFilter( QString qt_filter ) {
	//return "*.*";
	//return qt_filter.replace(";;", "\n");

	QString res;

	QRegExp rx( "(.*) \\((.*)\\)" );
	QStringList list = QStringList::split( ";;", qt_filter);
	for (int n = 0; n < list.count(); n++) {
		qDebug(" filter %d: '%s'", n, list[n].utf8().data() );
		if (rx.search(list[n]) > -1) {
			QString text = rx.cap(1);
			QString filter = rx.cap(2);
			qDebug(" text: '%s' filter: '%s'", text.utf8().data(), filter.utf8().data());
			res += filter +"|"+text;
			if (n != list.count()-1) res +="\n";
		}
		else
			res += list[n];
	}

	qDebug( "res: '%s'", res.utf8().data());
	return res;
}
#endif
