/*  smplayer, GUI front-end for mplayer.
    Copyright (C) 2007 Ricardo Villalba <rvm@escomposlinux.org>

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
*/

#ifndef _FILEPROPERTIESDIALOG_H_
#define _FILEPROPERTIESDIALOG_H_

#include "filepropertiesdialogbase.h"
#include "inforeader.h"
#include "mediadata.h"

class FilePropertiesDialog : public FilePropertiesDialogBase
{
	Q_OBJECT

public:
    FilePropertiesDialog( QWidget* parent = 0, const char* name = 0, bool modal = FALSE, WFlags fl = 0 );
    ~FilePropertiesDialog();

	// Call it as soon as possible
	void setCodecs(InfoList vc, InfoList ac, InfoList demuxer);
	bool hasCodecsList() { return codecs_set; };

	void setMediaData(MediaData md);

	void setDemuxer(QString demuxer, QString original_demuxer="");
	QString demuxer();

	void setVideoCodec(QString vc, QString original_vc="");
	QString videoCodec();

	void setAudioCodec(QString ac, QString original_ac="");
	QString audioCodec();

	void setMplayerAdditionalArguments(QString args);
	QString mplayerAdditionalArguments();

	void setMplayerAdditionalVideoFilters(QString s);
	QString mplayerAdditionalVideoFilters();

	void setMplayerAdditionalAudioFilters(QString s);
	QString mplayerAdditionalAudioFilters();

	// Reimplemented to send a signal
	void accept();
	void apply();

signals:
	void applyButtonPressed();

protected slots:
	virtual void languageChange();

	virtual void resetDemuxer();
	virtual void resetAC();
	virtual void resetVC();

protected:
	int find(QString s, InfoList &list);
	void showInfo();

private:
	bool codecs_set;
	InfoList vclist, aclist, demuxerlist;
	QString orig_demuxer, orig_ac, orig_vc;
	MediaData media_data;
};

#endif
