/*  smplayer, GUI front-end for mplayer.
    Copyright (C) 2007 Ricardo Villalba <rvm@escomposlinux.org>

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
*/

#ifndef _MYACTION_H
#define _MYACTION_H

#include "qt3_4_compat.h"

#include <qstring.h>
#include <qiconset.h>
#include <qkeysequence.h>

class MyAction : public QACTION 
{
	Q_OBJECT

public:
	MyAction ( QObject * parent, const char * name = 0 );
	MyAction ( const QString & menuText, QKeySequence accel, QObject * parent, const char * name = 0 );
	MyAction ( QKeySequence accel, QObject * parent, const char * name = 0 );
	~MyAction();

	void setParameter(int p);
	int parameter() { return _parameter; }

	void change(const QIconSet & icon, const QString & menuText, 
                QKeySequence accel, const QString & text = QString::null);

	void change(const QIconSet & icon, const QString & menuText );

	void change( const QString & menuText, 
                 QKeySequence accel, const QString & text = QString::null);

	void change( const QString & menuText, const QString & text = QString::null);

signals:
	void activated(int);
	void toggled(int);

protected slots:
	void activated_slot();
	void toggled_slot();

protected:
	int _parameter;
};

#endif

