/*  smplayer, GUI front-end for mplayer.
    Copyright (C) 2007 Ricardo Villalba <rvm@escomposlinux.org>

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
*/

#include "infowindow.h"
#include <qfileinfo.h>
#include <qtextedit.h>
#include "infofile.h"
#include "helper.h"
#include "images.h"

#include "config.h"

InfoWindow::InfoWindow( QWidget* parent, const char* name, WFlags fl)
	: InfoWindowBase(parent, name, fl)
{
	setIcon( Images::icon("logo") );
}

InfoWindow::~InfoWindow() {
}

void InfoWindow::languageChange() {
	InfoWindowBase::languageChange();

	setIcon( Images::icon("logo") );

	if (isVisible()) {
		setData(data);
	}
}

void InfoWindow::setData(MediaData md) {
	data = md;

	InfoFile info;

	view->setText( info.getInfo(data) );
}

