/*  smplayer, GUI front-end for mplayer.
    Copyright (C) 2007 Ricardo Villalba <rvm@escomposlinux.org>

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
*/

/* This file is based on the "small client-server example" from Qt */
/* Copyright (C) 1992-2000 Trolltech AS. */


#include "server.h"
#include <qtextstream.h>
#include <qregexp.h>
#include "version.h"
#include "global.h"


ClientSocket::ClientSocket( int sock, QObject *parent, const char *name ) 
	: QSocket( parent, name )
{
	connect( this, SIGNAL(readyRead()), SLOT(readClient()) );
	connect( this, SIGNAL(connectionClosed()), SLOT(deleteLater()) );
	setSocket( sock );

	sendText("SMPlayer " VERSION);
	sendText("Type help for a list of commands");
}

ClientSocket::~ClientSocket() {
}

void ClientSocket::readClient() {
	QRegExp rx_open("^open (.*)");
	QRegExp rx_open_utf8("^open_utf8 (.*)");
	QRegExp rx_open_files("^open_files (.*)");
	QRegExp rx_function("^(function|f) (.*)");

	QTextStream ts( this );
	ts.setEncoding( QTextStream::UnicodeUTF8 );
	while ( canReadLine() ) {
		QString str = ts.readLine();
		qDebug("ClientSocket::readClient: '%s'", str.utf8().data() );

		if (str.lower() == "hello") {
			sendText("Hello, this is SMPlayer " VERSION);
		}
		else
		/*
		if (str.startsWith("Hello, this is smplayer")) {
			sendText("I'm smplayer too, go on");
		} 
		else
		*/
		if (str.lower() == "help") {
			sendText("Available commands:");
			sendText(" help");
			sendText(" quit");
			sendText(" list functions");
			sendText(" function [function_name]");
			sendText(" f [function_name]");
			sendText(" open [file]");
			sendText(" open_utf8 [file]");
		}
		else
		if (str.lower() == "quit") {
			sendText("Goodbye");
			flush();
			close();
		}
		else
		if (str.lower() == "list functions") {
			/*
			QStringList l = key_list->functionList();
			for (int n=0; n < l.count(); n++) {
				sendText( l[n] );
			}
			*/
			for (int n=0; n < actions_list.count(); n++) {
				sendText( actions_list[n] );
			}
			/*sendText("None");*/
		}
		else 
		if (rx_open.search(str) > -1) {
			QString file = rx_open.cap(1);
			qDebug("ClientSocket::readClient: asked to open '%s'", file.utf8().data());
			emit receivedOpen(file);
			sendText("OK, file sent to GUI");
		} 
		else
		if (rx_open_utf8.search(str) > -1) {
			QString file = QString::fromUtf8( rx_open_utf8.cap(1) );
			qDebug("ClientSocket::readClient: asked to open (utf8) '%s'", file.utf8().data());
			emit receivedOpen(file);
			sendText("OK, file sent to GUI");
		} 
		else
		if (str.lower() == "open_files_start") {
			files_to_open.clear();
			sendText("OK, send first file");
		}
		else
		if (str.lower() == "open_files_end") {
			qDebug("ClientSocket::readClient: files_to_open:");
			for (int n=0; n < files_to_open.count(); n++) 
				qDebug("%d: '%s'", n, files_to_open[n].utf8().data());
			sendText("OK, sending files to GUI");
			emit receivedOpenFiles(files_to_open);
		}
		else
		if (rx_open_files.search(str) > -1) {
			QString file = rx_open_files.cap(1);
			files_to_open.append(file);
			sendText("OK, file received");
		}
		else
		if (rx_function.search(str) > -1) {
			QString function = rx_function.cap(2).lower(); //upper();
			qDebug("ClientSocket::readClient: asked to process function '%s'", function.utf8().data());
			emit receivedFunction(function);
			sendText("OK, function sent to GUI");
		}
		else {
			sendText("Unknown command");
		}
	}
}

void ClientSocket::sendText(QString text) {
	QTextStream os(this);
	os.setEncoding( QTextStream::UnicodeUTF8 );
	os << text << "\r\n";
//#if QT_VERSION >= 0x040000
	flush();
//#endif
}

MyServer::MyServer( Q_UINT16 port, QObject* parent ) 
	: QServerSocket( port, 1, parent )
{
	if ( !ok() ) {
		qWarning("MyServer::MyServer: failed to bind to port %d", port);
	} else {
		qDebug("MyServer::MyServer:: server started at port %d", port);
	}
}

MyServer::~MyServer() {
}

void MyServer::newConnection( int socket ) {
	ClientSocket *s = new ClientSocket( socket, this, "socket" );
	s->setActionsList( actions_list );

	connect(s, SIGNAL(receivedOpen(QString)), 
            this, SIGNAL(receivedOpen(QString)));
	connect(s, SIGNAL(receivedOpenFiles(QStringList)), 
            this, SIGNAL(receivedOpenFiles(QStringList)));
	connect(s, SIGNAL(receivedFunction(QString)),
            this, SIGNAL(receivedFunction(QString)));

	emit newConnect( s );
}

