
#ifndef _CONFIG_DIALOGUE_INTERFACE_H_
#define _CONFIG_DIALOGUE_INTERFACE_H_

#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include <qwidget.h>

class KFontRequester;
class QSpinBox;
class QComboBox;
class QCheckBox;

/**
 * @short ConfigDialogueInterface
 * @author Daniel Faust <daniel@kaligames.de>
 * @version 0.1
 */
class ConfigDialogueInterface : public QWidget
{
    Q_OBJECT
public:
    /**
     * Default Constructor
     */
    ConfigDialogueInterface( QWidget *parent=0, const char *name=0 );

    /**
     * Default Destructor
     */
    virtual ~ConfigDialogueInterface();

private:
    QSpinBox *sPauseMS;
    QComboBox *cStartTab;
    KFontRequester *fFileListFont;
    QCheckBox *cAskForNewOptions;

public slots:
    void resetDefaults();
    void saveSettings();

signals:
    void configChanged();

private slots:
    void cfgChanged();

};

#endif // _CONFIG_DIALOGUE_INTERFACE_H_

