/* Stars -- Displays a Map of the Night Sky
    Copyright (C) September 22, 2002  Walter Brisken

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA*/

#ifndef __VIEWER_H__
#define __VIEWER_H__

#include <gdk/gdk.h>
#include <gtk/gtk.h>
#include <gdk-pixbuf/gdk-pixbuf.h>
#include "coordutils.h"
#include "location.h"
#include "vista.h"

extern int numviewers;

struct catalog;

struct viewer
{
	/* The rotation matrix stored two ways.  */
	long rot[3][3];
	double drot[3][3];
	
	/* These are functions of the view, and should not be changed! */
	long long offx, offy;
	double scale;
	int xres, yres;
	int N;

	/* Configurable information */
	struct vista *view;
	struct location *loc;
	GList *coordinateproperties;

	/* Random bits */
	int viewerID;
	unsigned char andmask, showmask;

	/* This stuff will eventually be in gtkstarcanvas */
	GdkPixbuf *image;
	GtkWidget *viewerwindow;
	GtkWidget *stararea, *statusbar;
	GtkWidget *rascroll, *decscroll;
	GtkObject *raadjust, *decadjust;
};


struct viewer *newviewer();

int isvalidviewer(struct viewer *v);

void computematrix(struct viewer *v);

void setcenter(struct viewer *v, double ra, double dec);

void viewersetvista(struct viewer *v, const struct vista *view);

void setzoom(struct viewer *v, double zoom);

void getradec(struct viewer *v, double x, double y, double *ra, double *dec);

void resize(struct viewer *v, int newxres, int newyres);

void refreshimage(struct viewer *v);

void paint(struct viewer *v);

void paintall();

void findclosest(struct viewer *v, double ra, double dec);

void applyclasslimits(struct catalog *cat0, int viewerid);

void applyclasslimitsall(struct catalog *cat);

void viewersetlocation(struct viewer *v, const struct location *loc);

#endif
