/* ==================================================
 * JCommon : a general purpose class library for Java
 * ==================================================
 *
 * Project Info:  http://www.object-refinery.com/jcommon/index.html
 * Project Lead:  David Gilbert (david.gilbert@object-refinery.com);
 *
 * (C) Copyright 2000-2002, by Simba Management Limited and Contributors.
 *
 * This library is free software; you can redistribute it and/or modify it under the terms
 * of the GNU Lesser General Public License as published by the Free Software Foundation;
 * either version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful, but WITHOUT ANY WARRANTY;
 * without even the implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 * See the GNU Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License along with this
 * library; if not, write to the Free Software Foundation, Inc., 59 Temple Place, Suite 330,
 * Boston, MA 02111-1307, USA.
 *
 * -----------------------
 * IntervalXYZDataset.java
 * -----------------------
 * (C) Copyright 2001, 2002, by Simba Management Limited.
 *
 * Original Author:  David Gilbert (for Simba Management Limited);
 * Contributor(s):   -;
 *
 * $Id: IntervalXYZDataset.java,v 1.3 2002/04/02 16:58:29 mungady Exp $
 *
 * Changes
 * -------
 * 31-Oct-2001 : Version 1 (DG);
 *
 */

package com.jrefinery.data;

/**
 * An extension of the XYZDataset interface that allows a range of data to be defined for any of the
 * X values, the Y values, and the Z values.
 */
public interface IntervalXYZDataset extends XYZDataset {

    /**
     * Returns the starting X value for the specified series and item.
     * @param series The series (zero-based index);
     * @param item The item within a series (zero-based index).
     */
    public Number getStartXValue(int series, int item);

    /**
     * Returns the ending X value for the specified series and item.
     * @param series The series (zero-based index);
     * @param item The item within a series (zero-based index).
     */
    public Number getEndXValue(int series, int item);

    /**
     * Returns the starting Y value for the specified series and item.
     * @param series The series (zero-based index);
     * @param item The item within a series (zero-based index).
     */
    public Number getStartYValue(int series, int item);

    /**
     * Returns the ending Y value for the specified series and item.
     * @param series The series (zero-based index);
     * @param item The item within a series (zero-based index).
     */
    public Number getEndYValue(int series, int item);

    /**
     * Returns the starting Z value for the specified series and item.
     * @param series The series (zero-based index);
     * @param item The item within a series (zero-based index).
     */
    public Number getStartZValue(int series, int item);

    /**
     * Returns the ending Z value for the specified series and item.
     * @param series The series (zero-based index);
     * @param item The item within a series (zero-based index).
     */
    public Number getEndZValue(int series, int item);

}