/*
 * Copyright (c) 2005-2007 Substance Kirill Grouchnikov. All Rights Reserved.
 *
 * Redistribution and use in source and binary forms, with or without 
 * modification, are permitted provided that the following conditions are met:
 * 
 *  o Redistributions of source code must retain the above copyright notice, 
 *    this list of conditions and the following disclaimer. 
 *     
 *  o Redistributions in binary form must reproduce the above copyright notice, 
 *    this list of conditions and the following disclaimer in the documentation 
 *    and/or other materials provided with the distribution. 
 *     
 *  o Neither the name of Substance Kirill Grouchnikov nor the names of 
 *    its contributors may be used to endorse or promote products derived 
 *    from this software without specific prior written permission. 
 *     
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS" 
 * AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, 
 * THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR 
 * PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT OWNER OR 
 * CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, 
 * EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, 
 * PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; 
 * OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, 
 * WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE 
 * OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, 
 * EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE. 
 */
package org.jvnet.substance;

import java.awt.*;

import javax.swing.*;
import javax.swing.border.EmptyBorder;
import javax.swing.plaf.ColorUIResource;
import javax.swing.plaf.ListUI;

import org.jvnet.lafwidget.animation.FadeKind;
import org.jvnet.substance.theme.SubstanceTheme;
import org.jvnet.substance.utils.*;

/**
 * Default renderer for list cells.
 * 
 * @author Kirill Grouchnikov
 */
public class SubstanceDefaultListCellRenderer extends DefaultListCellRenderer {
	/**
	 * Default border to provide consistent offsets on left and right sides.
	 */
	// protected static final Border noFocusBorder = new EmptyBorder(1, 4, 1,
	// 4);
	/**
	 * Constructs a default renderer object for an item in a list.
	 */
	public SubstanceDefaultListCellRenderer() {
		super();
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see javax.swing.ListCellRenderer#getListCellRendererComponent(javax.swing.JList,
	 *      java.lang.Object, int, boolean, boolean)
	 */
	@Override
	public Component getListCellRendererComponent(JList list, Object value,
			int index, boolean isSelected, boolean cellHasFocus) {
		this.setComponentOrientation(list.getComponentOrientation());

		ListUI listUI = list.getUI();
		if (listUI instanceof SubstanceListUI) {
			SubstanceListUI ui = (SubstanceListUI) listUI;
			ComponentState state = ui.getCellState(index);
			ComponentState prevState = ui.getPrevCellState(index);

			// // special case for the combobox. The selected value is
			// // painted using the renderer of the list, and the index
			// // is -1.
			// if (index == -1) {
			// if (isSelected && list.isEnabled()) {
			// state = ComponentState.SELECTED;
			// prevState = ComponentState.SELECTED;
			// }
			// // check if the originating combo is enabled
			// Component popup = SwingUtilities.getAncestorOfClass(
			// SubstanceComboPopup.class, list);
			// if (popup != null) {
			// boolean isEnabled = ((SubstanceComboPopup) popup)
			// .isComboEnabled();
			// if (!isEnabled) {
			// state = ComponentState.DISABLED_SELECTED;
			// prevState = ComponentState.DISABLED_SELECTED;
			// }
			// }
			// }
			SubstanceTheme theme = SubstanceCoreUtilities.getTheme(list, state,
					true, true);
			Color color = SubstanceCoreUtilities
					.getInterpolatedForegroundColor(list, index, theme, state,
							prevState, FadeKind.SELECTION, FadeKind.ROLLOVER);

			// System.out.println("[row " + index + "] - " + prevState.name() +
			// ":"
			// + state.name() + ":" + color + " from "
			// + theme.getDisplayName());

			super.setForeground(color);
		} else {
			if (isSelected) {
				this.setForeground(list.getSelectionForeground());
			} else {
				this.setForeground(list.getForeground());
			}
		}

		if (isSelected) {
			// setBackground(list.getSelectionBackground());
			// this.setForeground(list.getSelectionForeground());
		} else {
			int r = list.getBackground().getRed();
			int g = list.getBackground().getGreen();
			int b = list.getBackground().getBlue();
			double coef = SubstanceCoreUtilities
					.isThemeDark(SubstanceLookAndFeel.getTheme()) ? 0.80 : 0.96;
			Color darkerColor = new ColorUIResource((int) (coef * r),
					(int) (coef * g), (int) (coef * b));
			if (index % 2 == 0) {
				this.setBackground(list.getBackground());
			} else {
				this.setBackground(darkerColor);
			}
			// this.setForeground(list.getForeground());
		}

		if (value instanceof Icon) {
			this.setIcon((Icon) value);
			this.setText("");
		} else {
			this.setIcon(null);
			this.setText((value == null) ? "" : value.toString());
		}

		this.setEnabled(list.isEnabled());
		this.setFont(list.getFont());

		Insets ins = SubstanceSizeUtils.getListCellRendererInsets(list
				.getFont().getSize());
		this
				.setBorder(new EmptyBorder(ins.top, ins.left, ins.bottom,
						ins.right));

		this.setOpaque(true);
		return this;
	}

	/**
	 * UI resource for renderer (does nothing yet).
	 * 
	 * @author Kirill Grouchnikov
	 */
	public static class SubstanceUIResource extends
			SubstanceDefaultListCellRenderer implements
			javax.swing.plaf.UIResource {
		/*
		 * (non-Javadoc)
		 * 
		 * @see javax.swing.ListCellRenderer#getListCellRendererComponent(javax.swing.JList,
		 *      java.lang.Object, int, boolean, boolean)
		 */
		@Override
		public Component getListCellRendererComponent(JList list, Object value,
				int index, boolean isSelected, boolean cellHasFocus) {
			return super.getListCellRendererComponent(list, value, index,
					isSelected, cellHasFocus);
		}
	}

}
