/*
 * Copyright (c) 2005-2007 Substance Kirill Grouchnikov. All Rights Reserved.
 *
 * Redistribution and use in source and binary forms, with or without 
 * modification, are permitted provided that the following conditions are met:
 * 
 *  o Redistributions of source code must retain the above copyright notice, 
 *    this list of conditions and the following disclaimer. 
 *     
 *  o Redistributions in binary form must reproduce the above copyright notice, 
 *    this list of conditions and the following disclaimer in the documentation 
 *    and/or other materials provided with the distribution. 
 *     
 *  o Neither the name of Substance Kirill Grouchnikov nor the names of 
 *    its contributors may be used to endorse or promote products derived 
 *    from this software without specific prior written permission. 
 *     
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS" 
 * AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, 
 * THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR 
 * PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT OWNER OR 
 * CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, 
 * EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, 
 * PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; 
 * OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, 
 * WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE 
 * OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, 
 * EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE. 
 */
package org.jvnet.substance;

import org.jvnet.substance.border.*;
import org.jvnet.substance.button.*;
import org.jvnet.substance.painter.*;
import org.jvnet.substance.plugin.*;
import org.jvnet.substance.skin.SubstanceAbstractSkin;
import org.jvnet.substance.theme.SubstanceAquaTheme;
import org.jvnet.substance.theme.SubstanceTheme;
import org.jvnet.substance.title.*;
import org.jvnet.substance.watermark.SubstanceStripeWatermark;
import org.jvnet.substance.watermark.SubstanceWatermark;

/**
 * The default look and feel that sets theme, watermark, button shaper and
 * painters based on VM / config / plugin parameters. Use to revert to the
 * default settings.
 * 
 * @author Kirill Grouchnikov
 * @since 3.2
 */
public class SubstanceDefaultLookAndFeel extends SubstanceLookAndFeel {
	/**
	 * Default skin.
	 * 
	 * @author Kirill Grouchnikov
	 */
	private static class SubstanceDefaultSkin extends SubstanceAbstractSkin {
		/**
		 * Creates the default skin.
		 */
		public SubstanceDefaultSkin() {
			// set theme
			String paramTheme = SubstanceLookAndFeel.paramReader
					.getThemeProperty();
			if (paramTheme != null) {
				try {
					Class<?> themeClass = Class.forName(paramTheme);
					if (themeClass != null) {
						Object obj = themeClass.newInstance();
						if (obj instanceof SubstanceTheme) {
							this.theme = (SubstanceTheme) obj;
						}
					}
				} catch (Exception exc) {
				}
			}

			if (this.theme == null) {
				for (Object themePlugin : SubstanceLookAndFeel.themePlugins
						.getAvailablePlugins(true)) {
					String defaultThemeClassName = ((SubstanceThemePlugin) themePlugin)
							.getDefaultThemeClassName();
					if (defaultThemeClassName != null) {
						try {
							Class<?> themeClass = Class
									.forName(defaultThemeClassName);
							if (themeClass != null) {
								Object obj = themeClass.newInstance();
								if (obj instanceof SubstanceTheme) {
									this.theme = (SubstanceTheme) obj;
								}
							}
						} catch (Exception exc) {
						}
					}
				}
			}
			if (this.theme == null) {
				this.theme = new SubstanceAquaTheme();
			}

			// set watermark
			String paramWatermark = SubstanceLookAndFeel.paramReader
					.getWatermarkProperty();
			if (paramWatermark != null) {
				try {
					Class<?> watermarkClass = Class.forName(paramWatermark);
					if (watermarkClass != null) {
						Object obj = watermarkClass.newInstance();
						if (obj instanceof SubstanceWatermark) {
							this.watermark = (SubstanceWatermark) obj;
						}
					}
				} catch (Exception exc) {
				}
			}

			if (this.watermark == null) {
				for (Object watermarkPlugin : SubstanceLookAndFeel.watermarkPlugins
						.getAvailablePlugins(true)) {
					String defaultWatermarkClassName = ((SubstanceWatermarkPlugin) watermarkPlugin)
							.getDefaultWatermarkClassName();
					if (defaultWatermarkClassName != null) {
						try {
							Class<?> watermarkClass = Class
									.forName(defaultWatermarkClassName);
							if (watermarkClass != null) {
								Object obj = watermarkClass.newInstance();
								if (obj instanceof SubstanceWatermark) {
									this.watermark = (SubstanceWatermark) obj;
								}
							}
						} catch (Exception exc) {
						}
					}
				}
			}
			if (this.watermark == null) {
				this.watermark = new SubstanceStripeWatermark();
			}

			// set buttonShaper
			String paramButtonShaper = SubstanceLookAndFeel.paramReader
					.getButtonShaperProperty();
			if (paramButtonShaper != null) {
				try {
					Class<?> buttonShaperClass = Class
							.forName(paramButtonShaper);
					if (buttonShaperClass != null) {
						Object obj = buttonShaperClass.newInstance();
						if (obj instanceof SubstanceButtonShaper) {
							this.shaper = (SubstanceButtonShaper) obj;
						}
					}
				} catch (Exception exc) {
				}
			}

			if (this.shaper == null) {
				for (Object buttonShaperPlugin : SubstanceLookAndFeel.shaperPlugins
						.getAvailablePlugins(true)) {
					for (ButtonShaperInfo buttonShaperInfo : ((SubstanceButtonShaperPlugin) buttonShaperPlugin)
							.getButtonShapers()) {
						if (buttonShaperInfo.isDefault()) {
							try {
								Class<?> buttonShaperClass = Class
										.forName(buttonShaperInfo
												.getClassName());
								if (buttonShaperClass != null) {
									Object obj = buttonShaperClass
											.newInstance();
									if (obj instanceof SubstanceButtonShaper) {
										this.shaper = (SubstanceButtonShaper) obj;
									}
								}
							} catch (Exception exc) {
							}
						}
					}
				}
			}
			if (this.shaper == null) {
				this.shaper = new StandardButtonShaper();
			}

			// set gradientPainter
			String paramGradientPainter = SubstanceLookAndFeel.paramReader
					.getGradientPainterProperty();
			if (paramGradientPainter != null) {
				try {
					Class<?> gradientPainterClass = Class
							.forName(paramGradientPainter);
					if (gradientPainterClass != null) {
						Object obj = gradientPainterClass.newInstance();
						if (obj instanceof SubstanceGradientPainter) {
							this.gradientPainter = (SubstanceGradientPainter) obj;
						}
					}
				} catch (Exception exc) {
				}
			}

			if (this.gradientPainter == null) {
				for (Object gradientPainterPlugin : SubstanceLookAndFeel.painterPlugins
						.getAvailablePlugins(true)) {
					for (GradientPainterInfo gradientPainterInfo : ((SubstanceGradientPainterPlugin) gradientPainterPlugin)
							.getGradientPainters()) {
						if (gradientPainterInfo.isDefault()) {
							try {
								Class<?> gradientPainterClass = Class
										.forName(gradientPainterInfo
												.getClassName());
								if (gradientPainterClass != null) {
									Object obj = gradientPainterClass
											.newInstance();
									if (obj instanceof SubstanceGradientPainter) {
										this.gradientPainter = (SubstanceGradientPainter) obj;
									}
								}
							} catch (Exception exc) {
							}
						}
					}
				}
			}
			if (this.gradientPainter == null) {
				this.gradientPainter = new StandardGradientPainter();
			}

			// set title painter
			String paramTitlePainter = SubstanceLookAndFeel.paramReader
					.getTitlePainterProperty();
			if (paramTitlePainter != null) {
				try {
					Class<?> titlePainterClass = Class
							.forName(paramTitlePainter);
					if (titlePainterClass != null) {
						Object obj = titlePainterClass.newInstance();
						if (obj instanceof SubstanceTitlePainter) {
							this.titlePainter = (SubstanceTitlePainter) obj;
						}
					}
				} catch (Exception exc) {
				}
			}

			if (this.titlePainter == null) {
				for (Object titlePainterPlugin : SubstanceLookAndFeel.titlePainterPlugins
						.getAvailablePlugins(true)) {
					for (TitlePainterInfo titlePainterInfo : ((SubstanceTitlePainterPlugin) titlePainterPlugin)
							.getTitlePainters()) {
						if (titlePainterInfo.isDefault()) {
							try {
								Class<?> titlePainterClass = Class
										.forName(titlePainterInfo
												.getClassName());
								if (titlePainterClass != null) {
									Object obj = titlePainterClass
											.newInstance();
									if (obj instanceof SubstanceTitlePainter) {
										this.titlePainter = (SubstanceTitlePainter) obj;
									}
								}
							} catch (Exception exc) {
							}
						}
					}
				}
			}
			if (this.titlePainter == null) {
				this.titlePainter = new Glass3DTitlePainter();
			}

			// set border painter
			String paramBorderPainter = SubstanceLookAndFeel.paramReader
					.getBorderPainterProperty();
			if (paramBorderPainter != null) {
				try {
					Class<?> borderPainterClass = Class
							.forName(paramBorderPainter);
					if (borderPainterClass != null) {
						Object obj = borderPainterClass.newInstance();
						if (obj instanceof SubstanceBorderPainter) {
							this.borderPainter = (SubstanceBorderPainter) obj;
						}
					}
				} catch (Exception exc) {
				}
			}

			if (this.borderPainter == null) {
				for (Object borderPainterPlugin : SubstanceLookAndFeel.borderPainterPlugins
						.getAvailablePlugins(true)) {
					for (BorderPainterInfo borderPainterInfo : ((SubstanceBorderPainterPlugin) borderPainterPlugin)
							.getBorderPainters()) {
						if (borderPainterInfo.isDefault()) {
							try {
								Class<?> borderPainterClass = Class
										.forName(borderPainterInfo
												.getClassName());
								if (borderPainterClass != null) {
									Object obj = borderPainterClass
											.newInstance();
									if (obj instanceof SubstanceBorderPainter) {
										this.borderPainter = (SubstanceBorderPainter) obj;
									}
								}
							} catch (Exception exc) {
							}
						}
					}
				}
			}
			if (this.borderPainter == null) {
				this.borderPainter = new StandardBorderPainter();
			}

		}

		public String getDisplayName() {
			return "Default";
		}
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see org.jvnet.substance.SubstanceLookAndFeel#getID()
	 */
	@Override
	public String getID() {
		return "Substance Default";
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see org.jvnet.substance.SubstanceLookAndFeel#getName()
	 */
	@Override
	public String getName() {
		return "Substance Default";
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see org.jvnet.substance.SubstanceLookAndFeel#initialize()
	 */
	@Override
	public void initialize() {
		super.initialize();
		setSkin(new SubstanceDefaultSkin());
	}
}
