/*
 * Copyright (c) 2005-2007 Substance Kirill Grouchnikov. All Rights Reserved.
 *
 * Redistribution and use in source and binary forms, with or without 
 * modification, are permitted provided that the following conditions are met:
 * 
 *  o Redistributions of source code must retain the above copyright notice, 
 *    this list of conditions and the following disclaimer. 
 *     
 *  o Redistributions in binary form must reproduce the above copyright notice, 
 *    this list of conditions and the following disclaimer in the documentation 
 *    and/or other materials provided with the distribution. 
 *     
 *  o Neither the name of Substance Kirill Grouchnikov nor the names of 
 *    its contributors may be used to endorse or promote products derived 
 *    from this software without specific prior written permission. 
 *     
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS" 
 * AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, 
 * THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR 
 * PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT OWNER OR 
 * CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, 
 * EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, 
 * PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; 
 * OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, 
 * WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE 
 * OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, 
 * EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE. 
 */
package org.jvnet.substance.border;

import java.awt.Color;

import org.jvnet.substance.color.ColorScheme;

/**
 * Border painter that returns images with flat appearance. This class is part
 * of officially supported API.
 * 
 * @author Kirill Grouchnikov
 */
public class FlatBorderPainter extends StandardBorderPainter {
	@Override
	public String getDisplayName() {
		return "Flat";
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see org.jvnet.substance.border.StandardBorderPainter#getMidBorderColor(org.jvnet.substance.color.ColorScheme,
	 *      org.jvnet.substance.color.ColorScheme, double, boolean)
	 */
	@Override
	public Color getMidBorderColor(ColorScheme interpolationScheme1,
			ColorScheme interpolationScheme2, double cycleCoef,
			boolean useCyclePosAsInterpolation) {
		return super.getTopBorderColor(interpolationScheme1,
				interpolationScheme2, cycleCoef, useCyclePosAsInterpolation);
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see org.jvnet.substance.border.StandardBorderPainter#getBottomBorderColor(org.jvnet.substance.color.ColorScheme,
	 *      org.jvnet.substance.color.ColorScheme, double, boolean)
	 */
	@Override
	public Color getBottomBorderColor(ColorScheme interpolationScheme1,
			ColorScheme interpolationScheme2, double cycleCoef,
			boolean useCyclePosAsInterpolation) {
		return super.getTopBorderColor(interpolationScheme1,
				interpolationScheme2, cycleCoef, useCyclePosAsInterpolation);
	}

}
