/*
 * Copyright (c) 2005-2007 Substance Kirill Grouchnikov. All Rights Reserved.
 *
 * Redistribution and use in source and binary forms, with or without 
 * modification, are permitted provided that the following conditions are met:
 * 
 *  o Redistributions of source code must retain the above copyright notice, 
 *    this list of conditions and the following disclaimer. 
 *     
 *  o Redistributions in binary form must reproduce the above copyright notice, 
 *    this list of conditions and the following disclaimer in the documentation 
 *    and/or other materials provided with the distribution. 
 *     
 *  o Neither the name of Substance Kirill Grouchnikov nor the names of 
 *    its contributors may be used to endorse or promote products derived 
 *    from this software without specific prior written permission. 
 *     
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS" 
 * AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, 
 * THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR 
 * PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT OWNER OR 
 * CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, 
 * EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, 
 * PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; 
 * OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, 
 * WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE 
 * OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, 
 * EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE. 
 */
package org.jvnet.substance.skin;

import java.awt.Color;

import org.jvnet.substance.color.ColorScheme;
import org.jvnet.substance.theme.*;
import org.jvnet.substance.theme.SubstanceTheme.ThemeKind;
import org.jvnet.substance.watermark.SubstanceStripeWatermark;

/**
 * <code>Ebony High Contrast</code> skin. This class is <b>for internal use
 * only</b>.
 * 
 * @author Kirill Grouchnikov
 * @since version 3.1
 */
public class EbonyHighContrastSkin extends SubstanceAbstractSkin {
	/**
	 * Creates a new <code>Ebony High Contrast</code> skin.
	 */
	public EbonyHighContrastSkin() {
		ColorScheme metallic = new ColorScheme() {
			private final Color mainUltraLightColor = new Color(125, 126, 128);

			private final Color mainExtraLightColor = new Color(120, 122, 125);

			private final Color mainLightColor = new Color(100, 105, 110);

			private final Color mainMidColor = new Color(90, 92, 95);

			private final Color mainDarkColor = new Color(40, 42, 45);

			private final Color mainUltraDarkColor = new Color(16, 19, 21);

			private final Color foregroundColor = Color.white;

			public Color getForegroundColor() {
				return foregroundColor;
			}

			public Color getUltraLightColor() {
				return mainUltraLightColor;
			}

			public Color getExtraLightColor() {
				return mainExtraLightColor;
			}

			public Color getLightColor() {
				return mainLightColor;
			}

			public Color getMidColor() {
				return mainMidColor;
			}

			public Color getDarkColor() {
				return mainDarkColor;
			}

			public Color getUltraDarkColor() {
				return mainUltraDarkColor;
			}
		};

		ColorScheme gray = new ColorScheme() {
			private final Color mainUltraLightColor = new Color(125, 125, 125);

			private final Color mainExtraLightColor = new Color(120, 120, 120);

			private final Color mainLightColor = new Color(112, 112, 112);

			private final Color mainMidColor = new Color(105, 105, 105);

			private final Color mainDarkColor = new Color(90, 90, 90);

			private final Color mainUltraDarkColor = new Color(50, 50, 50);

			private final Color foregroundColor = Color.white;

			public Color getForegroundColor() {
				return foregroundColor;
			}

			public Color getUltraLightColor() {
				return mainUltraLightColor;
			}

			public Color getExtraLightColor() {
				return mainExtraLightColor;
			}

			public Color getLightColor() {
				return mainLightColor;
			}

			public Color getMidColor() {
				return mainMidColor;
			}

			public Color getDarkColor() {
				return mainDarkColor;
			}

			public Color getUltraDarkColor() {
				return mainUltraDarkColor;
			}
		};

		this.theme = new SubstanceComplexTheme("Ebony High Contrast",
				ThemeKind.DARK, new SubstanceEbonyTheme(), new SubstanceTheme(
						metallic, "Contrast Metallic", ThemeKind.DARK),
				new SubstanceTheme(gray, "Contrast Gray", ThemeKind.DARK),
				new SubstanceEbonyTheme());
		this.watermark = new SubstanceStripeWatermark();
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see org.jvnet.substance.skin.SubstanceSkin#getDisplayName()
	 */
	public String getDisplayName() {
		return "Ebony High Contrast";
	}
}
