/*
 * Copyright (c) 2005-2007 Substance Kirill Grouchnikov. All Rights Reserved.
 *
 * Redistribution and use in source and binary forms, with or without 
 * modification, are permitted provided that the following conditions are met:
 * 
 *  o Redistributions of source code must retain the above copyright notice, 
 *    this list of conditions and the following disclaimer. 
 *     
 *  o Redistributions in binary form must reproduce the above copyright notice, 
 *    this list of conditions and the following disclaimer in the documentation 
 *    and/or other materials provided with the distribution. 
 *     
 *  o Neither the name of Substance Kirill Grouchnikov nor the names of 
 *    its contributors may be used to endorse or promote products derived 
 *    from this software without specific prior written permission. 
 *     
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS" 
 * AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, 
 * THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR 
 * PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT OWNER OR 
 * CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, 
 * EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, 
 * PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; 
 * OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, 
 * WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE 
 * OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, 
 * EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE. 
 */
package org.jvnet.substance.skin;

import org.jvnet.substance.SubstanceLookAndFeel;

/**
 * Standalone look-and-feel that uses the <code>Office Silver 2007</code> skin
 * from {@link OfficeSilver2007Skin}. You can set this look-and-feel by:
 * <ul>
 * <li>-Dswing.defaultlaf=org.jvnet.substance.skin.SubstanceOfficeSilver2007LookAndFeel</li>
 * <li>UIManager.setLookAndFeel("org.jvnet.substance.skin.SubstanceOfficeSilver2007LookAndFeel");</li>
 * <li>UIManager.setLookAndFeel(new SubstanceOfficeSilver2007LookAndFeel());</li>
 * </ul>
 * 
 * @author Kirill Grouchnikov
 * @since version 3.1
 */
public class SubstanceOfficeSilver2007LookAndFeel extends SubstanceLookAndFeel {
	/*
	 * (non-Javadoc)
	 * 
	 * @see org.jvnet.substance.SubstanceLookAndFeel#getID()
	 */
	@Override
	public String getID() {
		return "Substance Office Silver 2007";
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see org.jvnet.substance.SubstanceLookAndFeel#getName()
	 */
	@Override
	public String getName() {
		return "Substance Office Silver 2007";
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see org.jvnet.substance.SubstanceLookAndFeel#initialize()
	 */
	@Override
	public void initialize() {
		super.initialize();
		setSkin(new OfficeSilver2007Skin());
	}
}
