/*
 * Copyright (c) 2005-2007 Substance Kirill Grouchnikov. All Rights Reserved.
 *
 * Redistribution and use in source and binary forms, with or without 
 * modification, are permitted provided that the following conditions are met:
 * 
 *  o Redistributions of source code must retain the above copyright notice, 
 *    this list of conditions and the following disclaimer. 
 *     
 *  o Redistributions in binary form must reproduce the above copyright notice, 
 *    this list of conditions and the following disclaimer in the documentation 
 *    and/or other materials provided with the distribution. 
 *     
 *  o Neither the name of Substance Kirill Grouchnikov nor the names of 
 *    its contributors may be used to endorse or promote products derived 
 *    from this software without specific prior written permission. 
 *     
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS" 
 * AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, 
 * THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR 
 * PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT OWNER OR 
 * CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, 
 * EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, 
 * PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; 
 * OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, 
 * WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE 
 * OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, 
 * EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE. 
 */
package org.jvnet.substance.utils;

import java.awt.Color;
import java.awt.color.ColorSpace;

import javax.swing.plaf.UIResource;

/**
 * Helper extension of {@link Color} class that is based on the current visual
 * status of a delegate control.
 * 
 * @author Kirill Grouchnikov
 */
public abstract class AbstractColorDelegate extends Color implements UIResource {
	/**
	 * Creates a color delegate.
	 * 
	 * @param rgb The base RGB value.
	 */
	protected AbstractColorDelegate(int rgb) {
		super(rgb);
	}

	/**
	 * Returns the delegate color corresponding to the current visual state of
	 * the delegate control.
	 * 
	 * @return Delegate color corresponding to the current visual state of the
	 *         delegate control.
	 */
	protected abstract Color getDelegate();

	/*
	 * (non-Javadoc)
	 * 
	 * @see java.awt.Color#getRGB()
	 */
	@Override
	public int getRGB() {
		return this.getDelegate().getRGB();
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see java.awt.Color#brighter()
	 */
	@Override
	public Color brighter() {
		return this.getDelegate();
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see java.awt.Color#darker()
	 */
	@Override
	public Color darker() {
		return new Color(0x0, true);
		// return this.getDelegate().darker();
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see java.awt.Color#getAlpha()
	 */
	@Override
	public int getAlpha() {
		return this.getDelegate().getAlpha();
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see java.awt.Color#getBlue()
	 */
	@Override
	public int getBlue() {
		return this.getDelegate().getBlue();
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see java.awt.Color#getColorComponents(java.awt.color.ColorSpace,
	 *      float[])
	 */
	@Override
	public float[] getColorComponents(ColorSpace cspace, float[] compArray) {
		return this.getDelegate().getColorComponents(cspace, compArray);
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see java.awt.Color#getColorComponents(float[])
	 */
	@Override
	public float[] getColorComponents(float[] compArray) {
		return this.getDelegate().getColorComponents(compArray);
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see java.awt.Color#getColorSpace()
	 */
	@Override
	public ColorSpace getColorSpace() {
		return this.getDelegate().getColorSpace();
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see java.awt.Color#getComponents(java.awt.color.ColorSpace, float[])
	 */
	@Override
	public float[] getComponents(ColorSpace cspace, float[] compArray) {
		return this.getDelegate().getComponents(cspace, compArray);
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see java.awt.Color#getComponents(float[])
	 */
	@Override
	public float[] getComponents(float[] compArray) {
		return this.getDelegate().getComponents(compArray);
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see java.awt.Color#getGreen()
	 */
	@Override
	public int getGreen() {
		return this.getDelegate().getGreen();
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see java.awt.Color#getRed()
	 */
	@Override
	public int getRed() {
		return this.getDelegate().getRed();
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see java.awt.Color#getRGBColorComponents(float[])
	 */
	@Override
	public float[] getRGBColorComponents(float[] compArray) {
		return this.getDelegate().getRGBColorComponents(compArray);
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see java.awt.Color#getRGBComponents(float[])
	 */
	@Override
	public float[] getRGBComponents(float[] compArray) {
		return this.getDelegate().getRGBComponents(compArray);
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see java.awt.Color#getTransparency()
	 */
	@Override
	public int getTransparency() {
		return this.getDelegate().getTransparency();
	}
}
