/*
 * Copyright (c) 2005-2007 Substance Kirill Grouchnikov. All Rights Reserved.
 *
 * Redistribution and use in source and binary forms, with or without 
 * modification, are permitted provided that the following conditions are met:
 * 
 *  o Redistributions of source code must retain the above copyright notice, 
 *    this list of conditions and the following disclaimer. 
 *     
 *  o Redistributions in binary form must reproduce the above copyright notice, 
 *    this list of conditions and the following disclaimer in the documentation 
 *    and/or other materials provided with the distribution. 
 *     
 *  o Neither the name of Substance Kirill Grouchnikov nor the names of 
 *    its contributors may be used to endorse or promote products derived 
 *    from this software without specific prior written permission. 
 *     
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS" 
 * AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, 
 * THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR 
 * PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT OWNER OR 
 * CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, 
 * EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, 
 * PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; 
 * OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, 
 * WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE 
 * OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, 
 * EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE. 
 */
package org.jvnet.substance.utils;

import java.awt.Component;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;

import org.jvnet.lafwidget.animation.*;
import org.jvnet.lafwidget.utils.LafConstants;
import org.jvnet.substance.SubstanceLookAndFeel;

/**
 * Listener for changing border on focus events. This class is <b>for internal
 * use only</b>.
 * 
 * @author Kirill Grouchnikov
 */
public class FocusBorderListener implements FocusListener {
	/**
	 * The component that is being tracked by <code>this</code> listener.
	 */
	private Component trackedComponent;

	/**
	 * Contains ID of the current looping animation when the
	 * {@link #trackedComponent} is focused. Is <code>null</code> otherwise.
	 */
	protected Long focusAnimationFadeInstanceId;

	/**
	 * Simple constructor.
	 * 
	 * @param c
	 *            The associated tracked component.
	 */
	public FocusBorderListener(Component c) {
		this.trackedComponent = c;
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see java.awt.event.FocusListener#focusGained(java.awt.event.FocusEvent)
	 */
	public void focusGained(FocusEvent e) {
		this.focusAnimationFadeInstanceId = FadeTracker.getInstance()
				.trackFadeLooping(
						SubstanceLookAndFeel.BORDER_ANIMATION_KIND,
						new LafConstants.AnimationKind(new FocusFadeStep(),
								"focus"), this.trackedComponent, null, false,
						new FadeTrackerAdapter() {
							public void fadeEnded(FadeKind fadeKind) {
								trackedComponent.repaint();
							}

							public void fadePerformed(FadeKind fadeKind,
									float fadeCycle10) {
								trackedComponent.repaint();
							}
						}, -1, true);
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see java.awt.event.FocusListener#focusLost(java.awt.event.FocusEvent)
	 */
	public void focusLost(FocusEvent e) {
		this.cancelAnimations();
	}

	/**
	 * Cancels the currently executing animation (if any).
	 */
	public void cancelAnimations() {
		if (this.focusAnimationFadeInstanceId != null) {
			FadeTracker.getInstance().cancelFadeInstance(
					this.focusAnimationFadeInstanceId);
			this.focusAnimationFadeInstanceId = null;
		}
	}
}
