package test;

import java.awt.*;
import java.io.IOException;

import javax.imageio.ImageIO;
import javax.swing.*;

import org.jvnet.substance.skin.SubstanceBusinessLookAndFeel;

public class BigIconFrame {

	public static void main(String[] args) throws Exception {
		JFrame.setDefaultLookAndFeelDecorated(true);
		UIManager.setLookAndFeel(new SubstanceBusinessLookAndFeel());
		SwingUtilities.invokeLater(new Runnable() {
			public void run() {
				JFrame frame = new JFrame("Frame title");
				try {
					frame
							.setIconImage(ImageIO
									.read(BigIconFrame.class
											.getResourceAsStream("/test/resource/firefox.png")));
				} catch (IOException ioe) {
					ioe.printStackTrace();
				}

				JPanel panel = new JPanel() {
					@Override
					protected void paintComponent(Graphics g) {
						Graphics2D g2d = (Graphics2D) g.create();
						g2d.setColor(Color.white);
						g2d.fillRect(0, 0, getWidth(), getHeight());
						try {
							Image im = ImageIO
									.read(BigIconFrame.class
											.getResourceAsStream("/test/resource/firefox.png"));
							g2d.drawImage(im, 10, 10, 16, 16, null);
							g2d.drawImage(im, 30, 10, 32, 32, null);
							g2d.drawImage(im, 60, 10, 48, 48, null);
							g2d
									.setRenderingHint(
											RenderingHints.KEY_INTERPOLATION,
											RenderingHints.VALUE_INTERPOLATION_BILINEAR);
							g2d.setRenderingHint(
									RenderingHints.KEY_TEXT_ANTIALIASING,
									RenderingHints.VALUE_TEXT_ANTIALIAS_ON);

							g2d.drawImage(im, 10, 60, 16, 16, null);
							g2d.drawImage(im, 30, 60, 32, 32, null);
							g2d.drawImage(im, 60, 60, 48, 48, null);
						} catch (Exception exc) {
						}

						g2d.dispose();
					}
				};
				frame.add(panel, BorderLayout.CENTER);

				frame.setSize(400, 300);
				frame.setLocationRelativeTo(null);
				frame.setVisible(true);
				frame.setDefaultCloseOperation(JFrame.EXIT_ON_CLOSE);
			}
		});
	}

}
