package test;

import java.awt.BorderLayout;
import java.awt.FlowLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;

import javax.swing.*;

import org.jvnet.substance.skin.SubstanceBusinessBlackSteelLookAndFeel;

import test.check.SampleInternalFrame;

public class InternalFrame extends JFrame {
	private JDesktopPane jdp;

	public InternalFrame(boolean installTransitionLayout) {
		super("Test application");
		this.setLayout(new BorderLayout());

		JPanel buttons = new JPanel(new FlowLayout(FlowLayout.CENTER, 1, 0));
		this.add(buttons, BorderLayout.SOUTH);

		jdp = new JDesktopPane();
		this.add(jdp, BorderLayout.CENTER);

		JButton addFrame = new JButton("add frame");
		addFrame.addActionListener(new ActionListener() {
			public void actionPerformed(ActionEvent e) {
				SwingUtilities.invokeLater(new Runnable() {
					public void run() {
						JInternalFrame jif = new SampleInternalFrame();
						jif.setBounds(50, 50, 350, 250);
						jdp.add(jif);
						jif.setVisible(true);
						jif.setComponentOrientation(jdp
								.getComponentOrientation());
					}
				});
			}
		});
		buttons.add(addFrame);

		this.setResizable(true);
	}

	public static void main(String[] args) throws Exception {
		UIManager.setLookAndFeel(new SubstanceBusinessBlackSteelLookAndFeel());
		SwingUtilities.invokeLater(new Runnable() {
			public void run() {
				InternalFrame sf = new InternalFrame(true);
				sf.setSize(500, 400);
				sf.setLocationRelativeTo(null);
				sf.setDefaultCloseOperation(JFrame.EXIT_ON_CLOSE);
				sf.setVisible(true);
			}
		});
	}
}
