package test;

import java.awt.*;
import java.awt.color.ColorSpace;
import java.awt.geom.AffineTransform;
import java.awt.geom.Rectangle2D;
import java.awt.image.ColorModel;

import javax.swing.*;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public class RolloverForeground extends JFrame {

	public RolloverForeground() {
		this.setLayout(new FlowLayout());

		final JButton button = new JButton("sample");
		button.setForeground(new Color(0x000000) {
			private Color getDelegate() {
				return button.getModel().isRollover() ? Color.red : Color.black;
			}

			@Override
			public Color brighter() {
				return getDelegate().brighter();
			}

			@Override
			public synchronized PaintContext createContext(ColorModel cm,
					Rectangle r, Rectangle2D r2d, AffineTransform xform,
					RenderingHints hints) {
				return getDelegate().createContext(cm, r, r2d, xform, hints);
			}

			@Override
			public Color darker() {
				return getDelegate().darker();
			}

			@Override
			public boolean equals(Object obj) {
				return getDelegate().equals(obj);
			}

			@Override
			public int getAlpha() {
				return getDelegate().getAlpha();
			}

			@Override
			public int getBlue() {
				return getDelegate().getBlue();
			}

			@Override
			public float[] getColorComponents(ColorSpace cspace,
					float[] compArray) {
				return getDelegate().getColorComponents(cspace, compArray);
			}

			@Override
			public float[] getColorComponents(float[] compArray) {
				return getDelegate().getColorComponents(compArray);
			}

			@Override
			public ColorSpace getColorSpace() {
				return getDelegate().getColorSpace();
			}

			@Override
			public float[] getComponents(ColorSpace cspace, float[] compArray) {
				return getDelegate().getComponents(cspace, compArray);
			}

			@Override
			public float[] getComponents(float[] compArray) {
				return getDelegate().getComponents(compArray);
			}

			@Override
			public int getGreen() {
				return getDelegate().getGreen();
			}

			@Override
			public int getRed() {
				return getDelegate().getRed();
			}

			@Override
			public int getRGB() {
				return getDelegate().getRGB();
			}

			@Override
			public float[] getRGBColorComponents(float[] compArray) {
				return getDelegate().getRGBColorComponents(compArray);
			}

			@Override
			public float[] getRGBComponents(float[] compArray) {
				return getDelegate().getRGBComponents(compArray);
			}

			@Override
			public int getTransparency() {
				return getDelegate().getTransparency();
			}
		});

		this.add(button);
		button.getModel().addChangeListener(new ChangeListener() {
			public void stateChanged(ChangeEvent e) {
				button.repaint();
			}
		});

		this.setSize(200, 100);
		this.setLocationRelativeTo(null);
		this.setDefaultCloseOperation(JFrame.EXIT_ON_CLOSE);
	}

	public static void main(String[] args) throws Exception {
		SwingUtilities.invokeLater(new Runnable() {
			public void run() {
				new RolloverForeground().setVisible(true);
			}
		});
	}
}
