package test;

import java.awt.BorderLayout;

import javax.swing.*;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

import org.jvnet.lafwidget.LafWidget;
import org.jvnet.lafwidget.animation.FadeConfigurationManager;
import org.jvnet.lafwidget.animation.FadeKind;
import org.jvnet.lafwidget.utils.LafConstants.AnimationKind;
import org.jvnet.substance.skin.SubstanceOfficeSilver2007LookAndFeel;

import com.jgoodies.forms.builder.DefaultFormBuilder;
import com.jgoodies.forms.layout.FormLayout;

public class StateTransitions extends JFrame {
	private static JLabel getTrackingLabel(final AbstractButton button) {
		final JLabel label = new JLabel();
		updateText(button.getModel(), label);
		button.getModel().addChangeListener(new ChangeListener() {
			public void stateChanged(ChangeEvent e) {
				SwingUtilities.invokeLater(new Runnable() {
					public void run() {
						updateText(button.getModel(), label);
					}
				});
			}
		});
		return label;
	}

	private static void updateText(ButtonModel model, JLabel label) {
		StringBuilder sb = new StringBuilder();
		sb.append("Model state : ");
		if (model.isRollover())
			sb.append("rollover ");
		if (model.isSelected())
			sb.append("selected ");
		if (model.isPressed())
			sb.append("pressed ");
		if (model.isArmed())
			sb.append("armed ");

		// sb.append("arm:");
		// sb.append(model.isArmed() ? "T" : "F");
		// sb.append(" ");
		// sb.append("pre:");
		// sb.append(model.isPressed() ? "T" : "F");
		// sb.append(" ");
		// sb.append("rol:");
		// sb.append(model.isRollover() ? "T" : "F");
		// sb.append(" ");
		// sb.append("sel:");
		// sb.append(model.isSelected() ? "T" : "F");
		label.setText(sb.toString());
	}

	public StateTransitions() {
		super("Transitions");

		FormLayout lm = new FormLayout("left:pref, 4dlu, fill:pref:grow", "");
		DefaultFormBuilder builder = new DefaultFormBuilder(lm);
		builder.setDefaultDialogBorder();

		JButton regButton = new JButton("push");
		JLabel regLabel = getTrackingLabel(regButton);
		builder.append(regButton, regLabel);

		JToggleButton togButton = new JToggleButton("toggle");
		togButton.setSelected(true);
		JLabel togLabel = getTrackingLabel(togButton);
		builder.append(togButton, togLabel);

		JCheckBox checkbox = new JCheckBox("check");
		checkbox.setSelected(true);
		JLabel checkLabel = getTrackingLabel(checkbox);
		builder.append(checkbox, checkLabel);

		JRadioButton radio = new JRadioButton("radio");
		radio.setSelected(true);
		JLabel radioLabel = getTrackingLabel(radio);
		builder.append(radio, radioLabel);

		this.setLayout(new BorderLayout());
		this.add(builder.getPanel(), BorderLayout.CENTER);

		this.setDefaultCloseOperation(JFrame.EXIT_ON_CLOSE);
		this.setSize(400, 150);
		this.setLocationRelativeTo(null);
	}

	public static void main(String[] args) {
		JFrame.setDefaultLookAndFeelDecorated(true);
		try {
			UIManager
					.setLookAndFeel(new SubstanceOfficeSilver2007LookAndFeel());
		} catch (Exception exc) {
		}
		FadeConfigurationManager.getInstance().allowFades(
				FadeKind.FOCUS_LOOP_ANIMATION);
		UIManager.put(LafWidget.ANIMATION_KIND, AnimationKind.SLOW);
		SwingUtilities.invokeLater(new Runnable() {
			public void run() {
				new StateTransitions().setVisible(true);
			}
		});
	}

}
