/*
 * Copyright (c) 2005-2007 Substance Kirill Grouchnikov. All Rights Reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions are met:
 *
 *  o Redistributions of source code must retain the above copyright notice,
 *    this list of conditions and the following disclaimer.
 *
 *  o Redistributions in binary form must reproduce the above copyright notice,
 *    this list of conditions and the following disclaimer in the documentation
 *    and/or other materials provided with the distribution.
 *
 *  o Neither the name of Substance Kirill Grouchnikov nor the names of
 *    its contributors may be used to endorse or promote products derived
 *    from this software without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS"
 * AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO,
 * THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR
 * PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT OWNER OR
 * CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL,
 * EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO,
 * PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS;
 * OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY,
 * WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE
 * OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE,
 * EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 */
package test.check;

import java.awt.*;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;

import javax.swing.*;
import javax.swing.border.TitledBorder;

import org.jvnet.lafwidget.LafWidget;
import org.jvnet.lafwidget.LafWidgetUtilities;
import org.jvnet.lafwidget.animation.*;
import org.jvnet.lafwidget.utils.LafConstants.AnimationKind;

/**
 * Test application panel for testing {@link JProgressBar} component.
 * 
 * @author Kirill Grouchnikov
 */
public class ProgressBarPanel extends JPanel {
	/**
	 * Horizontal determinate progress bar.
	 */
	private JProgressBar determinateEnHor;

	/**
	 * Horizontal indeterminate progress bar.
	 */
	private JProgressBar indeterminateEnHor;

	/**
	 * Horizontal determinate disabled progress bar.
	 */
	private JProgressBar determinateDisHor;

	/**
	 * Horizontal indeterminate disabled progress bar.
	 */
	private JProgressBar indeterminateDisHor;

	/**
	 * Vertical determinate progress bar.
	 */
	private JProgressBar determinateEnVer;

	/**
	 * Vertical indeterminate progress bar.
	 */
	private JProgressBar indeterminateEnVer;

	/**
	 * Vertical determinate disabled progress bar.
	 */
	private JProgressBar determinateDisVer;

	/**
	 * Vertical indeterminate disabled progress bar.
	 */
	private JProgressBar indeterminateDisVer;

	// private java.util.Timer timer;
	//
	// private TimerTask timerTask;

	/**
	 * ID of the looping task that updates the progress bars.
	 */
	private long progressFadeId;

	/**
	 * Custom fade kind for updating the progress bars.
	 */
	private static final FadeKind PROGRESS_FADE = new FadeKind(
			"substancelaf.testApp.progress", true);

	/**
	 * Button that starts the update of progress bars.
	 */
	private JButton startButton;

	/**
	 * Button that stops the update of progress bars.
	 */
	private JButton stopButton;

	/**
	 * Creates a new panel with progress bars.
	 */
	public ProgressBarPanel() {
		this.setLayout(new BorderLayout());

		JPanel bars = new JPanel();
		GridLayout gLayout = new GridLayout(1, 2);
		gLayout.setHgap(5);
		gLayout.setVgap(5);
		bars.setLayout(gLayout);

		JPanel horizPanel = new JPanel();
		horizPanel.setLayout(new BoxLayout(horizPanel, BoxLayout.Y_AXIS));
		bars.add(horizPanel);

		JPanel vertPanel = new JPanel();
		vertPanel.setLayout(new BoxLayout(vertPanel, BoxLayout.X_AXIS));
		bars.add(vertPanel);

		this.determinateEnHor = new JProgressBar(JProgressBar.HORIZONTAL, 0,
				100);
		this.determinateEnHor.setIndeterminate(false);
		this.determinateEnHor.setStringPainted(true);
		this.determinateEnHor.putClientProperty(LafWidget.ANIMATION_KIND,
				AnimationKind.SLOW);
		JPanel dehPanel = new JPanel();
		dehPanel.add(this.determinateEnHor);
		dehPanel.setBorder(new TitledBorder("Determ enabled"));
		this.indeterminateEnHor = new JProgressBar(JProgressBar.HORIZONTAL, 0,
				100);
		this.indeterminateEnHor.setIndeterminate(true);
		this.indeterminateEnHor.setStringPainted(true);
		JPanel iehPanel = new JPanel();
		iehPanel.add(this.indeterminateEnHor);
		iehPanel.setBorder(new TitledBorder("Indeterm enabled"));

		horizPanel.add(dehPanel);
		horizPanel.add(iehPanel);

		this.determinateDisHor = new JProgressBar(JProgressBar.HORIZONTAL, 0,
				100);
		this.determinateDisHor.setIndeterminate(false);
		this.determinateDisHor.setEnabled(false);
		JPanel ddhPanel = new JPanel();
		ddhPanel.add(this.determinateDisHor);
		ddhPanel.setBorder(new TitledBorder("Determ disabled"));
		this.indeterminateDisHor = new JProgressBar(JProgressBar.HORIZONTAL, 0,
				100);
		this.indeterminateDisHor.setIndeterminate(true);
		this.indeterminateDisHor.setEnabled(false);
		JPanel idhPanel = new JPanel();
		idhPanel.add(this.indeterminateDisHor);
		idhPanel.setBorder(new TitledBorder("Indeterm disabled"));

		horizPanel.add(ddhPanel);
		horizPanel.add(idhPanel);

		this.determinateEnVer = new JProgressBar(JProgressBar.VERTICAL, 0, 100);
		this.determinateEnVer.setIndeterminate(false);
		this.determinateEnVer.setStringPainted(true);
		JPanel devPanel = new JPanel();
		devPanel.add(this.determinateEnVer);
		devPanel.setBorder(new TitledBorder("Determ enabled"));
		this.indeterminateEnVer = new JProgressBar(JProgressBar.VERTICAL, 0,
				100);
		this.indeterminateEnVer.setIndeterminate(true);
		this.indeterminateEnVer.setStringPainted(true);
		JPanel ievPanel = new JPanel();
		ievPanel.add(this.indeterminateEnVer);
		ievPanel.setBorder(new TitledBorder("Indeterm enabled"));

		vertPanel.add(devPanel);
		vertPanel.add(ievPanel);

		this.determinateDisVer = new JProgressBar(JProgressBar.VERTICAL, 0, 100);
		this.determinateDisVer.setIndeterminate(false);
		this.determinateDisVer.setEnabled(false);
		JPanel ddvPanel = new JPanel();
		ddvPanel.add(this.determinateDisVer);
		ddvPanel.setBorder(new TitledBorder("Determ disabled"));
		this.indeterminateDisVer = new JProgressBar(JProgressBar.VERTICAL, 0,
				100);
		this.indeterminateDisVer.setIndeterminate(true);
		this.indeterminateDisVer.setEnabled(false);
		JPanel idvPanel = new JPanel();
		idvPanel.add(this.indeterminateDisVer);
		idvPanel.setBorder(new TitledBorder("Indeterm disabled"));

		vertPanel.add(ddvPanel);
		vertPanel.add(idvPanel);

		this.add(bars, BorderLayout.CENTER);

		JPanel buttons = new JPanel();
		buttons.setLayout(new FlowLayout(FlowLayout.CENTER));
		this.startButton = new JButton("start");
		this.startButton.addActionListener(new ActionListener() {
			public void actionPerformed(ActionEvent e) {
				progressFadeId = FadeTracker.getInstance().trackFadeLooping(
						PROGRESS_FADE,
						LafWidgetUtilities.getAnimationKind(
								ProgressBarPanel.this).derive(0.2f),
						ProgressBarPanel.this, null, false,
						new FadeTrackerAdapter() {
							@Override
							public void fadePerformed(FadeKind fadeKind,
									float fadeCycle10) {
								if (determinateEnHor.getValue() < determinateEnHor
										.getMaximum()) {
									determinateEnHor.setValue(determinateEnHor
											.getValue() + 1);
								}
								if (determinateDisHor.getValue() < determinateDisHor
										.getMaximum()) {
									determinateDisHor
											.setValue(determinateDisHor
													.getValue() + 1);
								}
								if (determinateEnVer.getValue() < determinateEnVer
										.getMaximum()) {
									determinateEnVer.setValue(determinateEnVer
											.getValue() + 1);
								}
								if (determinateDisVer.getValue() < determinateDisVer
										.getMaximum()) {
									determinateDisVer
											.setValue(determinateDisVer
													.getValue() + 1);
								}
							}
						}, -1, false);
				startButton.setEnabled(false);
				stopButton.setEnabled(true);
			}
		});

		this.stopButton = new JButton("stop");
		this.stopButton.setEnabled(false);
		this.stopButton.addActionListener(new ActionListener() {
			public void actionPerformed(ActionEvent e) {
				FadeTracker.getInstance().cancelFadeInstance(progressFadeId);
				stopButton.setEnabled(false);
				startButton.setEnabled(true);
			}
		});

		JButton plus10Button = new JButton("plus 10");
		plus10Button.addActionListener(new ActionListener() {
			public void actionPerformed(ActionEvent e) {
				int newValue = determinateEnHor.getValue() + 10;
				newValue = Math.min(newValue, determinateEnHor.getMaximum());
				determinateEnHor.setValue(newValue);

				newValue = determinateDisHor.getValue() + 10;
				newValue = Math.min(newValue, determinateDisHor.getMaximum());
				determinateDisHor.setValue(newValue);

				newValue = determinateEnVer.getValue() + 10;
				newValue = Math.min(newValue, determinateEnVer.getMaximum());
				determinateEnVer.setValue(newValue);

				newValue = determinateDisVer.getValue() + 10;
				newValue = Math.min(newValue, determinateDisVer.getMaximum());
				determinateDisVer.setValue(newValue);
			}
		});
		buttons.add(plus10Button);

		JButton minus10Button = new JButton("minus 10");
		minus10Button.addActionListener(new ActionListener() {
			public void actionPerformed(ActionEvent e) {
				int newValue = determinateEnHor.getValue() - 10;
				newValue = Math.max(newValue, determinateEnHor.getMinimum());
				determinateEnHor.setValue(newValue);

				newValue = determinateDisHor.getValue() - 10;
				newValue = Math.max(newValue, determinateDisHor.getMinimum());
				determinateDisHor.setValue(newValue);

				newValue = determinateEnVer.getValue() - 10;
				newValue = Math.max(newValue, determinateEnVer.getMinimum());
				determinateEnVer.setValue(newValue);

				newValue = determinateDisVer.getValue() - 10;
				newValue = Math.max(newValue, determinateDisVer.getMinimum());
				determinateDisVer.setValue(newValue);
			}
		});
		buttons.add(minus10Button);

		JButton plus1Button = new JButton("plus 1");
		plus1Button.addActionListener(new ActionListener() {
			public void actionPerformed(ActionEvent e) {
				int newValue = determinateEnHor.getValue() + 1;
				newValue = Math.min(newValue, determinateEnHor.getMaximum());
				determinateEnHor.setValue(newValue);

				newValue = determinateDisHor.getValue() + 1;
				newValue = Math.min(newValue, determinateDisHor.getMaximum());
				determinateDisHor.setValue(newValue);

				newValue = determinateEnVer.getValue() + 1;
				newValue = Math.min(newValue, determinateEnVer.getMaximum());
				determinateEnVer.setValue(newValue);

				newValue = determinateDisVer.getValue() + 1;
				newValue = Math.min(newValue, determinateDisVer.getMaximum());
				determinateDisVer.setValue(newValue);
			}
		});
		buttons.add(plus1Button);

		JButton minus1Button = new JButton("minus 1");
		minus1Button.addActionListener(new ActionListener() {
			public void actionPerformed(ActionEvent e) {
				int newValue = determinateEnHor.getValue() - 1;
				newValue = Math.max(newValue, determinateEnHor.getMinimum());
				determinateEnHor.setValue(newValue);

				newValue = determinateDisHor.getValue() - 1;
				newValue = Math.max(newValue, determinateDisHor.getMinimum());
				determinateDisHor.setValue(newValue);

				newValue = determinateEnVer.getValue() - 1;
				newValue = Math.max(newValue, determinateEnVer.getMinimum());
				determinateEnVer.setValue(newValue);

				newValue = determinateDisVer.getValue() - 1;
				newValue = Math.max(newValue, determinateDisVer.getMinimum());
				determinateDisVer.setValue(newValue);
			}
		});
		buttons.add(minus1Button);

		JButton resetButton = new JButton("reset");
		resetButton.addActionListener(new ActionListener() {
			public void actionPerformed(ActionEvent e) {
				determinateEnHor.setValue(determinateEnHor.getMinimum());
				determinateDisHor.setValue(determinateDisHor.getMinimum());
				determinateEnVer.setValue(determinateEnVer.getMinimum());
				determinateDisVer.setValue(determinateDisVer.getMinimum());
			}
		});

		buttons.add(this.startButton);
		buttons.add(this.stopButton);
		buttons.add(resetButton);

		this.add(buttons, BorderLayout.SOUTH);
	}
}