/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.impl.store.raw.data;

import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import org.apache.derby.iapi.error.StandardException;
import org.apache.derby.iapi.services.io.CompressedNumber;
import org.apache.derby.iapi.services.io.DynamicByteArrayOutputStream;
import org.apache.derby.iapi.services.io.FormatableBitSet;
import org.apache.derby.iapi.services.io.LimitObjectInput;
import org.apache.derby.iapi.store.access.conglomerate.LogicalUndo;
import org.apache.derby.iapi.store.raw.Page;
import org.apache.derby.iapi.store.raw.PageKey;
import org.apache.derby.iapi.store.raw.Transaction;
import org.apache.derby.iapi.store.raw.log.LogInstant;
import org.apache.derby.iapi.store.raw.xact.RawTransaction;
import org.apache.derby.iapi.util.ByteArray;
import org.apache.derby.impl.store.raw.data.BasePage;
import org.apache.derby.impl.store.raw.data.LogicalPageOperation;
import org.apache.derby.impl.store.raw.data.ReclaimSpace;

public final class InsertOperation
extends LogicalPageOperation {
    protected int doMeSlot;
    protected byte insertFlag;
    protected transient int startColumn;
    protected transient ByteArray preparedLog;

    public InsertOperation(RawTransaction rawTransaction, BasePage basePage, int n, int n2, Object[] objectArray, FormatableBitSet formatableBitSet, LogicalUndo logicalUndo, byte by, int n3, boolean bl, int n4, DynamicByteArrayOutputStream dynamicByteArrayOutputStream, int n5, int n6) throws StandardException {
        super(basePage, logicalUndo, n2);
        this.doMeSlot = n;
        this.insertFlag = by;
        this.startColumn = n3;
        try {
            this.writeOptionalDataToBuffer(rawTransaction, dynamicByteArrayOutputStream, objectArray, formatableBitSet, bl, n4, n5, n6);
        }
        catch (IOException iOException) {
            throw StandardException.newException("XSDA4.S", iOException);
        }
    }

    public InsertOperation() {
    }

    public void writeExternal(ObjectOutput objectOutput) throws IOException {
        super.writeExternal(objectOutput);
        CompressedNumber.writeInt(objectOutput, this.doMeSlot);
        objectOutput.writeByte(this.insertFlag);
    }

    public void readExternal(ObjectInput objectInput) throws IOException, ClassNotFoundException {
        super.readExternal(objectInput);
        this.doMeSlot = CompressedNumber.readInt(objectInput);
        this.insertFlag = objectInput.readByte();
    }

    public int getTypeFormatId() {
        return 103;
    }

    public void doMe(Transaction transaction, LogInstant logInstant, LimitObjectInput limitObjectInput) throws StandardException, IOException {
        this.page.storeRecord(logInstant, this.doMeSlot, true, limitObjectInput);
    }

    public void undoMe(Transaction transaction, BasePage basePage, int n, LogInstant logInstant, LimitObjectInput limitObjectInput) throws StandardException, IOException {
        int n2 = basePage.findRecordById(n, 0);
        if ((this.insertFlag & 2) != 0) {
            basePage.purgeRecord(logInstant, n2, n);
            RawTransaction rawTransaction = (RawTransaction)transaction;
            if (rawTransaction.handlesPostTerminationWork() && basePage.isOverflowPage() && basePage.recordCount() == 0) {
                ReclaimSpace reclaimSpace = new ReclaimSpace(2, (PageKey)basePage.getIdentity(), rawTransaction.getDataFactory(), true);
                rawTransaction.addPostTerminationWork(reclaimSpace);
            }
        } else {
            basePage.setDeleteStatus(logInstant, n2, true);
        }
        basePage.setAuxObject(null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void restoreLoggedRow(Object[] objectArray, LimitObjectInput limitObjectInput) throws StandardException, IOException {
        Page page = null;
        try {
            page = this.getContainer().getPage(this.getPageId().getPageNumber());
            ((BasePage)page).restoreRecordFromStream(limitObjectInput, objectArray);
            Object var5_4 = null;
            if (page != null) {
                page.unlatch();
                page = null;
            }
        }
        catch (Throwable throwable) {
            Object var5_5 = null;
            if (page != null) {
                page.unlatch();
                page = null;
            }
            throw throwable;
        }
    }

    public void restoreMe(Transaction transaction, BasePage basePage, LogInstant logInstant, LimitObjectInput limitObjectInput) throws StandardException, IOException {
        this.insertFlag = (byte)(this.insertFlag | 2);
        this.undoMe(transaction, basePage, this.recordId, logInstant, limitObjectInput);
    }

    public ByteArray getPreparedLog() {
        return this.preparedLog;
    }

    public int getNextStartColumn() {
        return this.startColumn;
    }

    private void writeOptionalDataToBuffer(RawTransaction rawTransaction, DynamicByteArrayOutputStream dynamicByteArrayOutputStream, Object[] objectArray, FormatableBitSet formatableBitSet, boolean bl, int n, int n2, int n3) throws StandardException, IOException {
        DynamicByteArrayOutputStream dynamicByteArrayOutputStream2 = null;
        if (dynamicByteArrayOutputStream != null) {
            dynamicByteArrayOutputStream2 = dynamicByteArrayOutputStream;
        } else {
            n = -1;
            n2 = -1;
            dynamicByteArrayOutputStream2 = rawTransaction.getLogBuffer();
        }
        this.startColumn = bl ? this.page.logLongColumn(this.doMeSlot, this.recordId, objectArray[0], dynamicByteArrayOutputStream2) : this.page.logRow(this.doMeSlot, true, this.recordId, objectArray, formatableBitSet, dynamicByteArrayOutputStream2, this.startColumn, this.insertFlag, n, n2, n3);
        int n4 = dynamicByteArrayOutputStream2.getBeginPosition();
        int n5 = dynamicByteArrayOutputStream2.getPosition() - n4;
        this.preparedLog = new ByteArray(dynamicByteArrayOutputStream2.getByteArray(), n4, n5);
    }

    public String toString() {
        return null;
    }
}

