/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.impl.sql.execute;

import org.apache.derby.iapi.error.StandardException;
import org.apache.derby.iapi.services.loader.GeneratedMethod;
import org.apache.derby.iapi.sql.Activation;
import org.apache.derby.iapi.sql.execute.CursorResultSet;
import org.apache.derby.iapi.sql.execute.ExecRow;
import org.apache.derby.iapi.sql.execute.NoPutResultSet;
import org.apache.derby.iapi.store.access.BackingStoreHashtable;
import org.apache.derby.iapi.types.DataValueDescriptor;
import org.apache.derby.iapi.types.RowLocation;
import org.apache.derby.iapi.types.SQLInteger;
import org.apache.derby.impl.sql.execute.NoPutResultSetImpl;

public class ScrollInsensitiveResultSet
extends NoPutResultSetImpl
implements CursorResultSet {
    public NoPutResultSet source;
    private int sourceRowWidth;
    private BackingStoreHashtable ht;
    private ExecRow resultRow;
    private int positionInSource;
    private int currentPosition;
    private int lastPosition;
    private boolean seenFirst;
    private boolean seenLast;
    private boolean beforeFirst = true;
    private boolean afterLast;
    public int numFromHashTable;
    public int numToHashTable;
    private int maxRows;
    private GeneratedMethod closeCleanup;
    private boolean keepAfterCommit;

    public ScrollInsensitiveResultSet(NoPutResultSet noPutResultSet, Activation activation, int n, int n2, double d, double d2, GeneratedMethod generatedMethod) throws StandardException {
        super(activation, n, d, d2);
        this.source = noPutResultSet;
        this.sourceRowWidth = n2;
        this.keepAfterCommit = activation.getResultSetHoldability();
        this.maxRows = activation.getMaxRows();
        this.closeCleanup = generatedMethod;
        this.constructorTime += this.getElapsedMillis(this.beginTime);
    }

    public void openCore() throws StandardException {
        this.beginTime = this.getCurrentTimeMillis();
        this.source.openCore();
        this.isOpen = true;
        ++this.numOpens;
        int[] nArray = new int[1];
        this.ht = new BackingStoreHashtable(this.getTransactionController(), null, nArray, false, -1L, -1L, -1, -1.0f, false, this.keepAfterCommit);
        this.openTime += this.getElapsedMillis(this.beginTime);
        this.setBeforeFirstRow();
    }

    public void reopenCore() throws StandardException {
        boolean bl = true;
        this.beginTime = this.getCurrentTimeMillis();
        this.setBeforeFirstRow();
    }

    public ExecRow getAbsoluteRow(int n) throws StandardException {
        if (!this.isOpen) {
            throw StandardException.newException("XCL16.S", "absolute");
        }
        this.attachStatementContext();
        if (n == 0) {
            this.setBeforeFirstRow();
            return null;
        }
        if (n > 0) {
            if (n <= this.positionInSource) {
                return this.getRowFromHashTable(n);
            }
            ExecRow execRow = null;
            for (int i = n - this.positionInSource; i > 0 && (execRow = this.getNextRowFromSource()) != null; --i) {
            }
            this.currentRow = execRow;
            return execRow;
        }
        if (n < 0) {
            int n2;
            if (!this.seenLast) {
                this.getLastRow();
            }
            if ((n2 = this.lastPosition + 1) + n > 0) {
                return this.getRowFromHashTable(n2 + n);
            }
            return this.setBeforeFirstRow();
        }
        this.currentRow = null;
        return null;
    }

    public ExecRow getRelativeRow(int n) throws StandardException {
        if (!this.isOpen) {
            throw StandardException.newException("XCL16.S", "relative");
        }
        this.attachStatementContext();
        if (n == 0) {
            if (this.beforeFirst || this.afterLast || this.currentPosition == 0) {
                return null;
            }
            return this.getRowFromHashTable(this.currentPosition);
        }
        if (n > 0) {
            return this.getAbsoluteRow(this.currentPosition + n);
        }
        if (this.currentPosition + n < 0) {
            return this.setBeforeFirstRow();
        }
        return this.getAbsoluteRow(this.currentPosition + n);
    }

    public ExecRow setBeforeFirstRow() {
        this.currentPosition = 0;
        this.beforeFirst = true;
        this.afterLast = false;
        this.currentRow = null;
        return null;
    }

    public ExecRow getFirstRow() throws StandardException {
        if (!this.isOpen) {
            throw StandardException.newException("XCL16.S", "first");
        }
        if (this.seenFirst) {
            return this.getRowFromHashTable(1);
        }
        this.attachStatementContext();
        return this.getNextRowCore();
    }

    public ExecRow getNextRowCore() throws StandardException {
        ExecRow execRow = null;
        this.beginTime = this.getCurrentTimeMillis();
        if (!this.isOpen) {
            throw StandardException.newException("XCL16.S", "next");
        }
        execRow = this.currentPosition == this.positionInSource ? this.getNextRowFromSource() : (this.currentPosition < this.positionInSource ? this.getRowFromHashTable(this.currentPosition + 1) : null);
        if (execRow != null) {
            ++this.rowsSeen;
            this.afterLast = false;
        }
        this.currentRow = execRow;
        this.setCurrentRow(this.currentRow);
        this.beforeFirst = false;
        this.nextTime += this.getElapsedMillis(this.beginTime);
        return execRow;
    }

    public ExecRow getPreviousRow() throws StandardException {
        if (!this.isOpen) {
            throw StandardException.newException("XCL16.S", "next");
        }
        if (this.beforeFirst || this.currentPosition == 0) {
            this.currentRow = null;
            return null;
        }
        if (this.afterLast) {
            if (this.lastPosition == 0) {
                this.afterLast = false;
                this.beforeFirst = false;
                this.currentRow = null;
                return null;
            }
            return this.getRowFromHashTable(this.lastPosition);
        }
        --this.currentPosition;
        if (this.currentPosition == 0) {
            this.setBeforeFirstRow();
            return null;
        }
        return this.getRowFromHashTable(this.currentPosition);
    }

    public ExecRow getLastRow() throws StandardException {
        ExecRow execRow;
        if (!this.isOpen) {
            throw StandardException.newException("XCL16.S", "next");
        }
        if (this.seenLast) {
            if (this.lastPosition == 0) {
                this.currentRow = null;
                return null;
            }
            return this.getRowFromHashTable(this.lastPosition);
        }
        this.attachStatementContext();
        while ((execRow = this.getNextRowFromSource()) != null) {
        }
        this.beforeFirst = false;
        this.afterLast = false;
        if (this.lastPosition == 0) {
            this.currentRow = null;
            return null;
        }
        return this.getRowFromHashTable(this.lastPosition);
    }

    public ExecRow setAfterLastRow() throws StandardException {
        if (!this.seenLast) {
            this.getLastRow();
        }
        this.currentPosition = this.lastPosition + 1;
        this.afterLast = true;
        this.beforeFirst = false;
        this.currentRow = null;
        return null;
    }

    public boolean checkRowPosition(int n) throws StandardException {
        switch (n) {
            case 101: {
                if (!this.beforeFirst) {
                    return false;
                }
                if (this.seenFirst) {
                    return true;
                }
                ExecRow execRow = this.getFirstRow();
                if (execRow == null) {
                    return false;
                }
                this.getPreviousRow();
                return true;
            }
            case 102: {
                return this.currentPosition == 1;
            }
            case 103: {
                if (this.beforeFirst || this.afterLast) {
                    return false;
                }
                if (this.seenLast) {
                    return this.currentPosition == this.lastPosition && this.currentPosition != 0;
                }
                int n2 = this.currentPosition;
                boolean bl = false;
                this.getLastRow();
                if (n2 == this.lastPosition && n2 != 0) {
                    bl = true;
                }
                this.getRowFromHashTable(n2);
                return bl;
            }
            case 104: {
                return this.afterLast;
            }
        }
        return false;
    }

    public int getRowNumber() {
        return this.currentRow == null ? 0 : this.currentPosition;
    }

    private ExecRow getNextRowFromSource() throws StandardException {
        ExecRow execRow = null;
        Object var2_2 = null;
        if (this.maxRows > 0 && this.maxRows == this.positionInSource) {
            this.seenLast = true;
            this.lastPosition = this.positionInSource;
            this.afterLast = true;
            return null;
        }
        execRow = this.source.getNextRowCore();
        if (execRow != null) {
            this.seenFirst = true;
            this.beforeFirst = false;
            long l = this.getCurrentTimeMillis();
            if (this.resultRow == null) {
                this.resultRow = this.activation.getExecutionFactory().getValueRow(this.sourceRowWidth);
            }
            ++this.positionInSource;
            this.currentPosition = this.positionInSource;
            this.addRowToHashTable(execRow);
        } else {
            if (!this.seenLast) {
                this.lastPosition = this.positionInSource;
            }
            this.seenLast = true;
            if (this.positionInSource == 0) {
                this.afterLast = false;
            } else {
                this.afterLast = true;
                this.currentPosition = this.positionInSource + 1;
            }
        }
        return execRow;
    }

    public void close() throws StandardException {
        this.beginTime = this.getCurrentTimeMillis();
        if (this.isOpen) {
            if (this.closeCleanup != null) {
                this.closeCleanup.invoke(this.activation);
            }
            this.currentRow = null;
            this.source.close();
            if (this.ht != null) {
                this.ht.close();
                this.ht = null;
            }
            super.close();
        }
        this.setBeforeFirstRow();
        this.closeTime += this.getElapsedMillis(this.beginTime);
    }

    public void finish() throws StandardException {
        this.source.finish();
        this.finishAndRTS();
    }

    public long getTimeSpent(int n) {
        long l = this.constructorTime + this.openTime + this.nextTime + this.closeTime;
        if (n == 0) {
            return l - this.source.getTimeSpent(1);
        }
        return l;
    }

    public RowLocation getRowLocation() throws StandardException {
        return ((CursorResultSet)((Object)this.source)).getRowLocation();
    }

    public ExecRow getCurrentRow() {
        return this.currentRow;
    }

    private void addRowToHashTable(ExecRow execRow) throws StandardException {
        Object[] objectArray = new DataValueDescriptor[this.sourceRowWidth + 1];
        objectArray[0] = new SQLInteger(this.positionInSource);
        DataValueDescriptor[] dataValueDescriptorArray = execRow.getRowArrayClone();
        System.arraycopy(dataValueDescriptorArray, 0, objectArray, 1, dataValueDescriptorArray.length);
        this.ht.put(false, objectArray);
        ++this.numToHashTable;
    }

    private ExecRow getRowFromHashTable(int n) throws StandardException {
        DataValueDescriptor[] dataValueDescriptorArray = (DataValueDescriptor[])this.ht.get(new SQLInteger(n));
        DataValueDescriptor[] dataValueDescriptorArray2 = new DataValueDescriptor[dataValueDescriptorArray.length - 1];
        System.arraycopy(dataValueDescriptorArray, 1, dataValueDescriptorArray2, 0, dataValueDescriptorArray2.length);
        this.resultRow.setRowArray(dataValueDescriptorArray2);
        this.currentPosition = n;
        ++this.numFromHashTable;
        if (this.resultRow != null) {
            this.beforeFirst = false;
            this.afterLast = false;
        }
        this.currentRow = this.resultRow;
        return this.resultRow;
    }
}

