
/*
 * This module contians the code to print, save, and copy panels
 */
 
/* CAUTION : NO ERRROR HANDLING IN THIS VERSION ! */

//#include <utility.h>
//#include <userint.h>
#include <stdlib.h>
#include <stdio.h>
#include <string.h>
#include <math.h>

#include "bmpfile.h"


int WriteColorBitmap(char *PathName)
{

    int                     ImageHeight, ImageWidth, RowBytes, PixelDepth, BytesPerLine;
    int                     *ColorTable, NbBytesColorTable, NbColors;
    int                     NbBytesImage;
    unsigned char   *BitsImage, *TrueBitsImage;
    int                     Err;
    
    int i, j;     
    RRGGBB *Ptr;
    unsigned char Dummy;
    unsigned char *PtrSource, *PtrTarget, *PtrDummy;
    
    FILE                            *Stream;
    BITMAPFILEHEADER    BmpFileHeader;  
    BITMAPINFOHEADER    BmpInfoHeader; 


    //Err = GetBitmapInfo (BmpId, &NbBytesColorTable, &NbBytesImage, NULL);
    //Err = GetBitmapData (BmpId, &RowBytes, &PixelDepth, &ImageWidth, &ImageHeight, ColorTable, BitsImage, NULL);
   
    /* Image characteristics */
    PixelDepth = 8;
    ImageWidth = 240;
    ImageHeight = 128;
    
    /* Compute parameters */
    NbBytesImage = ImageWidth * ImageHeight;
    RowBytes = ImageWidth;
    NbColors = pow(2,PixelDepth);
    NbBytesColorTable = NbColors*sizeof(int);
    BytesPerLine = 4*((RowBytes+3)/4);	/* Z! Modulo 4 */

	/* Alloc mermory */
    BitsImage = (unsigned char*)malloc(NbBytesImage);   
    ColorTable = (int*)malloc(NbBytesColorTable);
    
    /* Fill */
    ColorTable[0] = 0x00ffffff;
    ColorTable[1] = 0x00000000;
    
    for(i=0; i<RowBytes * ImageHeight; i++)
    	BitsImage[i] = i%2;

  	/* Initialize the fields in the BITMAPINFO structure */
  	BmpInfoHeader.biSize              = sizeof(BITMAPINFOHEADER);
  	BmpInfoHeader.biWidth             = ImageWidth;
  	BmpInfoHeader.biHeight            = ImageHeight; /* I can't use negative number, why ????  */
  	BmpInfoHeader.biPlanes            = 1;
  	BmpInfoHeader.biBitCount          = PixelDepth;
  	BmpInfoHeader.biCompression   = BI_RGB;
  	BmpInfoHeader.biSizeImage         = BytesPerLine*ImageHeight; 
  	BmpInfoHeader.biXPelsPerMeter = 0;
  	BmpInfoHeader.biYPelsPerMeter = 0;
  	BmpInfoHeader.biClrUsed = NbColors;
  	BmpInfoHeader.biClrImportant = 0; /* All of the device colors are important.  */

  	BmpFileHeader.bfType = 0x4d42;  /* Signature 0x42="B" 0x4d="M"   */
  	BmpFileHeader.bfSize = sizeof(BITMAPFILEHEADER) + sizeof(BITMAPINFOHEADER) + 
  		NbBytesColorTable + BmpInfoHeader.biSizeImage;
  	BmpFileHeader.bfReserved1 = 0;
  	BmpFileHeader.bfReserved2 = 0;
  	BmpFileHeader.bfOffBits = sizeof(BITMAPFILEHEADER) + sizeof(BITMAPINFOHEADER) + NbBytesColorTable;
    
    /* Open the file */
    Stream = fopen (PathName, "wb+");
    
    Err = fwrite ((void*)&BmpFileHeader, sizeof(BITMAPFILEHEADER), 1, Stream); 
    Err = fwrite ((void*)&BmpInfoHeader, sizeof(BITMAPINFOHEADER), 1, Stream);
    Err = fwrite ((void*)ColorTable, sizeof(int), NbColors , Stream);
  
    /* Create (in memory) the image to be copied on file */
    /* Working that way allow us tro save the array with fwrite function */
    TrueBitsImage = (unsigned char*)calloc(BmpInfoHeader.biSizeImage+BytesPerLine,sizeof(unsigned char)); 
    
    
    /* We copy each scan line already filled with 0 */
    PtrSource = BitsImage;
    PtrTarget = TrueBitsImage;
    for (i=0; i<ImageHeight; i++){
        memcpy (PtrTarget, PtrSource, RowBytes);
        PtrTarget+=BytesPerLine;
        PtrSource+=RowBytes; 
    }
        
    /* I should not do the next few line but I'm not able to use negative value */
    /* for biHeight property so I need to upside down the array by hand ...     */
    /* This code should be remove as soon as I can understand what happen       */
    /* with biHeight                                                            */
    
    /* PtrSource points to the beginning of the last scan line                  */
    PtrSource = TrueBitsImage + ((ImageHeight-1)*BytesPerLine);
    /* PtrTarget points to the beginning of the first scan line                 */
    PtrTarget = TrueBitsImage;
    PtrDummy = (unsigned char*)malloc(BytesPerLine);   
    for (i=0; i<ImageHeight/2; i++){
        memcpy (PtrDummy, PtrTarget, BytesPerLine);
        memcpy (PtrTarget, PtrSource, BytesPerLine);
        memcpy (PtrSource, PtrDummy, BytesPerLine);  
        PtrTarget+=BytesPerLine;
        PtrSource-=BytesPerLine;
    }
    free(PtrDummy);
    
    /* Copy the array of color indices into the BMP file. */
    Err = fwrite ((void*)TrueBitsImage, sizeof(unsigned char), BmpInfoHeader.biSizeImage, Stream);  

    Err = fclose (Stream);
  	free(TrueBitsImage);
   	free(ColorTable);   
    free(BitsImage);
    
    return 0;
}


int WriteBWBitmap(char *PathName)
{

    int                     ImageHeight, ImageWidth, RowBytes, PixelDepth, BytesPerLine;
    int                     *ColorTable, NbBytesColorTable, NbColors;
    int                     NbBytesImage;
    unsigned char   *BitsImage, *TrueBitsImage;
    int                     Err;
    
    int i, j;     
    RRGGBB *Ptr;
    unsigned char Dummy;
    unsigned char *PtrSource, *PtrTarget, *PtrDummy;
    
    FILE                            *Stream;
    BITMAPFILEHEADER    BmpFileHeader;  
    BITMAPINFOHEADER    BmpInfoHeader; 


    //Err = GetBitmapInfo (BmpId, &NbBytesColorTable, &NbBytesImage, NULL);
    //Err = GetBitmapData (BmpId, &RowBytes, &PixelDepth, &ImageWidth, &ImageHeight, ColorTable, BitsImage, NULL);
   
    /* Image characteristics */
    PixelDepth = 1;
    ImageWidth = 240;
    ImageHeight = 128;
    
    /* Compute parameters */
    NbBytesImage = (ImageWidth * ImageHeight) / 8;
    RowBytes = ImageWidth / 8;
    NbColors = pow(2,PixelDepth);
    NbBytesColorTable = NbColors * sizeof(int);
    BytesPerLine = 4*((RowBytes+3)/4);	/* Z! Modulo 4 */

	/* Alloc mermory */
    BitsImage = (unsigned char*)malloc(NbBytesImage);   
    ColorTable = (int*)malloc(NbBytesColorTable);
    
    /* Fill */
    ColorTable[0] = 0x00ffffff;
    ColorTable[1] = 0x00000000;
    
    for(i=0; i<RowBytes * ImageHeight; i++)
    	BitsImage[i] = i % 30;

  	/* Initialize the fields in the BITMAPINFO structure */
  	BmpInfoHeader.biSize              = sizeof(BITMAPINFOHEADER);
  	BmpInfoHeader.biWidth             = ImageWidth;
  	BmpInfoHeader.biHeight            = ImageHeight; /* I can't use negative number, why ????  */
  	BmpInfoHeader.biPlanes            = 1;
  	BmpInfoHeader.biBitCount          = PixelDepth;
  	BmpInfoHeader.biCompression   = BI_RGB;
  	BmpInfoHeader.biSizeImage         = BytesPerLine*ImageHeight; 
  	BmpInfoHeader.biXPelsPerMeter = 0;
  	BmpInfoHeader.biYPelsPerMeter = 0;
  	BmpInfoHeader.biClrUsed = NbColors;
  	BmpInfoHeader.biClrImportant = 0; /* All of the device colors are important.  */

  	BmpFileHeader.bfType = 0x4d42;  /* Signature 0x42="B" 0x4d="M"   */
  	BmpFileHeader.bfSize = sizeof(BITMAPFILEHEADER) + sizeof(BITMAPINFOHEADER) + 
  		NbBytesColorTable + BmpInfoHeader.biSizeImage;
  	BmpFileHeader.bfReserved1 = 0;
  	BmpFileHeader.bfReserved2 = 0;
  	BmpFileHeader.bfOffBits = sizeof(BITMAPFILEHEADER) + sizeof(BITMAPINFOHEADER) + NbBytesColorTable;
    
    /* Open the file */
    Stream = fopen (PathName, "wb+");
    
    Err = fwrite ((void*)&BmpFileHeader, sizeof(BITMAPFILEHEADER), 1, Stream); 
    Err = fwrite ((void*)&BmpInfoHeader, sizeof(BITMAPINFOHEADER), 1, Stream);
    Err = fwrite ((void*)ColorTable, sizeof(int), NbColors , Stream);
  
    /* Create (in memory) the image to be copied on file */
    /* Working that way allow us tro save the array with fwrite function */
    TrueBitsImage = (unsigned char*)calloc(BmpInfoHeader.biSizeImage+BytesPerLine,sizeof(unsigned char)); 
    
    
    /* We copy each scan line already filled with 0 */
    PtrSource = BitsImage;
    PtrTarget = TrueBitsImage;
    for (i=0; i<ImageHeight; i++){
        memcpy (PtrTarget, PtrSource, RowBytes);
        PtrTarget+=BytesPerLine;
        PtrSource+=RowBytes; 
    }
        
    /* I should not do the next few line but I'm not able to use negative value */
    /* for biHeight property so I need to upside down the array by hand ...     */
    /* This code should be remove as soon as I can understand what happen       */
    /* with biHeight                                                            */
    
    /* PtrSource points to the beginning of the last scan line                  */
    PtrSource = TrueBitsImage + ((ImageHeight-1)*BytesPerLine);
    /* PtrTarget points to the beginning of the first scan line                 */
    PtrTarget = TrueBitsImage;
    PtrDummy = (unsigned char*)malloc(BytesPerLine);   
    for (i=0; i<ImageHeight/2; i++){
        memcpy (PtrDummy, PtrTarget, BytesPerLine);
        memcpy (PtrTarget, PtrSource, BytesPerLine);
        memcpy (PtrSource, PtrDummy, BytesPerLine);  
        PtrTarget+=BytesPerLine;
        PtrSource-=BytesPerLine;
    }
    free(PtrDummy);
    
    /* Copy the array of color indices into the BMP file. */
    Err = fwrite ((void*)TrueBitsImage, sizeof(unsigned char), BmpInfoHeader.biSizeImage, Stream);  

    Err = fclose (Stream);
  	free(TrueBitsImage);
   	free(ColorTable);   
    free(BitsImage);
    
    return 0;
}
