; Kernel Reloc file
;
;	It needs also many functions from ext.asm.
;	And you also defined some variables (FirstRun / Error strings / OrgStack / ProgramRef)
;
; NOTE: It used a lot SymFindFirst/SymFindNext, so if you have many files, it could be slow.

RELOC_MAC	MACRO
	tst.b	d7
	beq.s	\\@reloc
		neg.l	\1
\\@reloc
		ENDM

; Called by the relocation function when there is an error.
; Avoid using ER_catch by doing ourselves.
; In :
;	d0.w = Error number
;	a3 -> Library Name
relocation::error
	move.l	RelocStackList-FirstRun(a6),a7	; Restore Stack
	move.l	4(a7),a5			; Restore Main Program Ref

	tst.b	d7				; If we are relocating
	bne.s	\no_unrealloc			; Now unreloc the program before processing the error !
		moveq	#1,d7			; Unreloc the program.
		bsr	relocation_recur	; It will return here with the same exeption !
\no_unrealloc:
	; Get the string of the error		
	ifnd	FLASH_CODE
		lea	mlibrairie(pc),a1	; Complete the string in case of 
		move.l	(a3)+,(a1)+		; a missing library
		move.l	(a3),(a1)+
		lea	mmauvaise+4(pc),a1	; Complete the string in case of 
		move.l	(a3),(a1)		; a wrong library
		move.l	-(a3),-(a1)
	endif
	ifd	FLASH_CODE			; If the target is in Flash, we can't write directly since it is Write-protected.
		lea	KERNEL_EXTRA_STR-FirstRun(a6),a1	; Save the name of the missing library
		move.l	(a3)+,(a1)+		; For Pedrom
		move.l	(a3)+,(a1)+
		clr.w	(a1)+
	endif	
	add.w	d0,d0				; Number *2
	move.w	Error_Table(Pc,d0.w),d0		; Get the offset
	lea	Error_Table(Pc,d0.w),a0		; Get the error string
	move.l	a0,ErrorString-FirstRun(a6)	; Save the error string

	; Find the archived library which are not cleared.
	; ie with reloc_count = 0, locked !
	; I don't know how to avoid this case in my reloc process.
	move.w	UsedLibraryHd-FirstRun(a6),-(a7)
\Start	ROM_THROW HLock
	move.w	UsedLibraryNum-FirstRun(a6),d0
	beq.s	\End				; FIXME: can this occur ?
\Loop		addq.l	#8,a0			; Skip name
		move.l	(a0)+,a5		; Read lib ptr
		tst.b	KHEADER_reloc(a5)	; Reloc count = 0?
		bne.s	\Next			; No.
		btst.b	#7,-4(a5)		; Locked Handle ?
		beq.s	\Next			; No so skip
			bsr	RemoveUsedLibrary
			bra.s	\Start		; ReStart the file check (Because RemoveUsedLibrary modify the table)
\Next		subq.w	#1,d0			; Next file
		bne.s	\Loop
	ROM_THROW HeapUnlock
\End	addq.l	#2,a7

	move.l	(a7)+,RelocStackList-FirstRun(a6)	; Restore Old Stack List
	move.l	(a7)+,a5				; Restore Main Program Ref
	st.b	d0					; An error occured
	rts						;

Error_Table:
	dc.w	mmemory-Error_Table
	dc.w	mpastrouve-Error_Table
	dc.w	mwrong-Error_Table
	dc.w	wrongrom-Error_Table
	dc.w	wrongkernel-Error_Table
	dc.w	parityerror-Error_Table
	
; Standards relocs functions for _nostub programs.
reloc:	movem.l	d1-d7/a1-a6,-(a7)
	moveq	#0,d7			; Relocation Mode selected
relocHd	move.w	d0,-(a7)		; Push handle
	ROM_THROW HeapDeref		; Get address
	addq.w	#2,a7			; Fix sp
	lea	2(a0),a5		; Program Ptr
relocDo	HW2TSR_PATCH a5,d0		; Patch if HW2 TSR
	bsr.s	start_relocation	; Relocation / Unrelocation
	move.l	ErrorString-FirstRun(a6),a0 ; Load the error string in a0 (Return value).
	movem.l	(a7)+,d1-d7/a1-a6	
	rts
reloc2:	movem.l	d1-d7/a1-a6,-(a7)
	moveq	#0,d7			; Relocation Mode selected
relocAn	move.l	a6,a5			; Get Program Ptr
	bra.s	relocDo			; Do relocation / unrelocation
unreloc	movem.l	d1-d7/a1-a6,-(a7)
	moveq	#1,d7			; UnRelocation Mode selected
	bra.s	relocHd			; UnRelocation of the selected handle
unreloc2 movem.l d1-d7/a1-a6,-(a7)
	moveq	#1,d7			; UnRelocation Mode selected
	bra.s	relocAn			; Unrelocation of the ptr


; Unreloc a program.
; In:
;	a5 -> Program.(HeapDeref(h)+2).
; Out:
;	a6 -> FirstRun (Preos Data Ptr)
;	d0.w = 0 if Ok, = -1 if an error occured while unrelocating (I don't think in normal utilisation it is possible).
;Destroy:
;	d7/a6/a1/d0
kernel::unrelocation:
	moveq	#1,d7			; Mode : UnRelocation
	bra.s	start_relocation


; Reloc a program.
; In:
;	a5 -> Program (HeapDeref(h)+2).
; Out:
;	a6 -> FirstRun (Preos Data Ptr)
;	d0.w = 0 if Ok, = -1 if an error occured while relocating.
;Destroy:
;	d7/a6/a1/d0
kernel::relocation:
	moveq	#0,d7				; Mode : Relocation

start_relocation:
	bsr	kernel_install_int		; Get a6 Ptr
	pea	(a5)				; Push a5
	move.l	RelocStackList-FirstRun(a6),-(a7)	; Push old Stack Ptr (To keep the list) (I have choose this order because even vector NULL ptr is a valid entry -Well it will reset the calc but that's all-.
	move.l	a7,RelocStackList-FirstRun(a6)	; Save new Stack Frame Ptr
	bsr.s	relocation_recur		; relocation...
	move.l	(a7)+,RelocStackList-FirstRun(a6) ; Reload Old Ptr
	move.l	(a7)+,a5			; Reload Pc
	rts
	
; In:
;	a5 -> Program
;	a6 -> Data Ptr
;	d7.b = 0 if Reloc
;	d7.b = 1 if UnReloc
;	d7.w += $8000 if Non-recursive 
;	d7.l += $80000000 if Kernel Format V6
relocation_recur:
	movem.l d0-d7/a0-a6,-(a7)

	; Check internal format: 0
	moveq	#4,d0				; Error: Wrong Kernel Version
	ifd	FLASH_CODE
		clr.w	KERNEL_EXTRA_NUMBER-FirstRun(a6)
		lea	Void_str(pc),a3
	endif
	tst.b	KHEADER_format(a5)
	bne	relocation::error
	
	; Read in d6.l the size of the file to avoid overflow while relocating
	moveq	#0,d6
	move.w	-2(a5),d6
	
	; Relocation counter
	tst.b	d7
	bne.s	\unrelloc
		addq.b	#1,KHEADER_reloc(a5)		; Inc Reloc number
		cmp.b	#1,KHEADER_reloc(a5)		; Check if it is the first time
		bne 	fin_relocation			; We reloc this file
			ori.w	#$8000,-4(a5)		; Lock the handle 
			bra.s	\cpt_relloc		; Yes, do not reloc it again. No, reloc it.
\unrelloc
		subq.b	#1,KHEADER_reloc(a5)
		bne 	fin_relocation			; Dec Reloc Number
\cpt_relloc
	
	; Importation.
	lea	KHEADER_size(a5),a4			; a4 -> Import Table

	; 1. Importation of the libraries
	move.w	(a4)+,d5				; d5.w = Number of used libraries
	beq.s	\finish_lib				; If no library, skip Library relocation
		move.w	d5,d0				; Calcul the library offset table
		mulu.w	#10,d0				; d3=10*d5
		lea	0(a4,d0.w),a3			; a3 = List of the offset of the used librairies
		exg	a4,a3				; Exchange a4 & a3
\next_lib:		move.l	a3,a0			; a0 -> Searched Lib name
			move.b	9(a3),d0		; The program needs at least this version
			bsr	find_lib		; Find it (Unarchived / Uncompressed it also).
			move.l	a0,d0			; a0 = Address of the lib
			bne.s	\impect
				moveq	#1,d0			; "Lib not found"
				bra	relocation::error	; Go to error
\impect:		; Reloc the library
			tst.w	d7			; Check if we can do a recursevely relocation
			blt.s	\no_recur
				exg.l	a0,a5		; Relocation libs...
				bsr	relocation_recur
				exg.l	a0,a5		; The library has been relocated
\no_recur		move.l	a0,a1
			adda.w	KHEADER_expOff(a1),a1	; Adress of the export table in a1
			move.w	(a1)+,d1		; Number of exported functions in d1
			move.w	(a4)+,d2		; Number of imported functions in d2
\reloc_lib			moveq	#0,d3		;
				move.w	(a4)+,d3	; Function Number in d3
				cmp.w	d1,d3		; Check if the function number is exported ?
				blt.s	\good_version
\wrong_version:				moveq	#2,d0	; The functions doesn't exist.
					bra	relocation::error
\good_version:			add.w	d3,d3		; Numberx2
				move.w	0(a1,d3.w),d3	; Function offset (from the library start) in d3
				move.l	a0,d4		; Adress of the lib in d4
				add.l	d3,d4		; Adress of the function in d4
				bsr	do_reloc	; Reloc the function
				dbf	d2,\reloc_lib	; Reloc all the imported functions
			lea	10(a3),a3		; Next library name.
			subq.w	#1,d5			; Library Counter -1
			bne.s	\next_lib		; If LibraryCounter>0, continue
\finish_lib						; End of Libraries importation

	; 2. RomCalls Importation
	move.w	(a4)+,d5				; Is there any Rom Calls ?
	beq.s	finish_rom				; No Rom Calls, go to RamCall
ROMBASE2	move.l	(ROM_VECTOR+$C8).l,a3		; ROM CALLS table 
		move.w (a4)+,d5				; Number of imported RomCalls in d5.w
\loop1			moveq	#0,d3			; Clear
			move.w	(a4)+,d3		; Function number in d3
			cmp.l	-4(a3),d3		; Check if the RomCall exists
			blt.s	\valid_romcall		; Yes, continue
\invalid_romcall		moveq	#3,d0		; No, Error: Wrong Rom Version
				ifd	PEDROM		; If Pedrom, we want to know
					move.w	-(a4),KERNEL_EXTRA_NUMBER-FirstRun(a6)	; What is the missing
					lea	Void_str(pc),a3			; romcall.
				endif
				bra	relocation::error
\valid_romcall		lsl.w	#2,d3			; d3*4 -> d3
			move.l	0(a3,d3.w),d4		; Adress of the exported romcall in d4
			ifd	PEDROM
				cmp.l	#INVALID_ROMCALL,d4	; Under Pedrom some RomCalls are not defined, but nervertheles exported
				beq.s	\invalid_romcall	; So I check if the RomCall address == INVALID_ROMCALL.
			endif
			bsr	do_reloc		; Reloc the RomCall
\endloop2	dbra	d5,\loop1			; Continue for all romcalls
finish_rom:						; End of RomCall importation

	;3. RAM relocation table
	move.w	(a4)+,d5				; Number of RAM_CALLS > 0 (But why do Xavier & Rusty have specify this word ???????)
	beq.s	finish_ram				; No RAMCALL, skip
		lea	RAM_TABLE(pc),a3		; a3 -> RamCall Table 
		move.w (a4)+,d5				; Number of different RAM_CALLS !
fonctionRAM:		moveq	#0,d3
			move.w	(a4)+,d3		; Read RAM_CALL number
			move.l	d3,d2			; Copy (because we work on RAM_CALL & EXTRA_RAM_CALL)
			lsl.w	#2,d2			; d2*4 <= Values == adress or longs words.
							; & Remove the word flag & the extra_ram flag
			btst	#14,d3			; Look for EXTRA_RAM_ADDRESS ?
			bne.s	extraramtable		; Yes => Do ExtraRamCall
				cmp.w	#MAX_RAMCALL*4-4,d2	; Check if valid RAM_CALL
				bls.s	validramcall	; Yes continue
					moveq	#4,d0	; Error: Wrong Kernel Version
					ifd	FLASH_CODE
						move.w	-(a4),KERNEL_EXTRA_NUMBER-FirstRun(a6)	; For Pedrom, we want to know what is the missing RamCall
						lea	Void_str(pc),a3
					endif
					bra	relocation::error
validramcall			move.l	0(a3,d2.w),d4		; valeur dans d4
				ifd	V200			; V200 only 
v200_92p_patch				tst.w	d3		; Calculator RamCall ? NOTE: This code will be erased by 'NOP' instruction by the installation code on 92+ & 89
					bne.s	DoRelocRam	; No so skip
						btst.b	#5,KHEADER_flags(a5)	; Check V200 flags for the program ?
						bne.s	DoRelocRam	; Yes do not falsify CALCULATOR
							addq.l	#4,d4	; Falsify the Value of CALCULATOR (because txtrider does some calculus on the values of CALCULATOR : it doesn't expect that CALCULATOR may be different from 0 or 1 !)
				endif
v200_92p_patch_end		bra.s	DoRelocRam
extraramtable			add.w	KHEADER_extROff(a5),d2	; For ExtraRamTable, add to the function offset, the offset of the EXTRA_RAM_TABLE
				moveq	#0,d4			; And 
ExtraRamCalc			move.w	IS89_0_2(a5,d2.l),d4	; Read the value for 89 or 92 (The installation program will the constante IS89_0_2 to 0 on 89 and to 2 on 92+/V200).
DoRelocRam
			tst.w	d3
			blt	do_reloc_word
			bsr	do_reloc
DoRelocRamCont		dbra	d5,fonctionRAM					; Continue for all the imported ramcalls
finish_ram							; End of RAM_CALL relocation

	; 4. Relocation table (the global variables)
	move.l	a5,d4				; Adress of the address to reloc in d4 (The beginning of the program).
	bsr	do_reloc			; Relocation of the variables

	; 5. Relocation of the BSS section
	move.w	KHEADER_impOff(a5),d0		; Offset of the BSS table in d0
	beq.s	finish_BSS			; if =0, there is no BSS section.
		lea	0(a5,d0.w),a4		; Address of the BSS reloc table in a4
		tst.b	d7			; Test relocation ?
		bne.s	\unrelloc		; No go unrelloc
						; Relocation !
			move.l	(a4)+,-(a7)	; Push the size of the BSS block (Long so we can have BSS section > 64K with Pedrom)
			ROM_THROW HeapAllocHigh	; Alloc it as High as possible (and lock it)
			move.w	d0,KHEADER_hdBss(a5)	; Save the handle
			bne.s	\ok_mem		; Check if successfull
				moveq	#0,d0	; No, so an error occured
				bra	relocation::error
\ok_mem			move.w	d0,-(a7)	; Push the handle and 
			ROM_THROW HeapDeref	; Deref to get its adress
			HW2TSR_PATCH	a0,d0	; To prevent some problems if someone writes some code in the BSS section.
			move.l	a0,d4		; adress of the BSS block in d4
			clr.w	(a7)		; Fill with '0'
			pea	(a0)		; Push beginning address
			ROM_THROW memset	; Clear the allocated buffer
			lea	10(a7),a7	; Pop 10 (void *, Character, size)
			bra.s	\brarelloc	; Reloc the code
\unrelloc		move.w	KHEADER_hdBss(a5),-(a7)	; Save the handle of the BSS block
			bne.s	\HdExist	; 
				moveq	#0,d0	; No BSS handle => An error occured
				bra	relocation::error
\HdExist		ROM_THROW HeapDeref	; Deref it
			HW2TSR_PATCH	a0,d0	; To prevent some problems
			move.l	a0,d4		; Adress of the BSS block in d4
			addq.l	#4,a4		; Skip size of BSS block
			ROM_THROW HeapFree	; Free the handle
			clr.w	KHEADER_hdBss(a5) ; No more BSS Handle in the kernel header
			addq.l	#2,a7		; Fix stack ptr
\brarelloc
	bsr	do_reloc			; Relocation of the BSS section.
finish_BSS					; End of relocating the BSS

	; Set the file in-used or un-in-used it.
	move.l	a5,a0
	bsr	kernel::Ptr2Hd
	bsr	kernel::Hd2Sym
	move.l	a0,d0
	beq.s	\SymEntryNotFound
		bset.b	#0,SYM_ENTRY.flags(a0)			; Set InUse
		tst.b	d7
		beq.s	\SymEntryNotFound
			bclr.b	#0,SYM_ENTRY.flags(a0)		; Unset InUse
\SymEntryNotFound:	

	; Test if we will free the temporary copy of the file.
	subq.w	#1,d7				; Unreloc mode ?
	bne.s	fin_relocation
		andi.w	#$7FFF,-4(a5)		; UnLock the handle
		bsr	RemoveUsedLibrary	; Remove the library		
fin_relocation					; End of relocating this file
	movem.l (a7)+,d0-d7/a0-a6		; Restore registers
	clr.w	d0				; Ok
return	rts					; Quit

; Only RamCall uses word relocation, so it is called via a bra instead of bsr
;	a4 -> Offset Table
;	d4.l = Value to add (or to sub)
;	d7 = Relocation / Unrelocation mode
;	a5 -> Program reference
;	d6 = Program Size
do_reloc_word:
	ifnd	FLASH_CODE
		move.w	#$D975,(RelocWordPatch-FirstRun)(a6)	; Word Relocation
		bsr.s	do_reloc
		move.w	#$D9B5,(RelocWordPatch-FirstRun)(a6)	; Long Relocation
		bra	DoRelocRamCont
	endif
	ifd	FLASH_CODE
		RELOC_MAC	d4			; If relocation, d4 =d4. If Unrelocation, d4 =~d4
		moveq	#0,d0
\Loop:		move.w	(a4)+,d0			; Offset in d0
		beq	DoRelocRamCont			; No offset ? => End of reloc function
			bsr.s	checkparity		; Check if no overflow and if offset is pair.
			add.w	d4,0(a5,d0.l)		; Reloc the address
			bra.s	\Loop			; Continue
	endif
			
; In:
;	a4 -> Offset Table
;	d4.l = Value to add (or to sub)
;	d7 = Relocation / Unrelocation mode
;	a5 -> Program reference
;	d6 = Program Size
;Out:
;	Program relocated
;	a4 -> Next section
; Destroy:
;	d4 / d0 / a4
do_reloc:
	RELOC_MAC	d4			; If relocation, d4 =d4. If Unrelocation, d4 =~d4
	moveq	#0,d0
RelocWordLoop:
	move.w	(a4)+,d0			; Offset in d0
	beq.s	return				; No offset ? => End of reloc function
		bsr.s	checkparity		; Check if no overflow and if offset is pair.
RelocWordPatch	add.l	d4,0(a5,d0.l)		; Reloc the address
		bra.s	RelocWordLoop		; Continue
	
; Test of the parity of the offset and control program overflow
; In: 
;	Offset 		d0.l
;	Program Size	d6.l
; Out:
;	Nothing (An exepction is triggered if there is an error).
; Destroy:
;	Nothing
checkparity:
	cmp.l	d6,d0		; Test depassement du programme ?
	bge.s	\error
	btst.l	#0,d0		; Test parite de l'offset
	beq.s	return
\error		moveq	#5,d0	; Stub Error
		bra	relocation::error

; Check if it is a Kernel Program with a good version.
; In:
;	a0.l -> Program (Not +2)
;	d6.b = Min Library Version required
; Out:
;	d0 = 0 if it isn't a kernel program.
IsKernelVersionPrgmPtr:
	movem.l	d1-d2/a0-a1,-(a7)
	bra.s	IsKernelEntry

; Check if it is a Kernel Program.
; In:
;	a0.l -> Sym Entry
; Out:
;	d0 = 0 if it isn't a kernel program.
;	d6.b = 0
IsKernelPrgm:
	clr.b	d6
	
; Check if it is a Kernel Program with a good version.
; In:
;	a0.l -> Sym Entry
;	d6.b = Min Library Version required
; Out:
;	d0 = 0 if it isn't a kernel program.
IsKernelVersionPrgm:
	movem.l	d1-d2/a0-a1,-(a7)
	move.w	SYM_ENTRY.hVal(a0),-(a7)		; Get Handle and pushs it on the stack
	ROM_THROW HeapDeref				; Deref the handle and get its address in a0
	clr.w	d0					; Default: Fail
	tst.w	(a7)+					; In case, there is no handle for the var (Local vars not init for example).
	beq.s	IsKernelFail				; So it fails.
IsKernelEntry	moveq	#0,d1				; Clear d1.l
		move.w	(a0)+,d1			; To read file size (File size is unsigned short).
		cmp.b	#$F3,-1(a0,d1.l)		; Check ASM TAG ?
		bne.s	IsKernelFail			; No, it isn't an ASM file.
			move.l	KHEADER_signa(a0),d1	; Read Magic Signature
			lsr.l	#8,d1			; 
			cmpi.l	#'68k',d1		; It must me be '68k?' where ? is a joker.
			bne.s	IsKernelFail			; 
				cmp.b	KHEADER_version(a0),d6	; Check version number
				sls.b	d0			; Set d0 according to the result of the test
IsKernelFail:
	movem.l	(a7)+,d1-d2/a0-a1
	rts

; Find the missing library in the VAT.
; Unarchive it / Uncompress it / Unpack it if necessary
; In:
;	a0 ->  Lib Name
;	d0.b = Min Library Version required
; Out:
;	a0 -> Unarchived Lib (First line of code) or NULL.
find_lib:
	movem.l	d0-d6/a1-a4,-(a7)
	
	move.b	d0,d6					; Save version
	move.l	a0,a2					; Save Name

	; First search in the current used libraries
	bsr	FindUsedLibrary				; Find library
	move.l	a0,d0
	beq.s	\NotFoundInUsedLibrary
		; Check version Number since it is sure it is a kernel prgm
		cmp.b	KHEADER_version(a0),d6		; Check version number
		bls.s	\OkMinVersion
			suba.l	a0,a0			; WRONG Version Number
\OkMinVersion	bra	\return
\NotFoundInUsedLibrary

	; Second: Search in the VAT
	move.w	#2,-(a7)				; VAT loop
	clr.l	-(a7)					; Parameters for SymFindFirst : All VAT
	ROM_THROW SymFindFirst				; Get first Sym Ptr
\VATloop	; Check if it a Kernel Asm Program, check for the name, and the library version
		move.l	a0,a3				; Save SYM ptr 
		bsr.s	IsKernelVersionPrgm		; First Check if it is a Kernel Program ?
		tst.b	d0				; with the good version number, too !
		beq.s	\VATNextFile			; No kernel Program => No lib file.
		pea	(a0)				; Push found sym
		pea	(a2)				; Push searched file
		ROM_THROW SymCmp			; Compare the 2 files.
		addq.l	#8,a7				; Fix the stack
		tst.w	d0				; Is it the good file ?
		bne.s	\VATNextFile			; No, next file, please.
			move.w	SYM_ENTRY.hVal(a3),(a7)	; We have found it.
			ROM_THROW HeapDeref		; Deref the handle.
\KernelFound		btst.b	#3,(2+KHEADER_flags)(a0); Test the Read Only flag.
			bne.s	\find2			; If ro set, do not unarchive it ! and do not add Hw2Tsr patch !
			cmp.l	#$200000,a0		; Check Archive Mem ? (I don't test the flag because it may be called with PackArchive Static Handle.)
			blt.s	\find			; Archived ? ; Archive => Create a temporary copy.
				move.l	a0,a3		; Save the org adress of the lib
				moveq	#2,d5		; Size + 2 to get the real size of the file
				add.w	(a3),d5		; d5 = File size
				move.l	d5,(a7)		; Push File Size
				ROM_THROW HeapAllocHigh	; And alloc a new Handle for the copy.
				move.w	d0,(a7)		; Check if HeapAlloc successfull 
				beq.s	\LibraryNotFound ; No, so return an error
				ROM_THROW HeapDeref	; to rederef it
				move.l	a0,a1		; Recopy the file
\copy_loop:				move.b	(a3)+,(a1)+
					subq.w	#1,d5		; Better than subq+dbf (6 bytes)
					bne.s	\copy_loop	; subq + bne = 4 bytes (but slower)
\find			HW2TSR_PATCH a0,d0		; Add +$40000 to enter the ghost space if Hw2Tsr
\find2			addq.l	#2,a0			; Skip the File Size
			bsr	AddUsedLibrary		; Add this library in the table (a0-> Ptr/ a2->Name).
			bra.s	\end			; Found !
\VATNextFile	ROM_THROW SymFindNext			; Next File
		move.l	a0,d0				; Check end of VAT ?
		bne.s	\VATloop			; No => continue

	; Third: Search it in the Pach Archives.
	bsr	kernel::ExtractFile			; Search a compressed file with the given name.
	move.w	d0,(a7)					; Success ? Handle != 0?
	beq.s	\LibraryNotFound			; Error
		ROM_THROW HeapDeref			; Deref it
		bsr	IsKernelVersionPrgmPtr		; Check if ok ?
		tst.b	d0
		bne	\KernelFound			; Ok, add it
\LibraryNotFound
	suba.l	a0,a0					; Error: Return NULL
\end	addq.l	#6,a7					; Fix the stack
\return	movem.l	(a7)+,d0-d6/a1-a4			;
	rts						; Return in a0 the lib ptr or NULL.

; Bug: Handle may exist but with Num=0

; Find an already relocated library.
; In: a2 -> LibraryName
; Out: a0 -> Library Ptr or NULL / a1 -> Next entry 
; Destroy: d0-d3/a0-a1
FindUsedLibrary:
	move.w	UsedLibraryHd-FirstRun(a6),-(a7); Handle of used libraries table
	beq.s	\Error				; No used library ?
		ROM_THROW	HeapDeref	; Deref it
		move.w	UsedLibraryNum-FirstRun(a6),d3
		pea	(a2)			; Push Library Name
\Loop:			pea	(a0)		; Push Entry Name
			ROM_THROW SymCmp	; Cmp Entries
			move.l	(a7)+,a0	; Reload entry
			addq.l	#8,a0		; Skip Name
			tst.w	d0		; Same ?
			bne.s	\Next		; No, so next file
				move.l	(a0),a0	; Read Lib addr
				addq.l	#6,a7	; Fix stack ptr
				rts		; Return
\Next			addq.l	#4,a0		; Skip address
			subq.w	#1,d3		; Next entry
			bgt.s	\Loop
		addq.l	#4,a7			; Pop library name
\Error	suba.l	a0,a0				; Error: Not found
AddqRtsUsedLibrary
	addq.l	#2,a7
	rts

; Remove an already relocated library.
; In:
;	a5 -> Library Ptr
; Destroy:
;	d0-d2/a0-a1
RemoveUsedLibrary:
	move.w	UsedLibraryHd-FirstRun(a6),-(a7); Handle of used libraries table
	beq.s	AddqRtsUsedLibrary		; No used library ?
	ROM_THROW	HeapDeref		; Deref it
	addq.l	#2,a7
	move.w	UsedLibraryNum-FirstRun(a6),d0
\Loop:		addq.l	#8,a0			; Skip Lib Name (8 bytes)
		move.l	(a0)+,d1		; Read Lib Ptr
		cmp.l	a5,d1			; Check if same ?
		beq.s	\Done
		subq.w	#1,d0			; Next entry
		bgt.s	\Loop
	bra.s	RtsUsedLibrary			; Error: Not found

\Done	pea	(a0)				; Push Lib Entry ptr (in fact next entry!)
	move.l	d1,a0				; a0 = Library Ptr
	bsr.s	FreeEntryUsedLibrary		; Free this entry
	bsr.s	LastEntryPtrUsedLibrary		; Get the last entry ptr
	move.l	(a7)+,a0			; Get the current entry ptr
	movem.l	(a1),d0-d2			; Read last entry
	movem.l	d0-d2,-(a0)			; Exchange last entry and current entry
	subq.w	#1,UsedLibraryNum-FirstRun(a6)	; Decrement num of entries
	beq.s	FreeTableUsedLibrary		; If no more entry, free the entire table
	
; Realloc the table of the used libraries to the correct size.
ReallocUsedLibrary:
	move.w	UsedLibraryNum-FirstRun(a6),d0	; Num of entries
	mulu.w	#8+4,d0				; x size of an entry
	move.l	d0,-(a7)			; Push the size (arg2 of HeapRealloc function)
	move.w	UsedLibraryHd-FirstRun(a6),-(a7); Push handle
	ROM_THROW HeapRealloc			; Realloc table
	addq.l	#6,a7				; Fix stack ptr
	tst.w	d0				; Check if successfull ?
	beq	relocation::error		; d0.w = 0 = Memory Error
	move.w	d0,UsedLibraryHd-FirstRun(a6)	; Save Handle (Useless execpt if the table wasn't defined before).
RtsUsedLibrary
	rts

FreeTableUsedLibrary:
	move.w	UsedLibraryHd-FirstRun(a6),-(a7)
	clr.w	UsedLibraryHd-FirstRun(a6)
	bra.s	FreePushedHandle
	
; Free the entry: 
;	Free the BSS section of the Library Entry.
;	Free the library itself if it isn't in the VAT.
; In:
;	a0 -> Library
; Destroy:
;	d0-d2/a0-a1
FreeEntryUsedLibrary:
	bsr	kernel::Ptr2Hd			; Get Handle of library
	move.w	d0,-(a7)			; Push handle of library
	beq.s	FreeEntryFail			; H_NULL => Fail!
	move.w	KHEADER_hdBss(a0),-(a7)		; Get Handle of BSS Section
	beq.s	\Skip				; Check if already freed
		ROM_THROW HeapFree		; No, so free it
\Skip	addq.l	#2,a7				; Fix stack
	move.w	(a7),d0				; Reget Lib Handle
	bsr	kernel::Hd2Sym			; Get SYM_ENTRY ptr of the file
	move.l	a0,d0				; Ok?
	bne.s	FreeEntryFail			; Find, so don't erase it!
FreePushedHandle:
	ROM_THROW HeapFree			; Free the library (Doesn't do any HeapCompress)
FreeEntryFail:
	addq.l	#2,a7				; 
	rts
	
; Get a ptr to the last entry in the used library table
; Out:
;	a1 -> Last Entry Ptr
; Destroy:
;	d0-d2/a0-a1
LastEntryPtrUsedLibrary:
	move.w	UsedLibraryHd-FirstRun(a6),-(a7)	
	ROM_THROW HeapDeref			; Deref table
	addq.l	#2,a7				; Fix stack
	move.w	UsedLibraryNum-FirstRun(a6),d0	; Read number of entries in table
	mulu.w	#8+4,d0				; 12*N 
	lea	-12(a0,d0.l),a1			; Get Ptr to Last Entry
	rts
	
; Add a used library. Don't check if a library with the same name was already reallocated.
; May call relocation_error in case of a memory error.
; In:
;	a0 -> Library Ptr
;	a2 -> Library Name
; Destroy:
;	d0-d2/a1-a2
AddUsedLibrary:
	pea	(a0)				; Push Library Ptr
	addq.w	#1,UsedLibraryNum-FirstRun(a6)	; UsedLibraryNum++
	bsr.s	ReallocUsedLibrary		; Realloc handle
	bsr.s	LastEntryPtrUsedLibrary		; Get last entry ptr
	move.l	(a7)+,a0			; Read Lib Ptr
	moveq	#8-1,d0				; 8x
\Loop		move.b	(a2)+,(a1)+		; Copy Name
		dbf	d0,\Loop	
	move.l	a0,(a1)+			; Copy Lib Ptr
	rts
	
; Function of clean-up of the Kernel programs.
; It searchs in the VAT all the kernel programs which are still
; relocated. If it find one, it :
;	+ Calls its exit-point.
;	+ Unrelocates it (without any recursivity).
;	+ Archiveds it / Frees it.
; Destroy:
;	d0-d3/d6/a4-a6
clean_up:
	; *** First, find all the kernel files in the VAT ***
	move.w	#2,-(a7)			; Args for 
	clr.l	-(a7)				; SymFindFirst
	ROM_THROW SymFindFirst			; *and* stop flag pushed on the stack (0) !
\clean_loop					; Loop in VAT
		bsr	IsKernelPrgm		; Test if it is a Kernel program
		tst.w	d0			; Yes or No
		beq.s	\clean_next		; No so skip this file.
			move.w	SYM_ENTRY.hVal(a0),-(a7)	; Get its handle
			ROM_THROW HeapDeref	; Get its address
			addq.l	#2,a7		; Fix stack ptr
			addq.l	#2,a0		; Skip the File Size
			tst.b	KHEADER_reloc(a0) ; Reloc count != 0 ?
			beq.s	\clean_next	; No so skip it.
				pea	(a0)	; Push it on the stack for later treatement (This file is locked)
\clean_next	ROM_THROW SymFindNext		; Next file. Can block if some AMS global vars are corrupted (Solution ON+ESC).
		move.l	a0,d0			; Check if we have another SYM_ENTRY ?
		bne.s	\clean_loop		; Yes, quit

	; *** Then, calls all the exit points ***
	move.l	a7,a4				; Save the tab address (Top of the stack).
\loopexit	move.l	(a4)+,d0		; Get the file
		beq.s	\loopexitend		; End of table, quits.
			move.l	d0,a0		; Get the address of the file
			moveq	#0,d0
			move.w	KHEADER_exit(a0),d0	; Get the exit offset
			beq.s	\no_exit_point		; No exit function, skip it.
			cmpi.b	#$FF,KHEADER_reloc(a0)	; Test if we have already called this exit function ?
			beq.s	\no_exit_point		; Yes, so it crashes. Do not call it again !
				st.b	KHEADER_reloc(a0)	; Protection against infinite call to exit point
				pea	(a4)			; Push a4
				jsr	0(a0,d0.l)		; Call exit point
				move.l	(a7)+,a4		; Pop a4
				bsr	kernel_install_int	; Reinstall a6 / Vectors
\no_exit_point:		bra.s	\loopexit	; Continue for all the relocated kernel files.
\loopexitend
	; *** And, unrelocs the program ***
\loopunrelloc	move.l	(a7)+,d0			; Get the file ptr
		beq.s	\loopunrellocend		; End of table ?
			move.l	d0,a5			; Get the address
			move.b	#1,KHEADER_reloc(a5)	; Reloc count = 1, so that after unreloc it will be 0
			pea	(a4)			; Push register
			move.w	#$8000+1,d7		; Mode Unreallocation without recursivity
			bsr	relocation_recur	; Unreloc the file.
			move.l	(a7)+,a4		; Reget a4
			andi.w	#$7FFF,-4(a5)		; Unlock handle
			bra.s	\loopunrelloc		; Continue
\loopunrellocend		
	; *** Finally Delete all the used libraries ***
	move.w	UsedLibraryHd-FirstRun(a6),(a7)	; Handle of used libraries table
	beq.s	\Done				; No used library ?
		ROM_THROW	HLock		; Deref it and lock it
		move.w	UsedLibraryNum-FirstRun(a6),d3
		move.l	a0,a2
\Loop:			addq.l	#8,a2		; Skip Name
			move.l	(a2)+,a0	; Read Library Ptr
			bsr	FreeEntryUsedLibrary
			subq.w	#1,d3		; Next entry
			bgt.s	\Loop
		ROM_THROW HeapFree		; Free the table
\Done	addq.l	#2,a7
	clr.l	UsedLibraryHd-FirstRun(a6)	; No used library table (Var follows)
	rts
