package tijmp.ui;

import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.util.HashMap;
import java.util.Map;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.TableColumn;

/** A panel that shows child object summary. 
 */
public class ChildObjectTable extends JPanel {

    public ChildObjectTable (Object[] objects) {
	Map<Class<?>, Integer> m = new HashMap<Class<?>, Integer> ();
	for (Object o : objects) {
	    Class<?> c = o.getClass ();
	    Integer i = m.get (c);
	    if (i == null) {
		m.put (c, 1);
	    } else {
		m.put (c, i + 1);
	    }
	}
	Class<?>[] cs = new Class<?>[m.size ()];
	int[] is = new int[m.size ()];
	int i = 0;
	for (Map.Entry<Class<?>, Integer> me : m.entrySet ()) {
	    cs[i] = me.getKey ();
	    is[i] = me.getValue ();
	    i++;
	}
	COTM cotm = new COTM (cs, is);
	JTable table = new JTable (cotm);
	JScrollPane sp = new JScrollPane (table);
	table.setAutoResizeMode (JTable.AUTO_RESIZE_SUBSEQUENT_COLUMNS);
	table.setAutoCreateRowSorter (true);
	TableColumn column = table.getColumnModel ().getColumn (COTM.COL_CLASS);
	column.setPreferredWidth (200);
        table.setPreferredScrollableViewportSize (new Dimension (300, 100));
	table.getRowSorter ().toggleSortOrder (COTM.COL_COUNT);
	table.getRowSorter ().toggleSortOrder (COTM.COL_COUNT);
	table.setDefaultRenderer (Class.class, new ClassRenderer ());

	GridBagLayout gb = new GridBagLayout ();
	GridBagConstraints c = new GridBagConstraints ();
	setLayout (gb);
	c.insets = new Insets (2, 2, 2, 2);

	c.gridx = 0; 
	c.gridy = 0;
	c.weightx = 1;
	c.weighty = 1;
	c.fill = GridBagConstraints.BOTH;
	add (sp, c);
    }
}

class COTM extends AbstractTableModel {
    public static final int COL_CLASS = 0;
    public static final int COL_COUNT = COL_CLASS + 1;

    private static final String[] columnNames = {"Class", "Count"};

    private Class<?>[] cs;
    private int[] is;

    public COTM (Class<?>[] cs, int[] is) {
	this.cs = cs;
	this.is = is;
    }

    @Override public String getColumnName (int col) {
	return columnNames[col];
    }

    public int getRowCount () { 
	return cs.length;
    }
    
    public int getColumnCount () { 
	return columnNames.length; 
    }

    public Object getValueAt (int row, int col) {
	switch (col) {
	case COL_CLASS:
	    return cs[row];
	case COL_COUNT:
	    return is[row];
	}
	throw new IllegalStateException ("unknown column: " + col);
    }

    @Override public Class<?> getColumnClass (int col) {
	switch (col) {
	case COL_CLASS:
	    return Class.class;
	case COL_COUNT:
	    return Integer.class;
	}
	throw new IllegalArgumentException ("unknown column: " + col);
    }
    
    @Override public boolean isCellEditable (int row, int col) { 
	return false; 
    }
    
    @Override public void setValueAt (Object value, int row, int col) {
	throw new IllegalStateException ("non editable table");
    }
}
