-- `Topal': GPG/Pine integration
--
-- Copyright (C) 2001-2003  Phillip J. Brooke
--
--     This program is free software; you can redistribute it and/or modify
--     it under the terms of the GNU General Public License as published by
--     the Free Software Foundation; either version 2 of the License, or
--     (at your option) any later version.
--
--     This program is distributed in the hope that it will be useful,
--     but WITHOUT ANY WARRANTY; without even the implied warranty of
--     MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
--     GNU General Public License for more details.
--
--     You should have received a copy of the GNU General Public License
--     along with this program; if not, write to the Free Software
--     Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

package Externals.GPG is

   -- This returns the return value of GPG.
   -- This function also cleans up the error file to remove
   -- `gpg: Invalid passphrase; please try again ...' messages.
   function GPG_Tee (Input_File  : String;
                     Output_File : String;
                     Err_File    : String) return Integer;

   -- This returns the return value of GPG.
   -- This function also cleans up the error file to remove
   -- `gpg: Invalid passphrase; please try again ...' messages.
   function GPG_Verify_Tee (Input_File  : String;
                            Sig_File    : String;
                            Output_File : String;
                            Err_File    : String) return Integer;

   -- Determine the Micalg code from a file.
   Unrecognised_Micalg : exception;

   function Micalg_From_Filename (Sigfile : in String) return String;

   -- Wrapper for GPG sending.
   GPG_Failed          : exception;

   -- The args should for GPG should be complete (except for the leading
   -- gpg).  The Out_Filename is for checking for the existence of an
   -- output file.
   procedure GPG_Wrap (Args         : in String;
                       Out_Filename : in String);

   -- Find a given key(s); dump into the Target filename.
   procedure Findkey (Key    : in String;
                      Target : in String);

   -- Find a given secret key(s); dump into the Target filename.
   procedure Findkey_Secret (Key    : in String;
                             Target : in String);

   -- List the details of a given key(s); dump into the Target filename.
   procedure Listkey (Key    : in String;
                      Target : in String);

   -- View (with a pager) the given key(s); optionally verbosely.
   procedure Viewkey (Key     : in String;
                      Verbose : in Boolean := False);

end Externals.GPG;
