#include <stdio.h>
#include <stdlib.h>
#include <string.h>

/* init.c:
 *
 * initializes data structures involved in graphics display.  When a tree is
 * loaded, the code in this module associates with each of its structures
 * (branches, nodes, and the tree itself) a graphics data structure.  The
 * routines here allocate and initialize these structures
 */

#include "interface.h"

#include "treedata.h"

initialize_node(n)
treenode n;
{
	nodetypedata f, b;
	nodedata d;

	/* allocate room for generic node data, and room for node data specific
	 * to a particular tree type */
	d=(nodedata)malloc(sizeof(nodedatad));
	f=(nodetypedata)malloc(sizeof(nodetypedatad));
	b=(nodetypedata)malloc(sizeof(nodetypedatad));
	/* store data on node */
	tree_set_data(n, d);
	/* make sure name is not NULL, if it is, we put in "" so that strlen
	 * will always work */
	if(n->name==NULL)
		n->name=(char *)strdup("");
	/* no formatting comment yet */
	d->fmt=NULL;
	/* store room for flower data and boxed data, and point td (pointer to
	 * data for current format) to the boxed data */
	d->flower=f;
	d->td=b;
	d->boxed=b;
	/* this node not selected */
	d->selected=0;
	/* nothing selected, so this node can't be fully selected */
	d->full=0;
	/* setup default label position */
	b->lx=INITBOXLX;
	b->ly=-tfont_height(globals->cfont)/2;
	/* setup color to be default color */
	b->c=globals->fg;
	/* default font */
	b->font=globals->cfont;
	/* create label text field on canvas */
	b->label=ttext_new(globals->c,
		0, 0, 0, 0, globals->cfont,
		tree_get_name(n), globals->fg, globals->bg, NULL, 1);
	/* set label data pointer to point to this tree */
	titem_set_data(b->label, tree_get_tree(n));
	/* create a graphics context for drawing this node */
	b->gc=tcontext_new(globals->c, globals->args);
	/* text is in default position, so yes it is reset */
	b->textisreset=1;
	/* will be using copy mode to draw this node */
	tcontext_set_function(b->gc, tc_copy);
	/* will be drawing in default color */
	tcontext_set_foreground(b->gc, b->c);
	/* angle will be used when formatting is read in, or when auto
	 * formatting is done */
	b->a=0.0;
	/* this node not hidden or doesn't have children hidden */
	b->hidden=0;
	b->childrenhidden=0;
	/* maxthickness not used yet */
	b->maxthickness=0;
	/* same for flower, label in default position */
	f->lx=0;
	f->ly=0;
	/* default color, font */
	f->c=globals->fg;
	f->font=globals->cfont;
	/* create text field for label */
	f->label=ttext_new(globals->c,
		0, 0, 0, 0, globals->cfont,
		tree_get_name(n), globals->fg, globals->bg, NULL, 1);
	titem_set_data(f->label, tree_get_tree(n));
	f->gc=tcontext_new(globals->c, globals->args);
	/* text is reset because it's in a default position */
	f->textisreset=1;
	/* setup graphics context with correct color, function */
	tcontext_set_function(f->gc, tc_copy);
	tcontext_set_foreground(f->gc, f->c);
	/* no angle yet */
	f->a=0.0;
	/* not hidden or childrenHidden */
	f->hidden=0;
	f->childrenhidden=0;
	f->maxthickness=0;
}

initialize_branch(br)
treebranch br;
{
	branchtypedata f, b;
	branchdata d;

	/* allocate room for generic branch data, and room for branch data specific
	 * to a particular tree type */
	d=(branchdata)malloc(sizeof(branchdatad));
	f=(branchtypedata)malloc(sizeof(branchtypedatad));
	b=(branchtypedata)malloc(sizeof(branchtypedatad));
	tree_set_data(br, d);
	/* no formatting comment yet, format is boxed, not selected */
	d->fmt=NULL;
	d->flower=f;
	d->td=b;
	d->boxed=b;
	tree_set_data(br, d);
	d->selected=0;
	/* boxed mode: default color and thickness, stored in the gc also */
	b->c=globals->fg;
	b->thickness=0;
	b->gc=tcontext_new(globals->c, globals->args);
	tcontext_set_function(b->gc, tc_copy);
	tcontext_set_foreground(b->gc, b->c);
	tcontext_set_linewidth(b->gc, b->thickness);
	tcontext_set_capstyle(b->gc, tcap_round);
	/* same for flower mode */
	f->c=globals->fg;
	f->thickness=0;
	f->gc=tcontext_new(globals->c, globals->args);
	tcontext_set_function(f->gc, tc_copy);
	tcontext_set_foreground(f->gc, f->c);
	tcontext_set_linewidth(f->gc, f->thickness);
	tcontext_set_capstyle(f->gc, tcap_round);
}

initialize_tree(t)
tree t;
{
	treedata d;
	treetypedata f, b;

	/* allocate room for generic tree data, and room for tree data specific
	 * to a particular tree type */
	d=(treedata)malloc(sizeof(treedatad));
	f=(treetypedata)malloc(sizeof(treetypedatad));
	b=(treetypedata)malloc(sizeof(treetypedatad));
	tree_set_data(t, d);
	/* no formatting comment yet */
	d->fmt=NULL;
	/* setup to be in boxed mode */
	d->flower=f;
	d->td=b;
	d->boxed=b;
	/* not selected, type value is Boxed */
	d->selected=0;
	d->type=Boxed;
	/* setup position and scale to default values.  0.0 is in tscalex because
	 * it will becomes resolved by the auto-formatting routines */
	f->tx=0.0;
	f->ty=0.0;
	f->tscalex=0.0;
	f->tscaley=1.0;
	f->scale=1.0;
	f->dst=1.0;
	/* tree is on default canvas */
	f->cvs=globals->c;
	/* show all nodes and pct line (scale bar) for starters */
	f->showinternals=1;
	f->showterminals=1;
	f->showpct=1;
	/* pct line (scale bar) gets default font */
	f->pfont=globals->cfont;
	/* default value for scale bar */
	f->pv=.10;
	/* get text field for scale bar percent label */
	f->percent=ttext_new(globals->c,
		0, 0, 0, 0, globals->cfont,
		".10", globals->fg, globals->bg, NULL, 1);
	titem_set_data(f->percent, t);
	/* room is used by sizing routines */
	f->room=1;
	/* just loaded, so not modified */
	f->modified=0;
	/* default color */
	f->c=globals->fg;
	/* make gc */
	f->gc=tcontext_new(globals->c, globals->args);
	/* default values for location of percent line (scale bar) */
	f->px=100.0;
	f->py=100.0;
	/* setup context with default function and color */
	tcontext_set_function(f->gc, tc_copy);
	tcontext_set_foreground(f->gc, f->c);
	/* this is flower data, so branch type is flower */
	f->bt=FlowerBranch;
	/* this format not initialized, so it will be later by auto-formatting
	 * routines */
	f->initialized=0;
	/* original values for validity flags */
	f->percentisreset=1;
	f->boxinvalid=1;
	f->spacinginvalid=1;
	f->formatinvalid=1;
	/* same for boxed mode */
	b->tx=0.0;
	b->ty=0.0;
	b->tscalex=0.0;
	b->tscaley=1.0;
	b->scale=1.0;
	b->dst=1.0;
	b->cvs=globals->c;
	b->showinternals=1;
	b->showterminals=1;
	b->showpct=1;
	b->pfont=globals->cfont;
	b->pv=.10;
	b->percent=ttext_new(globals->c,
		0, 0, 0, 0, globals->cfont,
		".10", globals->fg, globals->bg, NULL, 1);
	titem_set_data(b->percent, t);
	b->room=1;
	b->modified=0;
	b->c=globals->fg;
	b->gc=tcontext_new(globals->c, globals->args);
	b->px=100.0;
	b->py=100.0;
	tcontext_set_function(b->gc, tc_copy);
	tcontext_set_foreground(b->gc, b->c);
	b->bt=globals->bt;
	b->initialized=0;
	b->boxinvalid=1;
	b->spacinginvalid=1;
	b->formatinvalid=1;
	b->percentisreset=1;
}

tree_initialize(i, type)
	/* initialize graphics data for a tree data structure, type says whether
	 * it's a tree, branch, or node */
void *i;
data_type type;
{
	switch(type)
	{
		case tr_tree:
			initialize_tree(i);
			break;
		case tr_branch:
			initialize_branch(i);
			break;
		case tr_node:
			initialize_node(i);
			break;
		default:
			break;
	}
}
