#ifdef MEMDBG
#include "memdbg.h"
#endif

#include "memory.h"
#include "treestruct.h"

#define PAGEW 600
#define PAGEH 780

#define TREEMARGINX 10
#define TREEMARGINY 10
#define TMINWIDTH 10
#define TMINHEIGHT 10

#define INITBOXLX 8
#define INITBOXWIDTH PAGEW-50
#define INITBOXX 25
#define INITBOXY 25

#define INITFLOWERX 25
#define INITFLOWERY 25
#define INITFLOWERSIZE PAGEW-50
#define INITFLOWERLOFF 8

#define SCALEBARLY 8

#define TRESIZERADIUS 4
#define NCHOOSERADIUS 4
#define NHIDDENRADIUS 6
#define PCHOOSERADIUS 4
#define BPICKDISTANCE 4

#define DBLCLICK 400


typedef enum {
	Message,
	BeepMessage,
	Notice,
	OutOfMemory,
	NoError
	} treetool_error;

#define tterr(s,r) {\
	globals->error_string=s;\
	globals->error=r;\
	}

#define setloc(w, x, y) {\
	globals->ewin=(void *)w;\
	globals->ex=x;\
	globals->ey=y;\
	}

#define seteventloc(e) {\
	if(e==NULL)\
	{\
		globals->ewin=globals->c;\
		globals->ex=0;\
		globals->ey=-20;\
	}\
	else\
	{\
		globals->ewin=e;\
		globals->ex=(int)tevent_xview_x(e);\
		globals->ey=(int)tevent_xview_y(e);\
	}\
	}

#define moveframetoloc(f) tframe_move(f, globals->ewin, globals->ex+50, globals->ey+50)

/* graphic tree data structures */

typedef enum {
/*File Ops:*/
	Load,
	Save,
	Print,
	Quit,

/*Overall Ops:*/
	GoEditFormat,
	GoEditStructure,
	GoEditTree,
	GoEditText,
	GoEditMove,
	GoEditFlip,
	GoEditHide,

/*Undo:*/
	Undo,

/*Clipboard:*/
	Cut,
	Copy,
	Paste,
	Delete,
	PasteSubtree,

/*Move:*/
	MoveOnscreen,
	MoveAllOnscreen,

/*Selection:*/
	Select,
	AddToSelection,
	AddNodeListToSelection,
	ToggleSelection,
	RemoveFromSelection,
	ConnectSelections,
	SelectAncestor,
	SelectAll,
	PruneToReps,
	MergeMergeableNodes,
	MoveCarat,
	MoveToParent,
	MoveToLeftChild,
	MoveToRightChild,
	MoveToLeftSister,
	MoveToRightSister,
	MoveBranchSelectionUp,
	MoveBranchSelectionDown,

/* Hiding: */
	HideLevel,
	ShowLevel,
	HideNode,
	ShowNode,

/*Overall Prefs:*/
	ShowHandles,
	HideHandles,
	ShowPageLines,
	HidePageLines,
	ShowTextBoxes,
	HideTextBoxes,
	AutoformatOn,
	AutoformatOff,
	AutomergeOn,
	AutomergeOff,

/*Tree Ops:*/
	SetTreeFormat,
	GetTreeFormat,
	SetTreeBranchFormat,
	ShowInternalNames,
	HideInternalNames,
	ShowTerminalNames,
	HideTerminalNames,
	ShowScaleBar,
	HideScaleBar,
	TranslateNames,
	EvenSpacing,
	ChangeOutgroup,
	SetScale,
	GetScale,
	SetScaleBarPosition,
	SetScaleBarValue,
	GetScaleBarValue,
	SetScaleBarFont,
	GetScaleBarFont,
	SetScaleBarColor,
	GetScaleBarColor,
	MoveTree,
	ResizeTree,
	SetFontAllTrees,

/*Node Ops:*/
	MoveNode,
	RotateNode,
	GetNodeName,
	SetNodeName,
	GetNodePosition,
	SetNodePosition,
	GetNodeLabelPosition,
	SetNodeLabelPosition,
	FlipNode,
	SetNodeFont,
	GetNodeFont,
	FixLabel,
	SetNodeColor,
	GetNodeColor,
	MoveNodeLabel,

/*Branch Ops:*/
	SetThickness,
	GetThickness,
	SetBranchColor,
	GetBranchColor,

/*Selection process:*/
	EveryNodeAndSubtree,
	EveryNode,
	EveryTree,
	EveryBranch,

	NoCommand
    } command;

typedef enum {
    Flower,
    Boxed,
    NoTreeType
    } tree_type;

typedef enum {
    Midway,
    RoomForGroup,
    OnScreen,
    FlowerBranch,
    NoBranchType
    } branch_type;

typedef enum {
    NormalNames,
    FullNames,
    ShortNames,
    AbbreviatedNames,
    NoNameType
    } name_type;

typedef enum {
	MultiSel,			/* selection type */
    NodeSel,			/* selection type */
    BranchPointSel,		/* selection type */
    SubtreeSel,			/* selection type (only clip type) */
	NodeSubtreeSel,		/* chooser type */
    TextSel,			/* Not Used */
    TreeSel,			/* Not Used */
    NoSel
    } selection_type;

typedef enum {
    CaretBack,
    CaretForward,
    CaretStart,
    CaretEnd,
    CaretNoMove
    } caret_movement;

typedef enum {
    Treetool,
    Newick,
    Prolog,
    PostScript,
    PICT,
    List,
    NoFileType
    } file_type;

typedef enum {
	MouseTree,
	MouseText,
	MouseFlip,
	MouseReRoot,
	MouseMove,
	MouseHide,
	MouseNoMode
	} mouse_mode;

/* for a tree */
typedef struct {
    int x, y;		/* location on screen */
    int w, h;		/* size */
	double tx, ty, tscalex, tscaley;
		/* for scaling tree coordinate system to screen coordinate system */
		/* tscale is pixels/distance */
    double scale;	/* tells what distance = 100% */
    double dst;		/* current default distance, for unspec'd ones */
    tcanvas cvs;	/* canvas it's on */
    int showinternals;
    int showterminals;
    int showpct;	/* 1 if showing percent line */
    ttext percent;	/* percent number */
	int percentisreset; /* 1 if percent is in reset location */
    double px, py;	/* location of percent line */
	double plx, ply, plw;	/* coordinates of percent line */
    double pv;		/* value of percent line */
    tfont pfont;	/* font for percent line */
    int room;		/* 1 if saving room for internal nodes on boxed */
    int modified;	/* 1 if modified since loaded */
	tcontext gc;
	tcolor c;		/* color of percent line */
    branch_type bt;	/* =Flowerbranch|Midway|RoomForGroup|OnScreen */
	int initialized;/* 1 if this format has had node locations initialized */
	int boxinvalid; /* 1 if the box is invalid */
	int spacinginvalid; /* 1 if the spacing must be reset */
	int formatinvalid; /* 1 if the format must be recalculated based on
							angle or distance */
	int labelsinvalid;/* 1 if labels must be moved */
    } treetypedatad, *treetypedata;

typedef struct {
    tree_type type;		/* =Flower or Boxed */
    char *fmt;		/* comment that held data */
    treetypedata flower, boxed;
	treetypedata td;
	int selected;
    } treedatad, *treedata;

typedef struct {
    double x, y;	/* position */
    tfont font;
    int lx, ly;	/* label offset */
    tcolor c; /* pointer into list of all colors */
	int tmp;
	double a1, a2, a;
    ttext label;
	tcontext gc;
	int textisreset;	/* is 1 until user moves text */
	int hidden;
	int childrenhidden;
	int maxthickness;
    } nodetypedatad, *nodetypedata;

typedef struct {
    char *fmt;		/* the comment that held data */
    nodetypedata flower, boxed;
	nodetypedata td;
	int selected;
	int full;
    } nodedatad, *nodedata;

typedef struct {
    int thickness;
    tcolor c; /* pointer into list of all colors */
	tcontext gc;
    } branchtypedatad, *branchtypedata;

typedef struct {
    char *fmt;
    branchtypedata flower, boxed;
	branchtypedata td;
	int selected;
	double percentage;
    } branchdatad, *branchdata;

typedef struct {
    selection_type sel_type;
    void *selection;
    selection_type clip_type;
    void *clipboard;
    char *filename;	/* full path of the file */
	list filenames;	/* filenames specified on command line */
    int filename_specified;
    int modified;
	mouse_mode mode;
    int handles, pagelines;
	int beeping;
    tcanvas c;
    tcolor handle_color, root_color, b, w;
	tcolor fg, bg;
	tcontext handle_gc;
	tcontext root_gc;
	tcontext handle_gc_grey;
#ifdef DEBUG
	tcontext testgc1,testgc2;
#endif
    list name, style, size;	/* lists of fonts */
    tframe frame;
    tpanel panel;
    targs args;
    tpmenu file, find, edit, view, formats, nodem;
    tfont cfont;
    tfont listfont;
    branch_type bt;	/* overall branch type */
    tree_type type;		/* =Flower or Boxed */
    list trees;
	int usebuffer;
	int autoformat;
	int automerge;
	double scale;
	int px, py;
    char *treetool_error_strings[NoError+1];
    char *mouse_mode_strings[MouseNoMode+1];
    char *file_type_strings[NoFileType+1];
    char *caret_movement_strings[CaretNoMove+1];
    char *selection_type_strings[NoSel+1];
    char *name_type_strings[NoNameType+1];
    char *branch_type_strings[NoBranchType+1];
    char *tree_type_strings[NoTreeType+1];
    char *command_strings[NoCommand+1];
	char *error_string;
	treetool_error error;
	void *ewin;
	int ex, ey;
	int depth;	/* depth of screen for colors */
	int argc;
	char **argv;
	char **envp;
    } global_datad, *global_data;

/*#define modify() (globals->modified=1)*/
/*#define unmodify() (globals->modified=0)*/

#define thisbranch(b) (((listtmp)b)->obj)

#define ndta(n) ((nodedata)(t_data(n)))
#define bdta(n) ((branchdata)(t_data(n)))
#define tdta(n) ((treedata)(t_data(n)))
#define tndta(n,t) (((t)==Flower)?ndta(n)->flower:(((t)==Boxed)?ndta(n)->boxed:ndta(n)->td))
#define tbdta(n,t) (((t)==Flower)?bdta(n)->flower:(((t)==Boxed)?bdta(n)->boxed:bdta(n)->td))
#define ttdta(n,t) (((t)==Flower)?tdta(n)->flower:(((t)==Boxed)?tdta(n)->boxed:tdta(n)->td))

#define nodex(nd, td) (nd->x*td->tscalex+td->tx+td->x)
#define nodey(nd, td) (nd->y*td->tscaley+td->ty+td->y)
#define noname(n) ((((treenode)n)->name==NULL)?1:(((treenode)n)->name[0]=='\0'))

#define invalidate_refit(t,y) (((y)==Flower)?(tdta(t)->flower->boxinvalid=1):(((y)==Boxed)?(tdta(t)->boxed->boxinvalid=1):(tdta(t)->td->boxinvalid=1)))
#define validate_refit(t,y) (((y)==Flower)?(tdta(t)->flower->boxinvalid=0):(((y)==Boxed)?(tdta(t)->boxed->boxinvalid=0):(tdta(t)->td->boxinvalid=0)))
#define invalidate_spacing(t,y) (((y)==Flower)?(tdta(t)->flower->spacinginvalid=1):(((y)==Boxed)?(tdta(t)->boxed->spacinginvalid=1):(tdta(t)->td->spacinginvalid=1)))
#define validate_spacing(t,y) (((y)==Flower)?(tdta(t)->flower->spacinginvalid=0):(((y)==Boxed)?(tdta(t)->boxed->spacinginvalid=0):(tdta(t)->td->spacinginvalid=0)))
#define invalidate_format(t,y) (((y)==Flower)?(tdta(t)->flower->formatinvalid=1):(((y)==Boxed)?(tdta(t)->boxed->formatinvalid=1):(tdta(t)->td->formatinvalid=1)))
#define validate_format(t,y) (((y)==Flower)?(tdta(t)->flower->formatinvalid=0):(((y)==Boxed)?(tdta(t)->boxed->formatinvalid=0):(tdta(t)->td->formatinvalid=0)))
#define invalidate_labels(t,y) (((y)==Flower)?(tdta(t)->flower->labelsinvalid=1):(((y)==Boxed)?(tdta(t)->boxed->labelsinvalid=1):(tdta(t)->td->labelsinvalid=1)))
#define validate_labels(t,y) (((y)==Flower)?(tdta(t)->flower->labelsinvalid=0):(((y)==Boxed)?(tdta(t)->boxed->labelsinvalid=0):(tdta(t)->td->labelsinvalid=0)))

#define norm_angle(a) while(a>=M_PI)a-=2*M_PI;while(a<-M_PI)a+=2*M_PI
#define pos_angle(a) while(a>=2*M_PI)a-=2*M_PI;while(a<0.0)a+=2*M_PI

#define install(e, a) (e)(NULL, NULL, 0, 0, a)
#define uninstall(e) (e)(NULL, NULL, 1, 0, NULL)
#define printhandler(e) (e)(NULL, NULL, 2, 0, NULL)
#define installing c==NULL && x==0
#define uninstalling c==NULL && x==1
#define printing c==NULL && x==2

/* event handling functions */
extern int do_pick_node();
extern int do_drag_node();
extern int do_drag_text();
extern int do_pick_text();
extern int do_drag_tree();
extern int do_flip_node();
extern int do_hide_node();
extern int do_drag_branch();
extern int do_drag_scale();
extern int do_move_selection();
extern int do_change_text();
extern int do_scroll();
extern int do_clip();
extern int do_drag_box();
extern int do_background();

extern global_data globals;

#include "externs.h"
