/*
 * Decompiled with CFR 0.152.
 */
package org.gjt.mm.mysql.jdbc2;

import java.io.InputStream;
import java.io.Reader;
import java.io.UnsupportedEncodingException;
import java.math.BigDecimal;
import java.sql.Array;
import java.sql.Clob;
import java.sql.Date;
import java.sql.Ref;
import java.sql.SQLException;
import java.sql.Statement;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.Calendar;
import java.util.Map;
import java.util.Vector;
import org.gjt.mm.mysql.Connection;
import org.gjt.mm.mysql.Field;
import org.gjt.mm.mysql.jdbc2.Blob;
import org.gjt.mm.mysql.jdbc2.NotImplemented;
import org.gjt.mm.mysql.jdbc2.PreparedStatement;
import org.gjt.mm.mysql.jdbc2.ResultSetMetaData;

public class ResultSet
extends org.gjt.mm.mysql.ResultSet
implements java.sql.ResultSet {
    protected String _UpdateSQL = null;
    protected String _DeleteSQL = null;
    protected String _InsertSQL = null;
    protected PreparedStatement _Updater = null;
    protected PreparedStatement _Inserter = null;
    protected PreparedStatement _Deleter = null;
    protected Vector _PrimaryKeyIndicies = null;
    protected boolean _updatable = false;
    protected boolean _doing_updates = false;
    protected boolean _on_insert_row = false;
    protected int _fetch_direction = 1000;
    protected int _fetch_size = 0;

    public java.sql.ResultSetMetaData getMetaData() throws SQLException {
        return new ResultSetMetaData(this.Rows, this.Fields);
    }

    public Reader getCharacterStream(int columnIndex) throws SQLException {
        throw new NotImplemented();
    }

    public Reader getCharacterStream(String columnName) throws SQLException {
        throw new NotImplemented();
    }

    public BigDecimal getBigDecimal(int columnIndex) throws SQLException {
        throw new NotImplemented();
    }

    public BigDecimal getBigDecimal(String columnName) throws SQLException {
        throw new NotImplemented();
    }

    public boolean next() throws SQLException {
        if (this._on_insert_row) {
            this._on_insert_row = false;
        }
        if (this._doing_updates) {
            this._doing_updates = false;
        }
        return super.next();
    }

    public boolean isBeforeFirst() throws SQLException {
        if (this.Rows.size() == 0) {
            return false;
        }
        return this.currentRow == -1;
    }

    public synchronized boolean isAfterLast() throws SQLException {
        if (this.Rows.size() == 0) {
            return false;
        }
        return this.currentRow == this.Rows.size();
    }

    public synchronized boolean isFirst() throws SQLException {
        if (this.Rows.size() == 0) {
            return false;
        }
        return this.currentRow == 0;
    }

    public synchronized boolean isLast() throws SQLException {
        if (this.Rows.size() == 0) {
            return false;
        }
        return this.currentRow == this.Rows.size() - 1;
    }

    public synchronized void beforeFirst() throws SQLException {
        if (this._on_insert_row) {
            this._on_insert_row = false;
        }
        if (this._doing_updates) {
            this._doing_updates = false;
        }
        if (this.Rows.size() == 0) {
            return;
        }
        this.currentRow = -1;
        this.This_Row = null;
    }

    public void afterLast() throws SQLException {
        if (this._on_insert_row) {
            this._on_insert_row = false;
        }
        if (this._doing_updates) {
            this._doing_updates = false;
        }
        if (this.Rows.size() != 0) {
            this.currentRow = this.Rows.size();
            this.This_Row = null;
        }
    }

    public synchronized boolean first() throws SQLException {
        if (this._on_insert_row) {
            this._on_insert_row = false;
        }
        if (this.Rows.size() == 0) {
            return false;
        }
        if (this._doing_updates) {
            this._doing_updates = false;
        }
        this.currentRow = 0;
        this.This_Row = (byte[][])this.Rows.elementAt(this.currentRow);
        return true;
    }

    public synchronized boolean last() throws SQLException {
        if (this.Rows.size() == 0) {
            return false;
        }
        if (this._on_insert_row) {
            this._on_insert_row = false;
        }
        if (this._doing_updates) {
            this._doing_updates = false;
        }
        this.currentRow = this.Rows.size() - 1;
        this.This_Row = (byte[][])this.Rows.elementAt(this.currentRow);
        return true;
    }

    public int getRow() throws SQLException {
        if (this.currentRow < 0 || this.currentRow > this.Rows.size() || this.Rows.size() == 0) {
            return 0;
        }
        return this.currentRow + 1;
    }

    public synchronized boolean absolute(int row) throws SQLException {
        if (this.Rows.size() == 0) {
            return false;
        }
        if (row == 0) {
            throw new SQLException("Cannot absolute position to row 0", "S1009");
        }
        if (this._on_insert_row) {
            this._on_insert_row = false;
        }
        if (this._doing_updates) {
            this._doing_updates = false;
        }
        if (row == 1) {
            return this.first();
        }
        if (row == -1) {
            return this.last();
        }
        if (row > this.Rows.size()) {
            this.afterLast();
            return false;
        }
        if (row < 0) {
            int new_row_position = this.Rows.size() + row + 1;
            if (new_row_position <= 0) {
                this.beforeFirst();
                return false;
            }
            return this.absolute(new_row_position);
        }
        this.currentRow = --row;
        this.This_Row = (byte[][])this.Rows.elementAt(this.currentRow);
        return true;
    }

    public synchronized boolean relative(int rows) throws SQLException {
        if (this.Rows.size() == 0) {
            return false;
        }
        int new_row_position = this.currentRow + rows + 1;
        return this.absolute(new_row_position);
    }

    public boolean previous() throws SQLException {
        if (this._on_insert_row) {
            this._on_insert_row = false;
        }
        if (this._doing_updates) {
            this._doing_updates = false;
        }
        return this.prev();
    }

    public void setFetchDirection(int direction) throws SQLException {
        if (direction != 1000 && direction != 1001) {
            throw new SQLException("Illegal value for fetch direction", "S1009");
        }
        this._fetch_direction = direction;
    }

    public int getFetchDirection() throws SQLException {
        return this._fetch_direction;
    }

    public void setFetchSize(int rows) throws SQLException {
        if (rows < 0) {
            throw new SQLException("Value must be between 0 and getMaxRows()", "S1009");
        }
        this._fetch_size = rows;
    }

    public int getFetchSize() throws SQLException {
        return this._fetch_size;
    }

    public int getType() throws SQLException {
        return 1004;
    }

    public int getConcurrency() throws SQLException {
        if (this._updatable) {
            return 1008;
        }
        return 1007;
    }

    public boolean rowUpdated() throws SQLException {
        throw new NotImplemented();
    }

    public boolean rowInserted() throws SQLException {
        throw new NotImplemented();
    }

    public boolean rowDeleted() throws SQLException {
        throw new NotImplemented();
    }

    public void updateNull(int columnIndex) throws SQLException {
        if (!this._on_insert_row) {
            if (!this._doing_updates) {
                this._doing_updates = true;
                this.syncUpdate();
            }
            this._Updater.setNull(columnIndex, 0);
        } else {
            this._Inserter.setNull(columnIndex, 0);
        }
    }

    public void updateBoolean(int columnIndex, boolean x) throws SQLException {
        if (!this._on_insert_row) {
            if (!this._doing_updates) {
                this._doing_updates = true;
                this.syncUpdate();
            }
            this._Updater.setBoolean(columnIndex, x);
        } else {
            this._Inserter.setBoolean(columnIndex, x);
        }
    }

    public void updateByte(int columnIndex, byte x) throws SQLException {
        if (!this._on_insert_row) {
            if (!this._doing_updates) {
                this._doing_updates = true;
                this.syncUpdate();
            }
            this._Updater.setByte(columnIndex, x);
        } else {
            this._Inserter.setByte(columnIndex, x);
        }
    }

    public void updateShort(int columnIndex, short x) throws SQLException {
        if (!this._on_insert_row) {
            if (!this._doing_updates) {
                this._doing_updates = true;
                this.syncUpdate();
            }
            this._Updater.setShort(columnIndex, x);
        } else {
            this._Inserter.setShort(columnIndex, x);
        }
    }

    public void updateInt(int columnIndex, int x) throws SQLException {
        if (!this._on_insert_row) {
            if (!this._doing_updates) {
                this._doing_updates = true;
                this.syncUpdate();
            }
            this._Updater.setInt(columnIndex, x);
        } else {
            this._Inserter.setInt(columnIndex, x);
        }
    }

    public void updateLong(int columnIndex, long x) throws SQLException {
        if (!this._on_insert_row) {
            if (!this._doing_updates) {
                this._doing_updates = true;
                this.syncUpdate();
            }
            this._Updater.setLong(columnIndex, x);
        } else {
            this._Inserter.setLong(columnIndex, x);
        }
    }

    public void updateFloat(int columnIndex, float x) throws SQLException {
        if (!this._on_insert_row) {
            if (!this._doing_updates) {
                this._doing_updates = true;
                this.syncUpdate();
            }
            this._Updater.setFloat(columnIndex, x);
        } else {
            this._Inserter.setFloat(columnIndex, x);
        }
    }

    public void updateDouble(int columnIndex, double x) throws SQLException {
        if (!this._on_insert_row) {
            if (!this._doing_updates) {
                this._doing_updates = true;
                this.syncUpdate();
            }
            this._Updater.setDouble(columnIndex, x);
        } else {
            this._Inserter.setDouble(columnIndex, x);
        }
    }

    public void updateBigDecimal(int columnIndex, BigDecimal x) throws SQLException {
        if (!this._on_insert_row) {
            if (!this._doing_updates) {
                this._doing_updates = true;
                this.syncUpdate();
            }
            this._Updater.setBigDecimal(columnIndex, x);
        } else {
            this._Inserter.setBigDecimal(columnIndex, x);
        }
    }

    public void updateString(int columnIndex, String x) throws SQLException {
        if (!this._on_insert_row) {
            if (!this._doing_updates) {
                this._doing_updates = true;
                this.syncUpdate();
            }
            this._Updater.setString(columnIndex, x);
        } else {
            this._Inserter.setString(columnIndex, x);
        }
    }

    public void updateBytes(int columnIndex, byte[] x) throws SQLException {
        if (!this._on_insert_row) {
            if (!this._doing_updates) {
                this._doing_updates = true;
                this.syncUpdate();
            }
            this._Updater.setBytes(columnIndex, x);
        } else {
            this._Inserter.setBytes(columnIndex, x);
        }
    }

    public void updateDate(int columnIndex, Date x) throws SQLException {
        if (!this._on_insert_row) {
            if (!this._doing_updates) {
                this._doing_updates = true;
                this.syncUpdate();
            }
            this._Updater.setDate(columnIndex, x);
        } else {
            this._Inserter.setDate(columnIndex, x);
        }
    }

    public void updateTime(int columnIndex, Time x) throws SQLException {
        if (!this._on_insert_row) {
            if (!this._doing_updates) {
                this._doing_updates = true;
                this.syncUpdate();
            }
            this._Updater.setTime(columnIndex, x);
        } else {
            this._Inserter.setTime(columnIndex, x);
        }
    }

    public void updateTimestamp(int columnIndex, Timestamp x) throws SQLException {
        if (!this._on_insert_row) {
            if (!this._doing_updates) {
                this._doing_updates = true;
                this.syncUpdate();
            }
            this._Updater.setTimestamp(columnIndex, x);
        } else {
            this._Inserter.setTimestamp(columnIndex, x);
        }
    }

    public void updateAsciiStream(int columnIndex, InputStream x, int length) throws SQLException {
        throw new NotImplemented();
    }

    public void updateBinaryStream(int columnIndex, InputStream x, int length) throws SQLException {
        throw new NotImplemented();
    }

    public void updateCharacterStream(int columnIndex, Reader x, int length) throws SQLException {
        throw new NotImplemented();
    }

    public void updateObject(int columnIndex, Object x, int scale) throws SQLException {
        if (!this._on_insert_row) {
            if (!this._doing_updates) {
                this._doing_updates = true;
                this.syncUpdate();
            }
            this._Updater.setObject(columnIndex, x);
        } else {
            this._Inserter.setObject(columnIndex, x);
        }
    }

    public void updateObject(int columnIndex, Object x) throws SQLException {
        if (!this._on_insert_row) {
            if (!this._doing_updates) {
                this._doing_updates = true;
                this.syncUpdate();
            }
            this._Updater.setObject(columnIndex, x);
        } else {
            this._Inserter.setObject(columnIndex, x);
        }
    }

    public void updateNull(String columnName) throws SQLException {
        this.updateNull(this.findColumn(columnName));
    }

    public void updateBoolean(String columnName, boolean x) throws SQLException {
        this.updateBoolean(this.findColumn(columnName), x);
    }

    public void updateByte(String columnName, byte x) throws SQLException {
        this.updateByte(this.findColumn(columnName), x);
    }

    public void updateShort(String columnName, short x) throws SQLException {
        this.updateShort(this.findColumn(columnName), x);
    }

    public void updateInt(String columnName, int x) throws SQLException {
        this.updateInt(this.findColumn(columnName), x);
    }

    public void updateLong(String columnName, long x) throws SQLException {
        this.updateLong(this.findColumn(columnName), x);
    }

    public void updateFloat(String columnName, float x) throws SQLException {
        this.updateFloat(this.findColumn(columnName), x);
    }

    public void updateDouble(String columnName, double x) throws SQLException {
        this.updateDouble(this.findColumn(columnName), x);
    }

    public void updateBigDecimal(String columnName, BigDecimal x) throws SQLException {
        this.updateBigDecimal(this.findColumn(columnName), x);
    }

    public void updateString(String columnName, String x) throws SQLException {
        this.updateString(this.findColumn(columnName), x);
    }

    public void updateBytes(String columnName, byte[] x) throws SQLException {
        this.updateBytes(this.findColumn(columnName), x);
    }

    public void updateDate(String columnName, Date x) throws SQLException {
        this.updateDate(this.findColumn(columnName), x);
    }

    public void updateTime(String columnName, Time x) throws SQLException {
        this.updateTime(this.findColumn(columnName), x);
    }

    public void updateTimestamp(String columnName, Timestamp x) throws SQLException {
        this.updateTimestamp(this.findColumn(columnName), x);
    }

    public void updateAsciiStream(String columnName, InputStream x, int length) throws SQLException {
        throw new NotImplemented();
    }

    public void updateBinaryStream(String columnName, InputStream x, int length) throws SQLException {
        throw new NotImplemented();
    }

    public void updateCharacterStream(String columnName, Reader reader, int length) throws SQLException {
        throw new NotImplemented();
    }

    public void updateObject(String columnName, Object x, int scale) throws SQLException {
        this.updateObject(this.findColumn(columnName), x);
    }

    public void updateObject(String columnName, Object x) throws SQLException {
        this.updateObject(this.findColumn(columnName), x);
    }

    public void insertRow() throws SQLException {
        if (!this._on_insert_row) {
            throw new SQLException("Not on insert row");
        }
        this._Inserter.executeUpdate();
        int num_fields = this.Fields.length;
        byte[][] NewRow = new byte[num_fields][];
        int i = 0;
        while (i < num_fields) {
            NewRow[i] = this._Inserter.getBytes(i);
            ++i;
        }
        this.Rows.addElement(NewRow);
        this._Inserter.clearParameters();
    }

    public synchronized void updateRow() throws SQLException {
        if (this._doing_updates) {
            this._Updater.executeUpdate();
            int num_fields = this.Fields.length;
            int i = 0;
            while (i < num_fields) {
                this.This_Row[i] = this._Updater.getBytes(i);
                ++i;
            }
            this._doing_updates = false;
        }
    }

    public void deleteRow() throws SQLException {
        if (this._on_insert_row) {
            throw new SQLException("Can not call deleteRow() when on insert row");
        }
        if (this.Rows.size() == 0) {
            throw new SQLException("Can't deleteRow() on empty result set");
        }
        if (this._Deleter == null) {
            if (this._DeleteSQL == null) {
                this.generateStatements();
            }
            this._Deleter = (PreparedStatement)this.Conn.prepareStatement(this._DeleteSQL);
        }
        this._Deleter.clearParameters();
        String Encoding = null;
        if (this.Conn.useUnicode()) {
            Encoding = this.Conn.getEncoding();
        }
        try {
            int num_keys = this._PrimaryKeyIndicies.size();
            if (num_keys == 1) {
                int index = (Integer)this._PrimaryKeyIndicies.elementAt(0);
                String CurrentVal = Encoding != null ? new String(this.This_Row[index], Encoding) : new String(this.This_Row[index]);
                this._Deleter.setString(1, CurrentVal);
            } else {
                int i = 0;
                while (i < num_keys) {
                    int index = (Integer)this._PrimaryKeyIndicies.elementAt(i);
                    String CurrentVal = Encoding != null ? new String(this.This_Row[index], Encoding) : new String(this.This_Row[index]);
                    this._Deleter.setString(i + 1, CurrentVal);
                    ++i;
                }
            }
            this._Deleter.executeUpdate();
            this.Rows.removeElementAt(this.currentRow);
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            throw new SQLException("Unsupported character encoding '" + this.Conn.getEncoding() + "'");
        }
    }

    public void refreshRow() throws SQLException {
        throw new NotImplemented();
    }

    public void cancelRowUpdates() throws SQLException {
        if (this._doing_updates) {
            this._doing_updates = false;
            this._Updater.clearParameters();
        }
    }

    public void moveToInsertRow() throws SQLException {
        if (this._Inserter == null) {
            this.generateStatements();
            this._Inserter = (PreparedStatement)this.Conn.prepareStatement(this._InsertSQL);
        } else {
            this._Inserter.clearParameters();
        }
        this._on_insert_row = true;
        this._doing_updates = false;
    }

    public void moveToCurrentRow() throws SQLException {
        if (!this._updatable) {
            throw new SQLException("ResultSet not updatable");
        }
        this._on_insert_row = false;
    }

    public Statement getStatement() throws SQLException {
        throw new NotImplemented();
    }

    public Object getObject(int i, Map map) throws SQLException {
        throw new NotImplemented();
    }

    public Ref getRef(int i) throws SQLException {
        throw new NotImplemented();
    }

    public java.sql.Blob getBlob(int columnIndex) throws SQLException {
        if (columnIndex < 1 || columnIndex > this.Fields.length) {
            throw new SQLException("Column Index out of range ( " + columnIndex + " > " + this.Fields.length + ").", "S1002");
        }
        return new Blob(this.This_Row[columnIndex - 1]);
    }

    public Clob getClob(int i) throws SQLException {
        throw new NotImplemented();
    }

    public Array getArray(int i) throws SQLException {
        throw new NotImplemented();
    }

    public Object getObject(String colName, Map map) throws SQLException {
        throw new NotImplemented();
    }

    public Ref getRef(String colName) throws SQLException {
        throw new NotImplemented();
    }

    public java.sql.Blob getBlob(String colName) throws SQLException {
        return this.getBlob(this.findColumn(colName));
    }

    public Clob getClob(String colName) throws SQLException {
        throw new NotImplemented();
    }

    public Array getArray(String colName) throws SQLException {
        throw new NotImplemented();
    }

    public Date getDate(int columnIndex, Calendar cal) throws SQLException {
        throw new NotImplemented();
    }

    public Date getDate(String columnName, Calendar cal) throws SQLException {
        throw new NotImplemented();
    }

    public Time getTime(int columnIndex, Calendar cal) throws SQLException {
        throw new NotImplemented();
    }

    public Time getTime(String columnName, Calendar cal) throws SQLException {
        throw new NotImplemented();
    }

    public Timestamp getTimestamp(int columnIndex, Calendar cal) throws SQLException {
        throw new NotImplemented();
    }

    public Timestamp getTimestamp(String columnName, Calendar cal) throws SQLException {
        throw new NotImplemented();
    }

    public ResultSet(Field[] Fields, Vector Tuples, Connection Conn) {
        super(Fields, Tuples, Conn);
        this._updatable = this.isUpdateable();
    }

    public ResultSet(Field[] Fields, Vector Tuples) {
        super(Fields, Tuples);
    }

    public ResultSet(long updateCount, long updateID) {
        super(updateCount, updateID);
    }

    protected void generateStatements() throws SQLException {
        if (!this._updatable) {
            throw new SQLException("ResultSet not updatable");
        }
        String TableName = this.Fields[0].getTableName();
        this._PrimaryKeyIndicies = new Vector();
        StringBuffer FieldValues2 = new StringBuffer();
        StringBuffer KeyValues = new StringBuffer();
        StringBuffer ColumnNames = new StringBuffer();
        StringBuffer InsertPlaceHolders = new StringBuffer();
        boolean first_time = true;
        boolean keys_first_time = true;
        int i = 0;
        while (i < this.Fields.length) {
            if (this.Fields[i].isPrimaryKey()) {
                this._PrimaryKeyIndicies.addElement(new Integer(i));
                if (!keys_first_time) {
                    KeyValues.append(" AND ");
                } else {
                    keys_first_time = false;
                }
                KeyValues.append(String.valueOf(this.Fields[i].getName()) + "=?");
            }
            if (first_time) {
                first_time = false;
                FieldValues2.append("SET ");
            } else {
                FieldValues2.append(",");
                ColumnNames.append(",");
                InsertPlaceHolders.append(",");
            }
            InsertPlaceHolders.append("?");
            ColumnNames.append(this.Fields[i].getName());
            FieldValues2.append(String.valueOf(this.Fields[i].getName()) + "=?");
            ++i;
        }
        this._UpdateSQL = "UPDATE " + TableName + " " + FieldValues2.toString() + " WHERE " + KeyValues.toString();
        this._InsertSQL = "INSERT INTO " + TableName + " (" + ColumnNames.toString() + ") VALUES (" + InsertPlaceHolders.toString() + ")";
        this._DeleteSQL = "DELETE FROM " + TableName + " WHERE " + KeyValues.toString();
    }

    synchronized void syncUpdate() throws SQLException {
        if (this._Updater == null) {
            if (this._UpdateSQL == null) {
                this.generateStatements();
            }
            this._Updater = (PreparedStatement)this.Conn.prepareStatement(this._UpdateSQL);
        }
        int num_fields = this.Fields.length;
        this._Updater.clearParameters();
        int i = 0;
        while (i < num_fields) {
            if (this.This_Row[i] != null) {
                this._Updater.setBytes(i + 1, this.This_Row[i]);
            } else {
                this._Updater.setNull(i + 1, 0);
            }
            ++i;
        }
        int num_keys = this._PrimaryKeyIndicies.size();
        if (num_keys == 1) {
            int index = (Integer)this._PrimaryKeyIndicies.elementAt(0);
            this._Updater.setBytes(num_fields + 1, this.This_Row[(Integer)this._PrimaryKeyIndicies.elementAt(0)]);
        } else {
            int i2 = 0;
            while (i2 < num_keys) {
                byte[] currentVal = this.This_Row[(Integer)this._PrimaryKeyIndicies.elementAt(i2)];
                if (currentVal != null) {
                    this._Updater.setBytes(num_fields + i2 + 1, currentVal);
                } else {
                    this._Updater.setNull(num_fields + i2 + 1, 0);
                }
                ++i2;
            }
        }
    }

    boolean isUpdateable() {
        int i;
        if (this.Fields.length > 0) {
            String TableName = this.Fields[0].getTableName();
            i = 1;
            while (i < this.Fields.length) {
                if (TableName == null || !this.Fields[i].getTableName().equals(TableName)) {
                    return false;
                }
                ++i;
            }
            if (TableName == null || TableName.length() == 0) {
                return false;
            }
        } else {
            return false;
        }
        boolean has_primary_key = false;
        i = 0;
        while (i < this.Fields.length) {
            if (this.Fields[i].isPrimaryKey()) {
                has_primary_key = true;
                break;
            }
            ++i;
        }
        return has_primary_key;
    }

    int getResultSetType() {
        return 0;
    }
}

