/*
 * Decompiled with CFR 0.152.
 */
package org.apache.log;

import java.util.Hashtable;
import org.apache.log.Category;
import org.apache.log.ContextStack;
import org.apache.log.LogTarget;
import org.apache.log.Logger;
import org.apache.log.Priority;
import org.apache.log.output.DefaultOutputLogTarget;

public final class LogKit {
    protected static final Hashtable c_contexts = new Hashtable();
    protected static final Hashtable c_loggers = new Hashtable();
    protected static final Hashtable c_categories = new Hashtable();
    protected static final Hashtable c_logTargets;
    protected static Priority.Enum c_priority;
    protected static LogTarget c_defaultLogTarget;

    public static void addLogTarget(String name, LogTarget target) {
        if (name.equals("default")) {
            c_defaultLogTarget = target;
        }
        c_logTargets.put(name, target);
    }

    public static LogTarget getLogTarget(String name) {
        return (LogTarget)c_logTargets.get(name);
    }

    public static Category createCategory(String categoryName, Priority.Enum priority) {
        Category category = (Category)c_categories.get(categoryName);
        if (null == category) {
            category = new Category(categoryName);
            c_categories.put(categoryName, category);
        }
        category.setPriority(priority);
        return category;
    }

    public static Logger createLogger(Category category) {
        return LogKit.createLogger(category, null);
    }

    public static Logger createLogger(Category category, LogTarget[] logTargets) {
        String categoryName = category.getName();
        Logger logger = (Logger)c_loggers.get(categoryName);
        if (null == logger) {
            int index = categoryName.lastIndexOf(46);
            Logger parent = null;
            if (-1 != index) {
                String parentName = categoryName.substring(0, index);
                parent = LogKit.getLoggerFor(parentName);
            }
            logger = new Logger(category, logTargets, parent);
            c_loggers.put(categoryName, logger);
        } else if (null != logTargets) {
            logger.setLogTargets(logTargets);
        }
        return logger;
    }

    public static ContextStack getCurrentContext() {
        Thread thread = Thread.currentThread();
        ContextStack context = (ContextStack)c_contexts.get(thread);
        if (null == context) {
            context = new ContextStack();
            context.push(thread.getName());
            c_contexts.put(thread, context);
        }
        return context;
    }

    public static LogTarget getDefaultLogTarget() {
        return c_defaultLogTarget;
    }

    public static Priority.Enum getGlobalPriority() {
        return c_priority;
    }

    public static Logger getLoggerFor(String category) {
        Hashtable hashtable = c_loggers;
        synchronized (hashtable) {
            Logger logger = (Logger)c_loggers.get(category);
            if (null == logger) {
                logger = LogKit.createLogger(LogKit.createCategory(category, Priority.DEBUG));
            }
            Logger logger2 = logger;
            return logger2;
        }
    }

    public static Priority.Enum getPriorityForName(String priority) {
        if (Priority.DEBUG.getName().equals(priority)) {
            return Priority.DEBUG;
        }
        if (Priority.INFO.getName().equals(priority)) {
            return Priority.INFO;
        }
        if (Priority.WARN.getName().equals(priority)) {
            return Priority.WARN;
        }
        if (Priority.ERROR.getName().equals(priority)) {
            return Priority.ERROR;
        }
        if (Priority.FATAL_ERROR.getName().equals(priority)) {
            return Priority.FATAL_ERROR;
        }
        return Priority.DEBUG;
    }

    public static void log(String message, Throwable t) {
        System.err.println("Error: " + message);
        t.printStackTrace();
    }

    public static void log(String message) {
        System.err.println("Error: " + message);
    }

    public static void setDefaultLogTarget(LogTarget defaultLogTarget) {
        LogKit.addLogTarget("default", defaultLogTarget);
        c_defaultLogTarget = defaultLogTarget;
    }

    public static void setGlobalPriority(Priority.Enum priority) {
        c_priority = priority;
    }

    private LogKit() {
    }

    static {
        c_priority = Priority.DEBUG;
        c_logTargets = new Hashtable();
        c_defaultLogTarget = new DefaultOutputLogTarget();
        c_logTargets.put("default", c_defaultLogTarget);
    }
}

