/*
 * Decompiled with CFR 0.152.
 */
package org.apache.velocity.runtime.resource.loader;

import java.io.InputStream;
import java.util.Hashtable;
import java.util.Vector;
import org.apache.velocity.exception.ResourceNotFoundException;
import org.apache.velocity.runtime.Runtime;
import org.apache.velocity.runtime.configuration.Configuration;
import org.apache.velocity.runtime.resource.Resource;
import org.apache.velocity.runtime.resource.loader.JarHolder;
import org.apache.velocity.runtime.resource.loader.ResourceLoader;
import org.apache.velocity.util.StringUtils;

public class JarResourceLoader
extends ResourceLoader {
    private Hashtable entryDirectory = new Hashtable(559);
    private Hashtable jarfiles = new Hashtable(89);

    public void init(Configuration configuration) {
        Vector paths = configuration.getVector("resource.path");
        Runtime.info("PATHS SIZE= " + paths.size());
        int i = 0;
        while (i < paths.size()) {
            this.loadJar((String)paths.get(i));
            ++i;
        }
        Runtime.info("JarResourceLoader initialized...");
    }

    private void loadJar(String path) {
        Runtime.info("Try to load: " + path);
        if (path == null) {
            Runtime.error("Can not load a JAR - JAR path is null");
        }
        if (!path.startsWith("jar:")) {
            Runtime.error("JAR path must start with jar: -> see java.net.JarURLConnection for information");
        }
        if (!path.endsWith("!/")) {
            path = path + "!/";
        }
        this.closeJar(path);
        JarHolder temp = new JarHolder(path);
        this.addEntries(temp.getEntries());
        this.jarfiles.put(temp.getUrlPath(), temp);
    }

    private void closeJar(String path) {
        if (this.jarfiles.containsKey(path)) {
            JarHolder theJar = (JarHolder)this.jarfiles.get(path);
            theJar.close();
        }
    }

    private synchronized void addEntries(Hashtable entries) {
        this.entryDirectory.putAll(entries);
    }

    public synchronized InputStream getResourceStream(String source) throws ResourceNotFoundException {
        String jarurl;
        InputStream results = null;
        if (source == null || source.length() == 0) {
            throw new ResourceNotFoundException("Need to a resource!");
        }
        String normalizedPath = StringUtils.normalizePath(source);
        if (normalizedPath == null || normalizedPath.length() == 0) {
            String msg = "File resource error : argument " + normalizedPath + " contains .. and may be trying to access " + "content outside of template root.  Rejected.";
            Runtime.error("FileResourceLoader : " + msg);
            throw new ResourceNotFoundException(msg);
        }
        if (normalizedPath.startsWith("/")) {
            normalizedPath = normalizedPath.substring(1);
        }
        if (this.entryDirectory.containsKey(normalizedPath) && this.jarfiles.containsKey(jarurl = (String)this.entryDirectory.get(normalizedPath))) {
            JarHolder holder = (JarHolder)this.jarfiles.get(jarurl);
            results = holder.getResource(normalizedPath);
        }
        return results;
    }

    public boolean isSourceModified(Resource resource) {
        return true;
    }

    public long getLastModified(Resource resource) {
        return 0L;
    }
}

