/*
 * Decompiled with CFR 0.152.
 */
package com.workingdogs.village;

import com.workingdogs.village.DataSet;
import com.workingdogs.village.DataSetException;
import com.workingdogs.village.KeyDef;
import com.workingdogs.village.QueryDataSet;
import com.workingdogs.village.Schema;
import com.workingdogs.village.TableDataSet;
import com.workingdogs.village.Value;
import java.io.ByteArrayOutputStream;
import java.io.PrintWriter;
import java.math.BigDecimal;
import java.sql.Connection;
import java.sql.Date;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Time;
import java.sql.Timestamp;

public class Record {
    private Value[] values;
    private boolean[] isClean;
    private DataSet parentDataSet;
    private int numberOfColumns;
    private int saveType = 0;
    private Schema schema;
    private boolean status;

    public Record() {
    }

    public Record(DataSet dataSet) throws DataSetException, SQLException {
        this.setParentDataSet(dataSet);
        this.initializeRecord();
        this.createValues(this.dataset().resultSet());
    }

    Record(DataSet dataSet, boolean bl) throws DataSetException, SQLException {
        this.setParentDataSet(dataSet);
        this.initializeRecord();
        this.createValues(null);
    }

    public String asFormattedString(String string, int[] nArray) throws DataSetException {
        throw new DataSetException("Not yet implemented!");
    }

    private void createValues(ResultSet resultSet) throws DataSetException, SQLException {
        int n = 1;
        while (n <= this.size()) {
            Value value;
            this.values[n] = value = new Value(resultSet, n, this.schema().column(n).typeEnum());
            ++n;
        }
    }

    public DataSet dataset() {
        return this.parentDataSet;
    }

    private String getDeleteSaveString() throws DataSetException {
        KeyDef keyDef = this.dataset().keydef();
        if (keyDef == null || keyDef.size() == 0) {
            throw new DataSetException("You must specify KeyDef attributes for this TableDataSet in order to delete a Record.");
        }
        StringBuffer stringBuffer = new StringBuffer(256);
        boolean bl = false;
        int n = 1;
        while (n <= keyDef.size()) {
            if (!bl) {
                stringBuffer.append(keyDef.getAttrib(n));
                stringBuffer.append(" = ?");
                bl = true;
            } else {
                stringBuffer.append(" AND ");
                stringBuffer.append(keyDef.getAttrib(n));
                stringBuffer.append(" = ? ");
            }
            ++n;
        }
        return "DELETE FROM " + this.schema().tableName() + " WHERE " + stringBuffer.toString();
    }

    private String getInsertSaveString() throws DataSetException {
        StringBuffer stringBuffer = new StringBuffer(256);
        StringBuffer stringBuffer2 = new StringBuffer(256);
        boolean bl = false;
        int n = 1;
        while (n <= this.size()) {
            Value value = this.getValue(n);
            if (!this.valueIsClean(n) && !this.schema().column(n).readOnly()) {
                if (!bl) {
                    stringBuffer.append(this.schema().column(n).name());
                    stringBuffer2.append("?");
                    bl = true;
                } else {
                    stringBuffer.append(", " + this.schema().column(n).name());
                    stringBuffer2.append(", ?");
                }
            }
            ++n;
        }
        return "INSERT INTO " + this.schema().tableName() + " ( " + stringBuffer.toString() + " ) VALUES ( " + stringBuffer2.toString() + " )";
    }

    public String getRefreshQueryString() throws DataSetException {
        if (this.dataset().keydef() == null || this.dataset().keydef().size() == 0) {
            throw new DataSetException("You can only perform a getRefreshQueryString on a TableDataSet that was created with a KeyDef.");
        }
        if (this.dataset() instanceof QueryDataSet) {
            throw new DataSetException("You can only perform a getRefreshQueryString on Records created with a TableDataSet.");
        }
        StringBuffer stringBuffer = new StringBuffer(256);
        StringBuffer stringBuffer2 = new StringBuffer(256);
        boolean bl = false;
        int n = 1;
        while (n <= this.size()) {
            if (!bl) {
                stringBuffer.append(this.schema().column(n).name());
                bl = true;
            } else {
                stringBuffer.append(", ");
                stringBuffer.append(this.schema().column(n).name());
            }
            ++n;
        }
        bl = false;
        int n2 = 1;
        while (n2 <= this.dataset().keydef().size()) {
            String string = this.dataset().keydef().getAttrib(n2);
            if (!this.valueIsClean(string)) {
                throw new DataSetException("You cannot do a refresh from the database if the value for a KeyDef column has been changed with a Record.setValue().");
            }
            if (!bl) {
                stringBuffer2.append(string);
                stringBuffer2.append(" = ?");
                bl = true;
            } else {
                stringBuffer2.append(" AND ");
                stringBuffer2.append(string);
                stringBuffer2.append(" = ?");
            }
            ++n2;
        }
        return "SELECT " + stringBuffer.toString() + " FROM " + this.schema().tableName() + " WHERE " + stringBuffer2.toString();
    }

    public String getSaveString() throws DataSetException {
        if (this.toBeSavedWithInsert()) {
            return this.getInsertSaveString();
        }
        if (this.toBeSavedWithUpdate()) {
            return this.getUpdateSaveString();
        }
        if (this.toBeSavedWithDelete()) {
            return this.getDeleteSaveString();
        }
        throw new DataSetException("Not able to return save string: " + this.saveType);
    }

    int getSaveType() {
        return this.saveType;
    }

    private String getUpdateSaveString() throws DataSetException {
        KeyDef keyDef = this.dataset().keydef();
        if (keyDef == null || keyDef.size() == 0) {
            throw new DataSetException("You must specify KeyDef attributes for this TableDataSet in order to create a Record for update.");
        }
        if (this.recordIsClean()) {
            throw new DataSetException("You must Record.setValue() on a column before doing an update.");
        }
        StringBuffer stringBuffer = new StringBuffer(256);
        StringBuffer stringBuffer2 = new StringBuffer(256);
        boolean bl = false;
        int n = 1;
        while (n <= this.size()) {
            Value value = this.getValue(n);
            if (!this.valueIsClean(n) && !this.schema().column(n).readOnly()) {
                if (!bl) {
                    stringBuffer.append(this.schema().column(n).name());
                    stringBuffer.append(" = ?");
                    bl = true;
                } else {
                    stringBuffer.append(", ");
                    stringBuffer.append(this.schema().column(n).name());
                    stringBuffer.append(" = ?");
                }
            }
            ++n;
        }
        bl = false;
        int n2 = 1;
        while (n2 <= keyDef.size()) {
            String string = keyDef.getAttrib(n2);
            if (!this.valueIsClean(this.schema().index(string))) {
                throw new DataSetException("The value for column '" + string + "' is a key value and cannot be updated.");
            }
            if (!bl) {
                stringBuffer2.append(string);
                stringBuffer2.append(" = ?");
                bl = true;
            } else {
                stringBuffer2.append(" AND ");
                stringBuffer2.append(string);
                stringBuffer2.append(" = ?");
            }
            ++n2;
        }
        return "UPDATE " + this.schema().tableName() + " SET " + stringBuffer.toString() + " WHERE " + stringBuffer2.toString();
    }

    public Value getValue(int n) throws DataSetException {
        if (n == 0) {
            throw new DataSetException("Values are 1 based!");
        }
        if (n > this.size()) {
            throw new DataSetException("Only " + this.size() + " columns exist!");
        }
        if (this.values[n] == null) {
            throw new DataSetException("No values for the requested column!");
        }
        return this.values[n];
    }

    public Value getValue(String string) throws DataSetException {
        return this.getValue(this.schema().index(string));
    }

    private void initializeRecord() throws DataSetException {
        this.schema = this.dataset().schema();
        this.numberOfColumns = this.schema.numberOfColumns();
        this.values = new Value[this.size() + 1];
        this.isClean = new boolean[this.size() + 1];
        this.setSaveType(11);
        int n = 1;
        while (n <= this.size()) {
            this.markValueClean(n);
            this.values[n] = null;
            ++n;
        }
    }

    public boolean isAZombie() {
        return this.saveType == 1;
    }

    public void markForInsert() throws DataSetException {
        if (this.dataset() instanceof QueryDataSet) {
            throw new DataSetException("You cannot mark a record in a QueryDataSet for insert");
        }
        this.setSaveType(4);
    }

    public void markForUpdate() throws DataSetException {
        if (this.dataset() instanceof QueryDataSet) {
            throw new DataSetException("You cannot mark a record in a QueryDataSet for update");
        }
        this.setSaveType(3);
    }

    public void markRecordClean() throws DataSetException {
        int n = 1;
        while (n <= this.size()) {
            this.markValueClean(n);
            ++n;
        }
    }

    public Record markToBeDeleted() throws DataSetException {
        if (this.dataset() instanceof QueryDataSet) {
            throw new DataSetException("You cannot mark a record in a QueryDataSet for deletion");
        }
        this.setSaveType(2);
        return this;
    }

    public void markValueClean(int n) throws DataSetException {
        if (n == 0) {
            throw new DataSetException("Value position must be greater than 0.");
        }
        if (n > this.size()) {
            throw new DataSetException("Value position is greater than number of values.");
        }
        this.isClean[n] = true;
    }

    public void markValueClean(String string) throws DataSetException {
        this.markValueClean(this.schema().index(string));
    }

    public void markValueDirty(int n) throws DataSetException {
        if (n == 0) {
            throw new DataSetException("Value position must be greater than 0.");
        }
        if (n > this.size()) {
            throw new DataSetException("Value position is greater than number of values.");
        }
        this.isClean[n] = false;
    }

    public void markValueDirty(String string) throws DataSetException {
        this.markValueDirty(this.schema().index(string));
    }

    public boolean needsToBeSaved() {
        return !this.isAZombie() || !this.recordIsClean() || this.toBeSavedWithUpdate() || this.toBeSavedWithDelete() || this.toBeSavedWithInsert();
    }

    public boolean recordIsClean() {
        int n = 1;
        while (n <= this.size()) {
            if (!this.valueIsClean(n)) {
                return false;
            }
            ++n;
        }
        return true;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void refresh(Connection connection) throws DataSetException, SQLException {
        if (this.toBeSavedWithDelete()) {
            return;
        }
        if (this.toBeSavedWithInsert()) {
            throw new DataSetException("There is no way to refresh a record which has been created with addRecord().");
        }
        if (this.dataset() instanceof QueryDataSet) {
            throw new DataSetException("You can only perform a refresh on Records created with a TableDataSet.");
        }
        PreparedStatement preparedStatement = null;
        try {
            Object object;
            preparedStatement = connection.prepareStatement(this.getRefreshQueryString());
            int n = 1;
            int n2 = 1;
            while (n2 <= this.dataset().keydef().size()) {
                object = this.getValue(this.dataset().keydef().getAttrib(n2));
                if (((Value)object).isNull()) {
                    throw new DataSetException("You cannot execute an update with a null value for a KeyDef.");
                }
                ((Value)object).setPreparedStatementValue(preparedStatement, n++);
                ++n2;
            }
            object = preparedStatement.executeQuery();
            object.next();
            this.initializeRecord();
            this.createValues((ResultSet)object);
            Object var4_9 = null;
        }
        catch (Throwable throwable) {
            Object var4_10 = null;
            if (preparedStatement == null) throw throwable;
            preparedStatement.close();
            throw throwable;
        }
        if (preparedStatement == null) return;
        preparedStatement.close();
        return;
    }

    public int save() throws DataSetException, SQLException {
        return this.save(this.dataset().connection());
    }

    public int save(Connection connection) throws DataSetException, SQLException {
        int n = 0;
        if (this.dataset() instanceof QueryDataSet) {
            throw new DataSetException("You cannot save a QueryDataSet. Please use a TableDataSet instead.");
        }
        if (!this.needsToBeSaved()) {
            return n;
        }
        if (this.toBeSavedWithInsert()) {
            n = this.saveWithInsert(connection);
        } else if (this.toBeSavedWithUpdate()) {
            n = this.saveWithUpdate(connection);
        } else if (this.toBeSavedWithDelete()) {
            n = this.saveWithDelete(connection);
        }
        return n;
    }

    /*
     * Loose catch block
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private int saveWithDelete(Connection connection) throws DataSetException, SQLException {
        PreparedStatement preparedStatement = null;
        preparedStatement = connection.prepareStatement(this.getSaveString());
        int n = 1;
        int n2 = 1;
        while (n2 <= this.dataset().keydef().size()) {
            Value value = this.getValue(this.dataset().keydef().getAttrib(n2));
            value.setPreparedStatementValue(preparedStatement, n++);
            ++n2;
        }
        int n3 = preparedStatement.executeUpdate();
        this.setSaveType(1);
        if (n3 > 1) {
            throw new SQLException("There were " + n3 + " rows deleted with this records key value.");
        }
        int n4 = n3;
        Object var5_11 = null;
        if (preparedStatement == null) return n4;
        preparedStatement.close();
        return n4;
        {
            catch (SQLException sQLException) {
                throw sQLException;
            }
        }
        catch (Throwable throwable) {
            Object var5_12 = null;
            if (preparedStatement == null) throw throwable;
            preparedStatement.close();
            throw throwable;
        }
    }

    /*
     * Loose catch block
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private int saveWithInsert(Connection connection) throws DataSetException, SQLException {
        PreparedStatement preparedStatement = null;
        preparedStatement = connection.prepareStatement(this.getSaveString());
        int n = 1;
        int n2 = 1;
        while (n2 <= this.size()) {
            Value value = this.getValue(n2);
            if (!this.valueIsClean(n2) && !this.schema().column(n2).readOnly()) {
                value.setPreparedStatementValue(preparedStatement, n++);
            }
            ++n2;
        }
        int n3 = preparedStatement.executeUpdate();
        if (((TableDataSet)this.dataset()).refreshOnSave()) {
            this.refresh(this.dataset().connection());
        } else {
            this.markRecordClean();
        }
        this.setSaveType(8);
        if (n3 > 1) {
            throw new SQLException("There were " + n3 + " rows inserted with this records key value.");
        }
        int n4 = n3;
        Object var5_11 = null;
        if (preparedStatement == null) return n4;
        preparedStatement.close();
        return n4;
        {
            catch (SQLException sQLException) {
                throw sQLException;
            }
        }
        catch (Throwable throwable) {
            Object var5_12 = null;
            if (preparedStatement == null) throw throwable;
            preparedStatement.close();
            throw throwable;
        }
    }

    /*
     * Loose catch block
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private int saveWithUpdate(Connection connection) throws DataSetException, SQLException {
        PreparedStatement preparedStatement = null;
        preparedStatement = connection.prepareStatement(this.getSaveString());
        int n = 1;
        int n2 = 1;
        while (n2 <= this.size()) {
            Value value = this.getValue(n2);
            if (!this.valueIsClean(n2) && !this.schema().column(n2).readOnly()) {
                value.setPreparedStatementValue(preparedStatement, n++);
            }
            ++n2;
        }
        int n3 = 1;
        while (n3 <= this.dataset().keydef().size()) {
            Value value = this.getValue(this.dataset().keydef().getAttrib(n3));
            value.setPreparedStatementValue(preparedStatement, n++);
            ++n3;
        }
        int n4 = preparedStatement.executeUpdate();
        if (((TableDataSet)this.dataset()).refreshOnSave()) {
            this.refresh(this.dataset().connection());
        } else {
            this.markRecordClean();
        }
        this.setSaveType(10);
        if (n4 > 1) {
            throw new SQLException("There were " + n4 + " rows updated with this records key value.");
        }
        int n5 = n4;
        Object var5_13 = null;
        if (preparedStatement == null) return n5;
        preparedStatement.close();
        return n5;
        {
            catch (SQLException sQLException) {
                throw sQLException;
            }
        }
        catch (Throwable throwable) {
            Object var5_14 = null;
            if (preparedStatement == null) throw throwable;
            preparedStatement.close();
            throw throwable;
        }
    }

    public void saveWithoutStatusUpdate() throws DataSetException {
        throw new DataSetException("Record.saveWithoutStatusUpdate() is not yet implemented.");
    }

    public Schema schema() throws DataSetException {
        if (this.dataset() != null) {
            return this.schema;
        }
        throw new DataSetException("Internal Error: Record DataSet is null");
    }

    void setParentDataSet(DataSet dataSet) {
        this.parentDataSet = dataSet;
    }

    void setSaveType(int n) {
        this.saveType = n;
    }

    public Record setValue(int n, double d) throws DataSetException {
        this.values[n].setValue(new Double(d));
        this.markValueDirty(n);
        return this;
    }

    public Record setValue(int n, float f) throws DataSetException {
        this.values[n].setValue(new Float(f));
        this.markValueDirty(n);
        return this;
    }

    public Record setValue(int n, int n2) throws DataSetException {
        this.values[n].setValue(new Integer(n2));
        this.markValueDirty(n);
        return this;
    }

    public Record setValue(int n, long l) throws DataSetException {
        this.values[n].setValue(new Long(l));
        this.markValueDirty(n);
        return this;
    }

    public Record setValue(int n, Value value) throws DataSetException {
        this.values[n].setValue(value.getValue());
        this.markValueDirty(n);
        return this;
    }

    public Record setValue(int n, String string) throws DataSetException {
        this.values[n].setValue(string);
        this.markValueDirty(n);
        return this;
    }

    public Record setValue(int n, BigDecimal bigDecimal) throws DataSetException {
        this.values[n].setValue(bigDecimal);
        this.markValueDirty(n);
        return this;
    }

    public Record setValue(int n, Date date) throws DataSetException {
        this.values[n].setValue(date);
        this.markValueDirty(n);
        return this;
    }

    public Record setValue(int n, Time time) throws DataSetException {
        this.values[n].setValue(time);
        this.markValueDirty(n);
        return this;
    }

    public Record setValue(int n, Timestamp timestamp) throws DataSetException {
        this.values[n].setValue(timestamp);
        this.markValueDirty(n);
        return this;
    }

    public Record setValue(int n, java.util.Date date) throws DataSetException {
        this.values[n].setValue(date);
        this.markValueDirty(n);
        return this;
    }

    public Record setValue(int n, boolean bl) throws DataSetException {
        this.values[n].setValue(new Boolean(bl));
        this.markValueDirty(n);
        return this;
    }

    public Record setValue(int n, byte[] byArray) throws DataSetException {
        this.values[n].setValue(byArray);
        this.markValueDirty(n);
        return this;
    }

    public Record setValue(String string, double d) throws DataSetException {
        this.setValue(this.schema().index(string), d);
        return this;
    }

    public Record setValue(String string, float f) throws DataSetException {
        this.setValue(this.schema().index(string), f);
        return this;
    }

    public Record setValue(String string, int n) throws DataSetException {
        this.setValue(this.schema().index(string), n);
        return this;
    }

    public Record setValue(String string, long l) throws DataSetException {
        this.setValue(this.schema().index(string), l);
        return this;
    }

    public Record setValue(String string, Value value) throws DataSetException {
        this.setValue(this.schema().index(string), value);
        return this;
    }

    public Record setValue(String string, String string2) throws DataSetException {
        this.setValue(this.schema().index(string), string2);
        return this;
    }

    public Record setValue(String string, BigDecimal bigDecimal) throws DataSetException {
        this.setValue(this.schema().index(string), bigDecimal);
        return this;
    }

    public Record setValue(String string, Date date) throws DataSetException {
        this.setValue(this.schema().index(string), date);
        return this;
    }

    public Record setValue(String string, Time time) throws DataSetException {
        this.setValue(this.schema().index(string), time);
        return this;
    }

    public Record setValue(String string, Timestamp timestamp) throws DataSetException {
        this.setValue(this.schema().index(string), timestamp);
        return this;
    }

    public Record setValue(String string, java.util.Date date) throws DataSetException {
        this.setValue(this.schema().index(string), date);
        return this;
    }

    public Record setValue(String string, boolean bl) throws DataSetException {
        this.setValue(this.schema().index(string), bl);
        return this;
    }

    public Record setValue(String string, byte[] byArray) throws DataSetException {
        this.setValue(this.schema().index(string), byArray);
        return this;
    }

    public Record setValueNull(int n) throws DataSetException {
        if (n == 0) {
            throw new DataSetException("Value position must be greater than 0.");
        }
        if (n > this.size()) {
            throw new DataSetException("Value position is greater than number of values.");
        }
        this.values[n].setValue(null);
        this.markValueDirty(n);
        return this;
    }

    public Record setValueNull(String string) throws DataSetException {
        if (string == null || string.length() == 0) {
            throw new DataSetException("You must specify a column name!");
        }
        this.setValueNull(this.schema().index(string));
        return this;
    }

    public int size() {
        return this.numberOfColumns;
    }

    public boolean toBeSavedWithDelete() {
        return this.saveType == 2;
    }

    public boolean toBeSavedWithInsert() {
        return this.saveType == 4;
    }

    public boolean toBeSavedWithUpdate() {
        return this.saveType == 3;
    }

    public String toString() {
        try {
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            PrintWriter printWriter = new PrintWriter(byteArrayOutputStream);
            printWriter.print("{");
            int n = 1;
            while (n <= this.size()) {
                printWriter.print("'" + this.getValue(n).asString() + "'");
                if (n < this.size()) {
                    printWriter.print(',');
                }
                ++n;
            }
            printWriter.print("}");
            printWriter.flush();
            return byteArrayOutputStream.toString();
        }
        catch (Exception exception) {
            return "";
        }
    }

    public Record unmarkToBeDeleted() throws DataSetException {
        if (this.saveType == 1) {
            throw new DataSetException("This record has already been deleted!");
        }
        this.setSaveType(11);
        return this;
    }

    public void updateStatus() throws SQLException, DataSetException {
        this.status = true;
    }

    public boolean valueIsClean(int n) {
        return this.isClean[n];
    }

    boolean valueIsClean(String string) throws DataSetException {
        return this.isClean[this.getValue(string).columnNumber()];
    }
}

