/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tools.ant.taskdefs;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.zip.ZipOutputStream;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.DirectoryScanner;
import org.apache.tools.ant.FileScanner;
import org.apache.tools.ant.taskdefs.Zip;

public class Jar
extends Zip {
    private File manifest;

    public Jar() {
        this.archiveType = "jar";
        this.emptyBehavior = "create";
    }

    protected void initZipOutputStream(ZipOutputStream zOut) throws IOException, BuildException {
        if (this.manifest != null) {
            this.zipDir(new File(this.manifest.getParent()), zOut, "META-INF/");
            super.zipFile(this.manifest, zOut, "META-INF/MANIFEST.MF");
        } else {
            String s = "/org/apache/tools/ant/defaultManifest.mf";
            InputStream in = this.getClass().getResourceAsStream(s);
            if (in == null) {
                throw new BuildException("Could not find: " + s);
            }
            this.zipDir(null, zOut, "META-INF/");
            this.zipFile(in, zOut, "META-INF/MANIFEST.MF", System.currentTimeMillis());
        }
    }

    protected boolean isUpToDate(FileScanner[] scanners, File zipFile) throws BuildException {
        File[] files = Zip.grabFiles(scanners);
        if (this.manifest != null) {
            DirectoryScanner ds = new DirectoryScanner();
            ds.setBasedir(new File(this.manifest.getParent()));
            ds.setIncludes(new String[]{this.manifest.getName()});
            ds.scan();
            FileScanner[] myScanners = new FileScanner[scanners.length + 1];
            System.arraycopy(scanners, 0, myScanners, 0, scanners.length);
            myScanners[scanners.length] = ds;
            boolean retval = super.isUpToDate(myScanners, zipFile);
            if (!retval && files.length == 0) {
                this.log("Note: creating empty " + this.archiveType + " archive " + zipFile, 2);
            }
            return retval;
        }
        if (this.emptyBehavior.equals("create") && files.length == 0) {
            this.log("Note: creating empty " + this.archiveType + " archive " + zipFile, 2);
            return false;
        }
        return super.isUpToDate(scanners, zipFile);
    }

    public void setJarfile(File jarFile) {
        super.setZipfile(jarFile);
    }

    public void setManifest(File manifestFile) {
        this.manifest = manifestFile;
    }

    protected void zipFile(File file, ZipOutputStream zOut, String vPath) throws IOException {
        if (!vPath.equalsIgnoreCase("META-INF/MANIFEST.MF")) {
            super.zipFile(file, zOut, vPath);
        } else {
            this.log("Warning: selected " + this.archiveType + " files include a META-INF/MANIFEST.MF which will be ignored " + "(please use manifest attribute to " + this.archiveType + " task)", 1);
        }
    }
}

