/*
 * Decompiled with CFR 0.152.
 */
package org.webmacro;

import java.io.BufferedOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.io.Writer;
import sun.io.CharToByteConverter;

public final class FastWriter
extends Writer {
    OutputStream _out;
    String _encoding;
    final CharToByteConverter _c2b;
    private static final int CSIZE = 512;
    final char[] _cbuf = new char[512];
    int _cpos;
    private final int _BSIZE;
    final byte[] _bbuf;
    boolean _asciiHack;

    public FastWriter(OutputStream outputStream, String string) throws UnsupportedEncodingException {
        this._encoding = string;
        this._out = new BufferedOutputStream(outputStream);
        this._c2b = CharToByteConverter.getConverter((String)string);
        this._BSIZE = 512 * this._c2b.getMaxBytesPerChar();
        this._bbuf = new byte[this._BSIZE];
        this._cpos = 0;
        this._asciiHack = false;
    }

    public String getEncoding() {
        return this._encoding;
    }

    public void recycle(OutputStream outputStream, String string) {
        this._out = new BufferedOutputStream(outputStream);
        this._encoding = string;
        this._cpos = 0;
    }

    public void setAsciiHack(boolean bl) throws IOException {
        if (this._cpos != 0) {
            this.cflush();
        }
        this._asciiHack = bl;
    }

    public void write(int n) throws IOException {
        if (this._cpos + 1 > 512) {
            this.cflush();
        }
        this._cbuf[this._cpos] = (char)n;
        ++this._cpos;
    }

    public void write(byte by) throws IOException {
        if (this._cpos != 0) {
            this.cflush();
        }
        this._out.write(by);
    }

    public void write(char[] cArray) throws IOException {
        this.write(cArray, 0, cArray.length);
    }

    public void write(char[] cArray, int n, int n2) throws IOException {
        if (this._cpos + n2 > 512) {
            this.cflush();
            if (n2 > 512) {
                this.writeChars(cArray, n, n2);
                return;
            }
        }
        System.arraycopy(cArray, n, this._cbuf, this._cpos, n2);
        this._cpos += n2;
    }

    public void write(byte[] byArray) throws IOException {
        if (this._cpos != 0) {
            this.cflush();
        }
        this._out.write(byArray);
    }

    public void write(byte[] byArray, int n, int n2) throws IOException {
        if (this._cpos != 0) {
            this.cflush();
        }
        this._out.write(byArray, n, n2);
    }

    public void write(String string, int n, int n2) throws IOException {
        if (this._asciiHack) {
            if (this._cpos != 0) {
                this.cflush();
            }
            this.writeAsciiBytes(string, n, n2);
            return;
        }
        if (this._cpos + n2 > 512) {
            this.cflush();
            if (n2 > 512) {
                this._out.write(string.getBytes(this._encoding));
                return;
            }
        }
        string.getChars(n, n + n2, this._cbuf, this._cpos);
        this._cpos += n2;
    }

    public void write(String string) throws IOException {
        this.write(string, 0, string.length());
    }

    private void writeAsciiBytes(String string, int n, int n2) throws IOException {
        while (n2 > 0) {
            int n3 = n2 < this._BSIZE ? n2 : this._BSIZE;
            string.getChars(n, n + n3, this._cbuf, 0);
            int n4 = 0;
            while (n4 < n3) {
                this._bbuf[n4] = (byte)this._cbuf[n4];
                ++n4;
            }
            n2 -= n3;
            n += n3;
            this._out.write(this._bbuf, 0, n3);
        }
    }

    private void writeChars(char[] cArray, int n, int n2) throws IOException {
        try {
            try {
                if (this._asciiHack) {
                    while (n2 > 0) {
                        int n3 = n2 < this._BSIZE ? n2 : this._BSIZE;
                        int n4 = 0;
                        while (n4 < n3) {
                            this._bbuf[n4] = (byte)cArray[n4 + n];
                            ++n4;
                        }
                        this._out.write(this._bbuf, 0, n3);
                        n2 -= n3;
                        n += n3;
                    }
                } else {
                    int n5 = 0;
                    while (n5 < this._cpos) {
                        n5 += this._c2b.convert(cArray, n5, this._cpos, this._bbuf, 0, this._BSIZE);
                        this._out.write(this._bbuf, 0, this._c2b.nextByteIndex());
                    }
                }
            }
            catch (Exception exception) {
                throw new IOException("Unicode conversion error: " + exception);
            }
            Object var7_8 = null;
        }
        catch (Throwable throwable) {
            Object var7_9 = null;
            this._c2b.reset();
            throw throwable;
        }
        this._c2b.reset();
    }

    public void cflush() throws IOException {
        this.writeChars(this._cbuf, 0, this._cpos);
        this._cpos = 0;
    }

    public void flush() throws IOException {
        this.cflush();
        this._out.flush();
    }

    public void close() throws IOException {
        this.cflush();
        this._out.close();
        this._out = null;
    }

    public static void main(String[] stringArray) {
        System.out.println("----START----");
        try {
            FastWriter fastWriter = new FastWriter(System.out, "UTF8");
            fastWriter.setAsciiHack(true);
            int n = 0;
            while (n < stringArray.length) {
                fastWriter.write(stringArray[n]);
                fastWriter.write(stringArray[n].getBytes());
                ++n;
            }
            fastWriter.flush();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        System.out.println("----DONE----");
    }
}

