/*
 * Decompiled with CFR 0.152.
 */
package org.webmacro;

import java.util.HashMap;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.webmacro.Broker;
import org.webmacro.BrokerOwner;
import org.webmacro.Context;
import org.webmacro.InitException;
import org.webmacro.InvalidTypeException;
import org.webmacro.NotFoundException;
import org.webmacro.Template;
import org.webmacro.WebMacro;
import org.webmacro.servlet.WebContext;
import org.webmacro.util.Log;

public class WM
implements WebMacro {
    private static final Map _brokers = new HashMap();
    private static final BrokerOwner _default = new BrokerOwner();
    private Context _context = null;
    private WebContext _webContext = null;
    private Broker _broker;
    private BrokerOwner _owner;
    private boolean _alive = false;
    static final Log _log = new Log("WM", "WebMacro Manager");

    public WM() throws InitException {
        this(null);
    }

    public WM(String string) throws InitException {
        BrokerOwner brokerOwner = null;
        Broker broker = null;
        try {
            if (string == null) {
                brokerOwner = _default;
            } else {
                Map map = _brokers;
                synchronized (map) {
                    brokerOwner = (BrokerOwner)_brokers.get(string);
                    if (brokerOwner == null) {
                        brokerOwner = new BrokerOwner(string);
                        _brokers.put(string, brokerOwner);
                    }
                }
            }
            broker = brokerOwner.init();
            Object var7_6 = null;
            this._owner = brokerOwner;
            this._broker = broker;
        }
        catch (Throwable throwable) {
            Object var7_7 = null;
            this._owner = brokerOwner;
            this._broker = broker;
            throw throwable;
        }
        this._alive = true;
    }

    public final void destroy() {
        if (this._alive) {
            this._alive = false;
            this._owner.done();
        }
    }

    public final boolean isDestroyed() {
        return !this._alive;
    }

    protected void finalize() {
        this.destroy();
    }

    public final Broker getBroker() {
        return this._broker;
    }

    public final Context getContext() {
        if (this._context == null) {
            this._context = new Context(this.getBroker());
        }
        return (Context)this._context.clone();
    }

    public final WebContext getWebContext(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) {
        if (this._webContext == null) {
            this._webContext = new WebContext(this.getBroker());
        }
        return this._webContext.newInstance(httpServletRequest, httpServletResponse);
    }

    public final Template getTemplate(String string) throws NotFoundException {
        try {
            return (Template)this._broker.getValue("template", string);
        }
        catch (InvalidTypeException invalidTypeException) {
            _log.exception(invalidTypeException);
            _log.error("Broker unable to load templates");
            throw new NotFoundException("ERROR: Broker cannot load any templates, the template provider is missing:" + invalidTypeException);
        }
    }

    public final Object getURL(String string) throws NotFoundException {
        try {
            return this._broker.getValue("url", string);
        }
        catch (InvalidTypeException invalidTypeException) {
            _log.exception(invalidTypeException);
            _log.error("Broker unable to load URLs");
            throw new NotFoundException("ERROR: Broker cannot load any URLs, the URL provider is missing:" + invalidTypeException);
        }
    }

    public final String getConfig(String string) throws NotFoundException {
        try {
            return (String)this._broker.getValue("config", string);
        }
        catch (InvalidTypeException invalidTypeException) {
            _log.exception(invalidTypeException);
            _log.error("Broker unable to load config");
            throw new NotFoundException("ERROR: Broker cannot find any config information at all, the config provider is missing:" + invalidTypeException);
        }
    }
}

