/*
 * Decompiled with CFR 0.152.
 */
package org.webmacro.resource;

import java.io.InputStreamReader;
import java.io.Reader;
import java.io.StringWriter;
import java.net.URL;
import org.webmacro.NotFoundException;
import org.webmacro.broker.CreateResourceEvent;
import org.webmacro.broker.RequestResourceEvent;
import org.webmacro.broker.ResourceBroker;
import org.webmacro.broker.ResourceEvent;
import org.webmacro.broker.ResourceProvider;
import org.webmacro.util.Log;

public final class UrlProvider
implements ResourceProvider {
    public static final String TYPE = "url";
    private static final Log _log = new Log("url", "URL Provider");
    private static final String[] _types = new String[]{"url"};

    public final int resourceThreads() {
        return 2;
    }

    public final String[] getTypes() {
        return _types;
    }

    public final int resourceExpireTime() {
        return 600000;
    }

    public final void resourceRequest(RequestResourceEvent requestResourceEvent) throws NotFoundException {
        try {
            int n;
            String string = requestResourceEvent.getName();
            URL uRL = string.indexOf(":") < 3 ? new URL("file", null, -1, string) : new URL(string);
            InputStreamReader inputStreamReader = new InputStreamReader(uRL.openStream());
            char[] cArray = new char[512];
            StringWriter stringWriter = new StringWriter();
            while ((n = inputStreamReader.read(cArray)) != -1) {
                stringWriter.write(cArray, 0, n);
            }
            requestResourceEvent.set(stringWriter.toString());
            ((Reader)inputStreamReader).close();
        }
        catch (Exception exception) {
            _log.exception(exception);
            throw new NotFoundException("Reactor: Unable to load URL " + requestResourceEvent.getName() + ":" + exception);
        }
    }

    public final boolean resourceSave(ResourceEvent resourceEvent) {
        return false;
    }

    public final void destroy() {
    }

    public void init(ResourceBroker resourceBroker) {
    }

    public final void resourceCreate(CreateResourceEvent createResourceEvent) {
    }

    public final boolean resourceDelete(ResourceEvent resourceEvent) {
        return false;
    }
}

