/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xalan.xslt;

import java.io.FileNotFoundException;
import java.io.IOException;
import java.net.MalformedURLException;
import java.util.Stack;
import org.apache.xalan.xpath.XObject;
import org.apache.xalan.xpath.XPathSupport;
import org.apache.xalan.xpath.XRTreeFrag;
import org.apache.xalan.xpath.xml.QName;
import org.apache.xalan.xslt.Arg;
import org.apache.xalan.xslt.ElemTemplateElement;
import org.apache.xalan.xslt.ElemVariable;
import org.apache.xalan.xslt.ElemWithParam;
import org.apache.xalan.xslt.Stylesheet;
import org.apache.xalan.xslt.XSLTEngineImpl;
import org.w3c.dom.DocumentFragment;
import org.w3c.dom.Node;
import org.xml.sax.SAXException;

class VariableStack
extends Stack {
    private static final Integer contextMarker = new Integer(0);
    private static final Arg m_elemFrameBoundry = new Arg();
    private int m_globalStackFrameIndex = -1;
    private int m_currentStackFrameIndex = 0;

    VariableStack() {
        this.pushContextMarker();
    }

    int getCurrentStackFrameIndex() {
        return this.m_currentStackFrameIndex;
    }

    public XObject getParamVariable(QName qName) throws SAXException {
        XObject xObject = null;
        int n = this.getCurrentStackFrameIndex();
        int n2 = n - 1;
        while (n2 >= 0) {
            Object e = this.elementAt(n2);
            if (e == contextMarker) break;
            if (((Arg)e).equals(qName)) {
                xObject = ((Arg)e).m_val;
                if (xObject != null) break;
                xObject = new XObject(e);
                break;
            }
            --n2;
        }
        return xObject;
    }

    public Object getVariable(QName qName) throws SAXException {
        int n = this.getCurrentStackFrameIndex();
        int n2 = n - 1;
        while (n2 >= 0) {
            Object e = this.elementAt(n2);
            if (e == contextMarker) break;
            if (((Arg)e).equals(qName)) {
                XObject xObject = ((Arg)e).m_val;
                if (xObject == null) {
                    xObject = new XObject(e);
                }
                return xObject;
            }
            --n2;
        }
        int n3 = this.m_globalStackFrameIndex - 1;
        while (n3 >= 2) {
            Object e = this.elementAt(n3);
            if (e == contextMarker) break;
            if (((Arg)e).equals(qName)) {
                XObject xObject = ((Arg)e).m_val;
                if (xObject == null) {
                    xObject = new XObject(e);
                }
                return xObject;
            }
            --n3;
        }
        return null;
    }

    public void markGlobalStackFrame() {
        this.m_globalStackFrameIndex = this.size();
        this.push(contextMarker);
    }

    public Object pop() {
        if (this.m_currentStackFrameIndex == this.size()) {
            --this.m_currentStackFrameIndex;
        }
        return super.pop();
    }

    void popCurrentContext() {
        int n = this.size();
        int n2 = n - 1;
        while (n2 >= 0) {
            if (this.elementAt(n2) == contextMarker) {
                this.setStackSize(n2);
                break;
            }
            --n2;
        }
    }

    void popElemFrame(ElemTemplateElement elemTemplateElement) {
        int n = this.size();
        int n2 = n - 1;
        while (n2 >= 0) {
            Object e = this.elementAt(n2);
            if (e == contextMarker) break;
            if (e == m_elemFrameBoundry) {
                this.setStackSize(n2);
                break;
            }
            --n2;
        }
    }

    public Object push(Object object) {
        if (this.m_currentStackFrameIndex == this.size()) {
            ++this.m_currentStackFrameIndex;
        }
        return super.push(object);
    }

    void pushContextMarker() {
        this.push(contextMarker);
    }

    public void pushElemFrame(ElemTemplateElement elemTemplateElement) {
        this.push(m_elemFrameBoundry);
    }

    public void pushElemVariable(QName qName, ElemVariable elemVariable) {
        this.push(new Arg(qName, elemVariable, false));
    }

    void pushParams(XSLTEngineImpl xSLTEngineImpl, Stylesheet stylesheet, ElemTemplateElement elemTemplateElement, Node node, Node node2, QName qName) throws SAXException, MalformedURLException, FileNotFoundException, IOException {
        ElemTemplateElement elemTemplateElement2 = (ElemTemplateElement)elemTemplateElement.getFirstChild();
        while (elemTemplateElement2 != null) {
            if (elemTemplateElement2.getXSLToken() == 2) {
                XObject xObject;
                ElemWithParam elemWithParam = (ElemWithParam)elemTemplateElement2;
                if (elemWithParam.m_selectPattern != null) {
                    xObject = elemWithParam.m_selectPattern.execute((XPathSupport)xSLTEngineImpl.getXMLProcessorLiaison(), node2, elemWithParam);
                } else {
                    DocumentFragment documentFragment = xSLTEngineImpl.createResultTreeFrag(stylesheet, elemWithParam, node, node2, qName);
                    xObject = new XRTreeFrag(documentFragment);
                }
                this.push(new Arg(elemWithParam.m_qname, xObject, true));
            }
            elemTemplateElement2 = elemTemplateElement2.m_nextSibling;
        }
    }

    public void pushVariable(QName qName, XObject xObject) {
        this.push(new Arg(qName, xObject, false));
    }

    void setCurrentStackFrameIndex(int n) {
        this.m_currentStackFrameIndex = n;
    }

    public void setStackSize(int n) {
        boolean bl = this.m_currentStackFrameIndex == this.size();
        this.setSize(n);
        if (bl) {
            this.m_currentStackFrameIndex = this.size();
        }
    }
}

