/*
 * Decompiled with CFR 0.152.
 */
package org.apache.log4j;

import java.io.FileWriter;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import org.apache.log4j.AppenderSkeleton;
import org.apache.log4j.Layout;
import org.apache.log4j.helpers.LogLog;
import org.apache.log4j.helpers.OptionConverter;
import org.apache.log4j.helpers.QuietWriter;
import org.apache.log4j.helpers.TracerPrintWriter;
import org.apache.log4j.spi.ErrorHandler;
import org.apache.log4j.spi.LoggingEvent;

public class FileAppender
extends AppenderSkeleton {
    public static final String FILE_OPTION = "File";
    public static final String IMMEDIATE_FLUSH_OPTION = "ImmediateFlush";
    public static final String APPEND_OPTION = "Append";
    protected boolean fileAppend = true;
    protected boolean immediateFlush = true;
    protected QuietWriter qw;
    protected TracerPrintWriter tp;
    protected String fileName = null;
    protected boolean qwIsOurs = false;

    public void activateOptions() {
        if (this.fileName != null) {
            try {
                this.setFile(this.fileName, this.fileAppend);
            }
            catch (IOException iOException) {
                this.errorHandler.error("setFile(" + this.fileName + "," + this.fileAppend + ") call failed.", iOException, 4);
            }
        }
    }

    public void append(LoggingEvent loggingEvent) {
        if (!this.checkEntryConditions()) {
            return;
        }
        this.subAppend(loggingEvent);
    }

    protected boolean checkEntryConditions() {
        if (this.qw == null) {
            this.errorHandler.error("No output target set for appender named \"" + this.name + "\".");
            return false;
        }
        if (this.layout == null) {
            this.errorHandler.error("No layout set for appender named \"" + this.name + "\".");
            return false;
        }
        return true;
    }

    public void close() {
        this.closed = true;
        this.reset();
    }

    protected void closeWriterIfOurs() {
        if (this.qwIsOurs && this.qw != null) {
            try {
                this.qw.close();
            }
            catch (IOException iOException) {
                LogLog.error("Could not close output stream " + this.qw, iOException);
            }
        }
    }

    public String[] getOptionStrings() {
        return OptionConverter.concatanateArrays(super.getOptionStrings(), new String[]{FILE_OPTION, APPEND_OPTION, IMMEDIATE_FLUSH_OPTION});
    }

    public synchronized void setErrorHandler(ErrorHandler errorHandler) {
        this.errorHandler = errorHandler;
        if (this.qwIsOurs && this.qw != null) {
            this.qw.setErrorHandler(errorHandler);
        }
    }

    public synchronized void setFile(String string, boolean bl) throws IOException {
        this.reset();
        this.setQWForFiles(new FileWriter(string, bl));
        this.tp = new TracerPrintWriter(this.qw);
        this.fileName = string;
        this.qwIsOurs = true;
    }

    public void setFile(String string) throws IOException {
        this.setFile(string, this.fileAppend);
    }

    public void setOption(String string, String string2) {
        if (string2 == null) {
            return;
        }
        super.setOption(string, string2);
        if (string.equalsIgnoreCase(FILE_OPTION)) {
            if ((string2 = string2.trim()).equalsIgnoreCase("System.out")) {
                this.setWriter(new OutputStreamWriter(System.out));
            } else if (string2.equalsIgnoreCase("System.err")) {
                this.setWriter(new OutputStreamWriter(System.err));
            } else {
                this.fileName = string2;
            }
        } else if (string.equalsIgnoreCase(APPEND_OPTION)) {
            this.fileAppend = OptionConverter.toBoolean(string2, this.fileAppend);
        } else if (string.equalsIgnoreCase(IMMEDIATE_FLUSH_OPTION)) {
            this.immediateFlush = OptionConverter.toBoolean(string2, this.immediateFlush);
        }
    }

    public synchronized void setWriter(Writer writer) {
        this.reset();
        this.qw = new QuietWriter(writer, this.errorHandler);
        this.tp = new TracerPrintWriter(this.qw);
        this.qwIsOurs = false;
    }

    protected void setQWForFiles(Writer writer) {
        this.qw = new QuietWriter(writer, this.errorHandler);
    }

    protected void subAppend(LoggingEvent loggingEvent) {
        this.qw.write(this.layout.format(loggingEvent));
        if (this.layout.ignoresThrowable()) {
            if (loggingEvent.throwable != null) {
                loggingEvent.throwable.printStackTrace(this.tp);
            } else if (loggingEvent.throwableInformation != null) {
                this.qw.write(loggingEvent.throwableInformation);
            }
        }
        if (this.immediateFlush) {
            this.qw.flush();
        }
    }

    public boolean requiresLayout() {
        return true;
    }

    protected void reset() {
        this.closeWriterIfOurs();
        this.fileName = null;
        this.qw = null;
        this.tp = null;
    }

    public FileAppender() {
    }

    public FileAppender(Layout layout, OutputStream outputStream) {
        this(layout, new OutputStreamWriter(outputStream));
    }

    public FileAppender(Layout layout, Writer writer) {
        this.layout = layout;
        this.setWriter(writer);
    }

    public FileAppender(Layout layout, String string, boolean bl) throws IOException {
        this.layout = layout;
        this.setFile(string, bl);
    }

    public FileAppender(Layout layout, String string) throws IOException {
        this(layout, string, true);
    }
}

