package org.apache.turbine.modules.actions;

/* ====================================================================
 * The Apache Software License, Version 1.1
 *
 * Copyright (c) 2001 The Apache Software Foundation.  All rights
 * reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 *
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 *
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in
 *    the documentation and/or other materials provided with the
 *    distribution.
 *
 * 3. The end-user documentation included with the redistribution,
 *    if any, must include the following acknowledgment:
 *       "This product includes software developed by the
 *        Apache Software Foundation (http://www.apache.org/)."
 *    Alternately, this acknowledgment may appear in the software itself,
 *    if and wherever such third-party acknowledgments normally appear.
 *
 * 4. The names "Apache" and "Apache Software Foundation" and 
 *    "Apache Turbine" must not be used to endorse or promote products 
 *    derived from this software without prior written permission. For 
 *    written permission, please contact apache@apache.org.
 *
 * 5. Products derived from this software may not be called "Apache",
 *    "Apache Turbine", nor may "Apache" appear in their name, without 
 *    prior written permission of the Apache Software Foundation.
 *
 * THIS SOFTWARE IS PROVIDED ``AS IS'' AND ANY EXPRESSED OR IMPLIED
 * WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES
 * OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE
 * DISCLAIMED.  IN NO EVENT SHALL THE APACHE SOFTWARE FOUNDATION OR
 * ITS CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,
 * SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT
 * LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF
 * USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND
 * ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY,
 * OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT
 * OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
 * SUCH DAMAGE.
 * ====================================================================
 *
 * This software consists of voluntary contributions made by many
 * individuals on behalf of the Apache Software Foundation.  For more
 * information on the Apache Software Foundation, please see
 * <http://www.apache.org/>.
 */

// Turbine Stuff
import org.apache.turbine.util.RunData;
import org.apache.turbine.modules.screens.TemplateScreen;
import org.apache.turbine.modules.screens.WebMacroSiteScreen;
import org.apache.turbine.util.webmacro.*;

// WebMacro Stuff
import org.apache.turbine.services.webmacro.*;
import org.webmacro.servlet.*;

/**
 * This class provides a convenience methods for WebMacroSite Actions
 * to use. Since this class is abstract, it should only be extended
 * and not used directly.
 *
 * @author <a href="mailto:jon@latchkey.com">Jon S. Stevens</a>
 * @version $Id: WebMacroSiteAction.java,v 1.5 2001/03/06 04:50:43 chrise Exp $
 */
public abstract class WebMacroSiteAction extends WebMacroActionEvent
{
    /**
     * You SHOULD NOT override this method and implement it in your
     * action.
     *
     * @param data Turbine information.
     * @exception Exception, a generic exception.
     */
    public void doPerform( RunData data )
        throws Exception
    {
        doPerform(data, getContext(data));
    }

    /**
     * You SHOULD override this method and implement it in your
     * action.
     *
     * @param data Turbine information.
     * @param context Context for web pages.
     * @exception Exception, a generic exception.
     */
    public abstract void doPerform( RunData data,
                                    WebContext context )
        throws Exception;

    /**
     * Sets up the context and then calls super.perform(); thus,
     * subclasses don't have to worry about getting a context
     * themselves!
     *
     * @param data Turbine information.
     * @exception Exception, a generic exception.
     */
    protected void perform( RunData data )
        throws Exception
    {
        super.perform(data);
    }

    /**
     * This method is used when you want to short circuit an Action
     * and change the template that will be executed next.
     *
     * @param data Turbine information.
     * @param template The template that will be executed next.
     */
    public void setTemplate(RunData data,
                            String template)
    {
        TemplateScreen.setTemplate(data, template);
    }

    /**
     * Return the WebContext needed by WebMacro. This is first setup
     * in the WebMacroSitePage.
     *
     * @param RunData data
     * @return WebContext, a context for web pages.
     */
    protected WebContext getContext(RunData data)
    {
        return WebMacroSiteScreen.getContext(data);
    }
}
