package org.apache.turbine.om.security.peer;

/* ====================================================================
 * The Apache Software License, Version 1.1
 *
 * Copyright (c) 2001 The Apache Software Foundation.  All rights
 * reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 *
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 *
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in
 *    the documentation and/or other materials provided with the
 *    distribution.
 *
 * 3. The end-user documentation included with the redistribution,
 *    if any, must include the following acknowledgment:
 *       "This product includes software developed by the
 *        Apache Software Foundation (http://www.apache.org/)."
 *    Alternately, this acknowledgment may appear in the software itself,
 *    if and wherever such third-party acknowledgments normally appear.
 *
 * 4. The names "Apache" and "Apache Software Foundation" and 
 *    "Apache Turbine" must not be used to endorse or promote products 
 *    derived from this software without prior written permission. For 
 *    written permission, please contact apache@apache.org.
 *
 * 5. Products derived from this software may not be called "Apache",
 *    "Apache Turbine", nor may "Apache" appear in their name, without 
 *    prior written permission of the Apache Software Foundation.
 *
 * THIS SOFTWARE IS PROVIDED ``AS IS'' AND ANY EXPRESSED OR IMPLIED
 * WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES
 * OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE
 * DISCLAIMED.  IN NO EVENT SHALL THE APACHE SOFTWARE FOUNDATION OR
 * ITS CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,
 * SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT
 * LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF
 * USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND
 * ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY,
 * OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT
 * OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
 * SUCH DAMAGE.
 * ====================================================================
 *
 * This software consists of voluntary contributions made by many
 * individuals on behalf of the Apache Software Foundation.  For more
 * information on the Apache Software Foundation, please see
 * <http://www.apache.org/>.
 */

// Java Core Classes
import java.util.*;
import java.sql.*;

// Turbine Utility Classes
import org.apache.turbine.om.peer.*;
import org.apache.turbine.om.security.*;
import org.apache.turbine.util.*;
import org.apache.turbine.util.db.*;
import org.apache.turbine.util.db.map.*;

// Village Database Classes
import com.workingdogs.village.*;

/**
 * This class handles all database access for the
 * ROLE_PERMISSION table.  This table contains all
 * the permissions for a given role.
 *
 * @author <a href="mailto:frank.kim@clearink.com">Frank Y. Kim</a>
 * @author <a href="mailto:bmclaugh@algx.net">Brett McLaughlin</a>
 * @author <a href="mailto:john.mcnally@clearink.com">John D. McNally</a>
 * @author <a href="mailto:jon@collab.net">Jon S. Stevens</a>
 * @version $Id: RolePermissionPeer.java,v 1.4 2001/03/06 04:56:03 chrise Exp $
 */
public class RolePermissionPeer extends BasePeer
{
    private static final TurbineMapBuilder mapBuilder = (TurbineMapBuilder) getMapBuilder();

    /** The table name for this peer. */
    public static final String TABLE_NAME = mapBuilder.getTableRolePermission();

    /** The column name for the permission id field. */
    public static final String PERMISSION_ID = mapBuilder.getRolePermission_PermissionId();

    /** The column name for the role id field. */
    public static final String ROLE_ID = mapBuilder.getRolePermission_RoleId();


    /**
     * Deletes the mappings for a role_id.
     *
     * @param role_id An int with the role id.
     * @exception Exception, a generic exception.
     */
    public static void deleteRole(int role_id)
        throws Exception
    {
        Criteria criteria = new Criteria();
        criteria.add(ROLE_ID, role_id);
        doDelete(criteria);
    }

    /**
     * Deletes the mappings for a permission_id.
     *
     * @param permission An int with the permission id.
     * @exception Exception, a generic exception.
     */
    public static void deletePermission(int permission_id)
        throws Exception
    {
        Criteria criteria = new Criteria();
        criteria.add(PERMISSION_ID, permission_id);
        doDelete(criteria);
    }
}
