package org.apache.turbine.services.intake.model;

/* ====================================================================
 * The Apache Software License, Version 1.1
 *
 * Copyright (c) 2001 The Apache Software Foundation.  All rights
 * reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 *
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 *
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in
 *    the documentation and/or other materials provided with the
 *    distribution.
 *
 * 3. The end-user documentation included with the redistribution,
 *    if any, must include the following acknowledgment:
 *       "This product includes software developed by the
 *        Apache Software Foundation (http://www.apache.org/)."
 *    Alternately, this acknowledgment may appear in the software itself,
 *    if and wherever such third-party acknowledgments normally appear.
 *
 * 4. The names "Apache" and "Apache Software Foundation" and 
 *    "Apache Turbine" must not be used to endorse or promote products 
 *    derived from this software without prior written permission. For 
 *    written permission, please contact apache@apache.org.
 *
 * 5. Products derived from this software may not be called "Apache",
 *    "Apache Turbine", nor may "Apache" appear in their name, without 
 *    prior written permission of the Apache Software Foundation.
 *
 * THIS SOFTWARE IS PROVIDED ``AS IS'' AND ANY EXPRESSED OR IMPLIED
 * WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES
 * OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE
 * DISCLAIMED.  IN NO EVENT SHALL THE APACHE SOFTWARE FOUNDATION OR
 * ITS CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,
 * SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT
 * LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF
 * USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND
 * ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY,
 * OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT
 * OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
 * SUCH DAMAGE.
 * ====================================================================
 *
 * This software consists of voluntary contributions made by many
 * individuals on behalf of the Apache Software Foundation.  For more
 * information on the Apache Software Foundation, please see
 * <http://www.apache.org/>.
 */


// JDK classes
import java.util.HashMap;

// Turbine classes
import org.apache.turbine.services.intake.*;
import org.apache.turbine.util.TurbineException;
import org.apache.turbine.util.Log;


/**
 * This class is supposed to encapsulate the functionality for
 * dealing with a parameter value
 *
 * @author <a href="mailto:jmcnally@collab.net>John McNally</a>
 * @version $Id: IntakeValue.java,v 1.5 2001/03/27 06:51:48 jmcnally Exp $
 */
public final class IntakeValue
{
    private static final String EMPTY = "";
    private Object validValue;
    private Object testValue;
    private String propertyName;
    private Field field;
    Object[] valArray;
    
    IntakeValue(String propertyName, Field field)
    {
        this.field = field;
        this.propertyName = propertyName;
        valArray = new Object[1];
    }

    /**
     * Disposes the object after use. The method is called
     * when the Group is returned to its pool.
     * if overridden, super.dispose() should be called.
     */
    public void dispose()
    {
        validValue = null;
        testValue = null;
        valArray[0] = null;
    }

    void setValidValue(Object obj)
    {
        validValue = obj;
    }

    public Object getValidValue()
        throws Exception
    {
        if ( validValue == null) 
        {
            // String key = field.group.oid;
            // Object obj = field.omTool.get(field.mapToObject, key);
            if ( field.retrievable != null ) 
            {
                getProperty(field.retrievable);
            }
        }
        return validValue;
    }

    void setTestValue(Object obj)
    {
        testValue = obj;
    }

    public Object getTestValue()
    {
        return testValue;
    }

    public Object getValue()
    {
        Object val = null;
        try
        {
            val = getValidValue();
        }
        catch (Exception e)
        {
            Log.error(e);
        }

        if ( getTestValue() != null ) 
        {
            val = getTestValue();
        }

        if ( val == null ) 
        {
            val = field.onError;
        }
        
        return val;
    }

    public String toString()
    {
        if ( getValue() != null ) 
        {
            return getValue().toString();            
        }
        else 
        {
            return EMPTY;
        }
    }
        
    /**
     * Loads the valid value from a bean
     */
    public void getProperty(Object obj) 
        throws Exception
    {
        validValue = field.getter.invoke(obj, null);
    }

    /**
     * Calls a setter method on obj, if this field has been set.  
     * @exception throws a TurbineException if called and the input
     * was not valid.
     */
    public void setProperty(Object obj) 
    // public void setProperty($appData.BasePackage$field.MapToObject obj) 
        throws TurbineException
    {
        if (!field.isValid()) 
        {
   	        throw new TurbineException(
                "Attempted to assign an invalid input.");
        }
        if (field.isSet())
        {
            try
            {
                valArray[0] = getTestValue();
                field.setter.invoke(obj, valArray);
            }
            catch ( Exception e)
            {
                throw new TurbineException("An exception prevented the" +
                    " mapping to " + obj, e);
            }
        }
    }
}




