/*
 * Created on 17-dic-2005
 *
 * TODO To change the template for this generated file go to
 * Window - Preferences - Java - Code Style - Code Templates
 */
package org.herac.tuxguitar.gui.actions.note;

import org.eclipse.swt.events.TypedEvent;
import org.herac.tuxguitar.gui.actions.Action;
import org.herac.tuxguitar.gui.editors.TablatureEditor;
import org.herac.tuxguitar.gui.undo.undoables.measure.UndoableMeasureGeneric;
import org.herac.tuxguitar.song.models.Note;

/**
 * @author julian
 *
 * TODO To change the template for this generated type comment go to
 * Window - Preferences - Java - Code Style - Code Templates
 */
public class ShiftNoteUpAction extends Action{
    public static final String NAME = "action.note.general.shift-up";
    
    public ShiftNoteUpAction(TablatureEditor tablatureEditor) {
        super(NAME,true,tablatureEditor);       
    }

    public boolean doAction(TypedEvent e) {
    	Note note = getEditor().getTablature().getCaret().getSelectedNote();
    	if(note != null){
    		//comienza el undoable
    		UndoableMeasureGeneric undoable = UndoableMeasureGeneric.startUndo();     
    	
    		int nextString = getSongManager().getMeasureManager().shiftNoteUp(getEditor().getTablature().getCaret().getMeasureCoords().getMeasure(),note.getStart(),note.getString());
    		if(nextString > 0){
    			getEditor().getTablature().getCaret().setStringNumber(nextString);
    			
    			//termia el undoable
    			getEditor().getUndoManager().addEdit(undoable.endUndo());
    		}
    		updateTablature();        
    	}
        return true;
    }
    
    protected void updateTablature() {
        fireUpdate(getEditor().getTablature().getCaret().getMeasureCoords().getMeasure().getNumber());
        redraw();
    }    

}
