package org.herac.tuxguitar.gui.doc;

import java.io.IOException;
import java.io.InputStream;

import org.herac.tuxguitar.gui.TuxGuitar;

public class DocReader {

	private static final String PACKAGE = "org/herac/tuxguitar/gui/doc/";
	
	public static final String DESCRIPTION = "Description";
	public static final String AUTHORS = "Authors";
	public static final String LICENSE = "License";
	
	public DocReader(){		
	}
	
	public StringBuffer read(String doc){
		String lang = TuxGuitar.instance().getLanguageManager().getLanguage();
		InputStream is = getClass().getClassLoader().getResourceAsStream(PACKAGE + doc + "_" + lang + ".txt");
		if(is == null){
			is = getClass().getClassLoader().getResourceAsStream(PACKAGE + doc + ".txt");
		}
		if(is != null){
			return read(is);
		}
		return new StringBuffer();
	}
	
	public StringBuffer read(InputStream is){
		StringBuffer sb = new StringBuffer();	
		try {					
			int read;
			while((read = is.read()) != -1){
				sb.append((char)read);
			}
		} catch (IOException e) {
			e.printStackTrace();
		}
		return sb;
	}	
}
