/*
 * Created on 28-dic-2005
 *
 * TODO To change the template for this generated file go to
 * Window - Preferences - Java - Code Style - Code Templates
 */
package org.herac.tuxguitar.gui.editors.fretboard;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

import org.eclipse.swt.SWT;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.PaintEvent;
import org.eclipse.swt.events.PaintListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.FontData;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.layout.FormLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Label;
import org.herac.tuxguitar.gui.SystemImages;
import org.herac.tuxguitar.gui.TuxGuitar;
import org.herac.tuxguitar.gui.actions.caret.GoLeftAction;
import org.herac.tuxguitar.gui.actions.caret.GoRightAction;
import org.herac.tuxguitar.gui.actions.duration.DecrementDurationAction;
import org.herac.tuxguitar.gui.actions.duration.IncrementDurationAction;
import org.herac.tuxguitar.gui.actions.tools.SelectScaleAction;
import org.herac.tuxguitar.gui.editors.TablatureEditor;
import org.herac.tuxguitar.gui.editors.tab.Caret;
import org.herac.tuxguitar.gui.editors.tab.MeasureComponent;
import org.herac.tuxguitar.gui.editors.tab.NoteCoords;
import org.herac.tuxguitar.gui.system.config.ConfigKeys;
import org.herac.tuxguitar.gui.undo.undoables.measure.UndoableMeasureGeneric;
import org.herac.tuxguitar.song.managers.SongManager;
import org.herac.tuxguitar.song.models.Duration;
import org.herac.tuxguitar.song.models.InstrumentString;
import org.herac.tuxguitar.song.models.Note;
import org.herac.tuxguitar.song.models.NoteEffect;
import org.herac.tuxguitar.song.models.SongTrack;

/**
 * @author julian
 * 
 * TODO To change the template for this generated type comment go to Window - Preferences - Java - Code Style - Code Templates
 */
public class FretBoard extends Composite {
	public static final int MAX_FRETS = 24;
	
	public static final int TOP_SPAN = 10;
	
	public static final int BOTTOM_SPAN = 10;
		
	private static final int STRING_SPAN = TuxGuitar.instance().getConfig().getIntConfigValue(ConfigKeys.FRETBOARD_STRING_SPAN);
	
	private static final Color COLOR_BACKGROUND = new Color(TuxGuitar.instance().getDisplay(),255, 255, 255);
	
	private static final Color COLOR_STRING = new Color(TuxGuitar.instance().getDisplay(),227,217,217);		
	
	private static final String[] NOTE_NAMES = new String[]{"C","C#","D","D#","E","F","F#","G","G#","A","A#","B"};
	
	private TablatureEditor editor;

	private FretBoardListener listener;
	
	private Composite toolComposite;
	
	private Composite fretBoardComposite;

	private Label durationLabel;

	private Combo handSelector;

	private Button scale;
	
	private Image fretBoard;
	
	private List components;

	private int[] frets;

	private int[] strings;

	private int fretSpan;
	
	private boolean changes;
	
	private Point lastSize;
	
	public FretBoard(Composite parent, TablatureEditor editor) {
		super(parent, SWT.NONE);
		this.setLayout(new FormLayout());
		this.components = new ArrayList();
		this.listener = new FretBoardListener();
		this.editor = editor;
		this.initToolBar();
		this.initEditor();
		this.layout(getDisplay().getBounds().width,1);	
	}

	private void initToolBar() {
		FormData data = new FormData();
		data.left = new FormAttachment(0, 0);
		data.right = new FormAttachment(100, 0);
		data.top = new FormAttachment(0,0);
		
		GridLayout layout = new GridLayout();
		layout.makeColumnsEqualWidth = false;
		layout.numColumns = 0;
		
		layout.marginWidth = 0;
		
	    toolComposite = new Composite(this, SWT.NONE);	    
	    	    
		// position
	    layout.numColumns ++;
		Button goLeft = new Button(toolComposite, SWT.ARROW | SWT.LEFT);
		goLeft.addSelectionListener(TuxGuitar.instance().getAction(GoLeftAction.NAME));
		
		layout.numColumns ++;
		Button goRight = new Button(toolComposite, SWT.ARROW | SWT.RIGHT);
		goRight.addSelectionListener(TuxGuitar.instance().getAction(GoRightAction.NAME));
		
		// separator		
		layout.numColumns ++;
		makeToolSeparator(toolComposite);
		
		// duration 
		layout.numColumns ++;
		Button decrement = new Button(toolComposite, SWT.ARROW | SWT.MIN);
		decrement.addSelectionListener(TuxGuitar.instance().getAction(DecrementDurationAction.NAME));

		layout.numColumns ++;
		durationLabel = new Label(toolComposite, SWT.BORDER);
		durationLabel.setImage(getDurationImage());
		
		layout.numColumns ++;
		Button increment = new Button(toolComposite, SWT.ARROW | SWT.MAX);
		increment.addSelectionListener(TuxGuitar.instance().getAction(IncrementDurationAction.NAME));
		
		// separator		
		layout.numColumns ++;
		makeToolSeparator(toolComposite);
		
		// hand selector
		layout.numColumns ++;
		handSelector = new Combo(toolComposite, SWT.DROP_DOWN | SWT.READ_ONLY);
		handSelector.add(TuxGuitar.getProperty("fretboard.right-mode"));
		handSelector.add(TuxGuitar.getProperty("fretboard.left-mode"));
		handSelector.select(0);
		handSelector.addSelectionListener(new SelectionAdapter() {
			public void widgetSelected(SelectionEvent e) {
				int index = handSelector.getSelectionIndex();
				if (index == 0) {
					initFrets(10, 1);
				} else {
					initFrets(10, 2);
				}
				setChanges(true);
				fretBoardComposite.redraw();
			}
		});
		
		// separator
		layout.numColumns ++;
		makeToolSeparator(toolComposite);
		
		// escala
		layout.numColumns ++;
		scale = new Button(toolComposite, SWT.PUSH);
		scale.setText(TuxGuitar.getProperty("scale"));
		scale.addSelectionListener(TuxGuitar.instance().getAction(SelectScaleAction.NAME));		
		
		toolComposite.setLayoutData(data);
		toolComposite.setLayout(layout);	    	    
	}

	private void makeToolSeparator(Composite parent){
		Label separator = new Label(parent,SWT.SEPARATOR);
		separator.setLayoutData(new GridData(20,20));
	}
	
	private void initEditor() {		
		this.lastSize = new Point(0,0);
		
		FormData data = new FormData();
		data.left = new FormAttachment(0, 0);
		data.right = new FormAttachment(100, 0);
		data.top = new FormAttachment(toolComposite,0);
		data.bottom = new FormAttachment(100, 0);

		this.fretBoardComposite = new Composite(this, SWT.BORDER | SWT.DOUBLE_BUFFERED);
		this.fretBoardComposite.setLayoutData(data);
		this.fretBoardComposite.setBackground(COLOR_BACKGROUND);
		this.fretBoardComposite.addMouseListener(this.listener);
		this.fretBoardComposite.addPaintListener(this.listener);
	}

	private Image getDurationImage() {
		Duration duration = (Duration) editor.getTablature().getCaret().getDuration().clone();
		return SystemImages.getDuration(duration.getValue());		
	}

	private void calculateFretSpan(int width) {
		this.fretSpan = (width / MAX_FRETS);
		int aux = 0;
		for (int i = 0; i < MAX_FRETS; i++) {
			aux += (i * 2);
		}
		this.fretSpan += (aux / MAX_FRETS) + 2;
	}

	private void disposeFretBoardImage(){
		if(this.fretBoard != null && !this.fretBoard.isDisposed()){
			this.fretBoard.dispose();
		}
	}
	
	private void initFrets(int fromX, int hand) {
		this.frets = new int[MAX_FRETS];
		int nextX = fromX;
		if (hand == 1) {
			for (int i = 0; i < this.frets.length; i++) {
				this.frets[i] = nextX;
				nextX += (this.fretSpan - ((i + 1) * 2));
			}
		} else if (hand == 2) {
			for (int i = this.frets.length - 1; i >= 0; i--) {
				this.frets[i] = nextX;
				nextX += (this.fretSpan - (i * 2));
			}
		}
	}

	private void initStrings(int count) {
		int fromY = TOP_SPAN;
		this.strings = new int[count];

		for (int i = 0; i < this.strings.length; i++) {
			this.strings[i] = fromY + (STRING_SPAN * i);
		}		
	}
	
	private void updateEditor(){
		if(isVisible()){
			SongManager manager = TuxGuitar.instance().getSongManager();
			if(TuxGuitar.instance().getPlayer().isRunning()){
				this.components = TuxGuitar.instance().getEditorCache().getPlayingComponents();
			}else{
				this.components = TuxGuitar.instance().getEditorCache().getCaretComponents();
			}

			if (this.strings.length != getStringCount()) {
				disposeFretBoardImage();
				initStrings(getStringCount());
				//Fuerzo a cambiar el ancho
				this.lastSize.y = 0;
			}
		
		    int clientWidth = getClientArea().width;
		    int clientHeight = getClientArea().height;
		    
		    if(lastSize.x != clientWidth || hasChanges()){
		    	this.layout(getClientArea().width,this.handSelector.getSelectionIndex() + 1);
		    }		   

		    if(lastSize.y != clientHeight){
		        TuxGuitar.instance().getFretBoardEditor().showFretBoard();
		    }
		    this.lastSize.x = clientWidth;
		    this.lastSize.y = clientHeight;
		}
	}

	private void paintFretBoard(GC gc){
		if(this.fretBoard == null || this.fretBoard.isDisposed()){
			this.fretBoard = new Image(getDisplay(),getClientArea().width,((STRING_SPAN) * (this.strings.length - 1)) + TOP_SPAN + BOTTOM_SPAN);
			
			GC imageGC = new GC(this.fretBoard);
			
		    //fondo
			imageGC.setBackground(getDisplay().getSystemColor(SWT.COLOR_BLACK));		    
			imageGC.fillRectangle(getClientArea());
		    

			// pinto las cegillas
		    Image fretImage = SystemImages.FRETBOARD_FRET_IMAGE;
		    Image firstFretImage = SystemImages.FRETBOARD_FIRST_FRET_IMAGE;
		    imageGC.drawImage(firstFretImage,0,0,firstFretImage.getBounds().width,firstFretImage.getBounds().height,frets[0] - 5,strings[0] - 5,firstFretImage.getBounds().width,strings[strings.length - 1] );
		    paintFretPoints(imageGC,0);
		    for (int i = 1; i < this.frets.length; i++) {			    
		    	imageGC.drawImage(fretImage,0,0,fretImage.getBounds().width,fretImage.getBounds().height,frets[i],strings[0] - 5,fretImage.getBounds().width,strings[strings.length - 1] );
				paintFretPoints(imageGC, i);
			}

			// pinto las cuerdas
			for (int i = 0; i < this.strings.length; i++) {
				imageGC.setForeground(COLOR_STRING);
			    if(i > 2){
			    	imageGC.setLineWidth(2);
			    }
			    imageGC.drawLine(frets[0], strings[i], frets[frets.length - 1], strings[i]);
			}			
			
			// pinto la escala
			paintScale(imageGC);
			
		}
		gc.drawImage(this.fretBoard,0,0);
	}
	

	private void paintFretPoints(GC gc, int fretIndex) {
		gc.setBackground(getDisplay().getSystemColor(SWT.COLOR_GRAY));
		if ((fretIndex + 1) < this.frets.length) {
			int fret = fretIndex + 1;

			while (fret >= 12) {
				fret -= 12;
			}
			if (fret == 0) {
				gc.setLineWidth(10);
				int size = getOvalSize();
				int x = this.frets[fretIndex] + ((this.frets[fretIndex + 1] - this.frets[fretIndex]) / 2);
				int y1 = this.strings[0] + ((this.strings[this.strings.length - 1] - this.strings[0]) / 2) - STRING_SPAN;
				int y2 = this.strings[0] + ((this.strings[this.strings.length - 1] - this.strings[0]) / 2) + STRING_SPAN;
				gc.fillOval(x - (size / 2), y1 - (size / 2), size, size);
				gc.fillOval(x - (size / 2), y2 - (size / 2), size, size);
				gc.setLineWidth(1);
			} else if (fret == 3 || fret == 5 || fret == 7 || fret == 9) {
				gc.setLineWidth(10);
				int size = getOvalSize();
				int x = this.frets[fretIndex] + ((this.frets[fretIndex + 1] - this.frets[fretIndex]) / 2);
				int y = this.strings[0] + ((this.strings[this.strings.length - 1] - this.strings[0]) / 2);				
				gc.fillOval(x - (size / 2),y - (size / 2),size, size);
				gc.setLineWidth(1);

			}

		}

	}	
	
	private void paintScale(GC gc) {	   
		SongTrack track = editor.getTablature().getCaret().getSongTrackCoords().getTrack();
		
		Font font = new Font(getDisplay(),new FontData("Sans",8,SWT.BOLD));
		
		gc.setBackground(getDisplay().getSystemColor(SWT.COLOR_WHITE));		
		gc.setForeground(getDisplay().getSystemColor(SWT.COLOR_RED));				
		gc.setFont(font);
		
		for (int i = 0; i < this.strings.length; i++) {
			InstrumentString string = track.getString(i + 1);			
			for (int j = 0; j < this.frets.length; j++) {
			
				int noteIndex = ((string.getValue() + j) %  12 );
				if(TuxGuitar.instance().getScaleManager().getScale().getNote(noteIndex)){
					String s = NOTE_NAMES[noteIndex]; 
					Point size = gc.stringExtent(s);
					
					int x = this.frets[j];
					if(j > 0){
						x -= ((x - this.frets[j - 1]) / 2);
					}

					int y = this.strings[i];	
					
					gc.fillRectangle(x - (size.x / 2),y - (size.y / 2),size.x, size.y);
					gc.drawString(s,x - (size.x / 2),y - (size.y / 2),true);
				}
			}
			
			
		}
		
		
		gc.setForeground(getDisplay().getSystemColor(SWT.COLOR_BLACK));
		
		font.dispose();
	}		
	
	private void paintComponents(GC gc) {	   
		int size = getOvalSize();
		gc.setBackground(getDisplay().getSystemColor(SWT.COLOR_BLUE));
		gc.setLineWidth(10);
		Iterator it = this.components.iterator();
		while (it.hasNext()) {
			MeasureComponent component = (MeasureComponent) it.next();
			if (component instanceof NoteCoords) {
				NoteCoords note = (NoteCoords) component;
				int fretIndex = note.getNote().getValue();
				int stringIndex = note.getNote().getString() - 1;
				if (fretIndex >= 0 && fretIndex < this.frets.length && stringIndex >= 0 && stringIndex < this.strings.length) {
					int x = this.frets[fretIndex];
					if (fretIndex > 0) {
						x -= ((this.frets[fretIndex] - this.frets[fretIndex - 1]) / 2);
					}
					int y = this.strings[stringIndex];
					gc.fillOval(x - (size / 2),y - (size / 2),size, size);
				}
			}
		}
		gc.setLineWidth(1);
		gc.setForeground(getDisplay().getSystemColor(SWT.COLOR_BLACK));	
	}	
	
	private void paintEditor(GC gc) {	    
		this.updateEditor();
		if (this.frets.length > 0 && this.strings.length > 0) {
			paintFretBoard(gc);
			paintComponents(gc);
		}
	}


	private void hit(int x, int y) {
		int fretIndex = getFretIndex(x);
		int stringIndex = getStringIndex(y);

		editor.getTablature().getCaret().setStringNumber(stringIndex + 1);
		if (!removeNote(fretIndex, stringIndex + 1)) {
			addNote(fretIndex, stringIndex + 1);					
		}
	}

	private int getStringIndex(int y) {
		int index = -1;
		for (int i = 0; i < this.strings.length; i++) {
			if (index < 0) {
				index = i;
			} else {
				int distanceY = Math.abs(y - this.strings[index]);
				int currDistanceY = Math.abs(y - this.strings[i]);
				if (currDistanceY < distanceY) {
					index = i;
				}
			}
		}
		return index;
	}

	private int getFretIndex(int x) {
		int length = this.frets.length;
		if ((x - 10) <= frets[0] && frets[0] < frets[length - 1]) {
			return 0;
		}
		if ((x + 10) >= frets[0] && frets[0] > frets[length - 1]) {
			return 0;
		}

		for (int i = 0; i < length; i++) {
			if ((i + 1) < length) {
				if (x > frets[i] && x <= frets[i + 1] || x > frets[i + 1] && x <= frets[i]) {
					return i + 1;
				}
			}
		}
		return length - 1;
	}

	private boolean removeNote(int fret, int string) {
		Iterator it = this.components.iterator();
		while (it.hasNext()) {
			MeasureComponent component = (MeasureComponent) it.next();
			if (component instanceof NoteCoords) {
				Note note = ((NoteCoords) component).getNote();
				if (note.getValue() == fret && note.getString() == string) {
			        //comienza el undoable
			        UndoableMeasureGeneric undoable = UndoableMeasureGeneric.startUndo();     
					
					Caret caret = this.editor.getTablature().getCaret();
					SongManager manager = TuxGuitar.instance().getSongManager(); 
					manager.getMeasureManager().removeNote(caret.getMeasureCoords().getMeasure(),note);
					
			        //termia el undoable
					editor.getUndoManager().addEdit(undoable.endUndo());   					
					
					return true;
				}
			}
		}
		return false;
	}

	private int getStringCount() {
		return editor.getTablature().getCaret().getSongTrackCoords().getTrack().getStrings().size();
	}

	private int getOvalSize(){
		return ((STRING_SPAN / 2) + (STRING_SPAN / 10));
	}
	
	private void addNote(int fret, int string) {
        //comienza el undoable
		UndoableMeasureGeneric undoable = UndoableMeasureGeneric.startUndo();
		
		Caret caret = this.editor.getTablature().getCaret();
		Duration duration = (Duration) caret.getDuration().clone();
		Note note = new Note(fret, caret.getPosition(), duration, caret.getVelocity(), string, false, new NoteEffect());
		
		SongManager manager = TuxGuitar.instance().getSongManager();
		manager.getMeasureManager().addNote(caret.getMeasureCoords().getMeasure(),note);
		
        //termia el undoable
		editor.getUndoManager().addEdit(undoable.endUndo());
		
        //reprodusco las notas en el pulso
        caret.getMeasureCoords().playBeat(note.getStart());     			
	}

	private void afterAction() {
		this.editor.getTablature().getViewLayout().fireUpdate(this.editor.getTablature().getCaret().getMeasureCoords().getMeasure().getNumber(), false);		
		TuxGuitar.instance().redraw();
		TuxGuitar.instance().updateCache(true);
	}

	public boolean hasChanges(){
		return this.changes;
	}
	
	public void setChanges(boolean changes){
		this.changes = changes;
	}
	
	public void redraw() {
	    if(!super.isDisposed()){	    	
	        super.redraw();
	        this.fretBoardComposite.redraw();
	        this.durationLabel.setImage(getDurationImage());
	    }
	}

	public void redrawPlayingMode(){     
		if(!super.isDisposed()){
	        this.fretBoardComposite.redraw();
		}
	 }
	
	public void dispose(){
		super.dispose();
		this.disposeFretBoardImage();		
	}
	
    public void loadProperties(){
    	int selection = this.handSelector.getSelectionIndex();
    	this.handSelector.removeAll();
	    this.handSelector.add(TuxGuitar.getProperty("fretboard.right-mode"));
	    this.handSelector.add(TuxGuitar.getProperty("fretboard.left-mode"));	    
	    this.handSelector.select(selection);
	    this.scale.setText(TuxGuitar.getProperty("scale"));
	    this.layout();
    }
	
	public int getHeight(){				
		int borderWidth = (2 * this.fretBoardComposite.getBorderWidth());
		int toolBarHeight = (this.toolComposite.getBounds().height);
		int fretBoardHeight = (((STRING_SPAN) * (this.strings.length - 1)) + TOP_SPAN + BOTTOM_SPAN);		
		return (borderWidth + toolBarHeight + fretBoardHeight);
	}
	
	public int getWidth(){
	    return this.frets[this.frets.length - 1];
	}	
	
	public void layout(){
	    super.layout();
	}
	
	public void layout(int width,int hand){		
		this.disposeFretBoardImage();
		this.calculateFretSpan(width);
		this.initFrets(10,hand);
		this.initStrings(getStringCount());
		this.setChanges(false);
	}

	public static void disposeColors(){
		COLOR_BACKGROUND.dispose();
		COLOR_STRING.dispose();
	}
	
	
	
	private class FretBoardListener implements PaintListener,MouseListener {

		public void paintControl(PaintEvent e) {
			paintEditor(e.gc);
			e.gc.dispose();
		}
		
		public void mouseUp(MouseEvent e) {
			if(e.button == 1){
				hit(e.x, e.y);
				afterAction();
			}else{
				TuxGuitar.instance().getAction(GoRightAction.NAME).process(e);
			}
		}			
		
		public void mouseDoubleClick(MouseEvent e) {		
		}

		public void mouseDown(MouseEvent e) {			
		}	
	}
}
