package org.herac.tuxguitar.gui.editors.tab;

import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Rectangle;

public class CacheImage {
	private Device device;
	
	private Image cache;
	
	private GC gc;
	
	private int width;
	
	private int height;
	
	public CacheImage(Device device){
		this(device,1,1);
	}

	public CacheImage(Device device,int width,int height){
		this.device = device;
		this.resizeCache(width,height);
	}

	private void resizeCache(int newWidth,int newHeight){
		//solo si la medida es distinta
		if(this.width != newWidth || this.height != newHeight){
			this.dispose();
			this.cache = new Image(this.device,newWidth,newHeight);			
		}
		//si el area es igual al viejo solo limpio la imagen.
		else{
			if(this.cache == null || this.cache.isDisposed()){
				this.cache = new Image(this.device,newWidth,newHeight);	
			}
			getGC().fillRectangle(new Rectangle(0,0,newWidth,newHeight));
		}
		this.width = newWidth;
		this.height = newHeight;
	}
	
	public void setSize(int width,int height){
		this.resizeCache(width,height);
	}
			
	public GC getGC(){
		if(this.gc == null || this.gc.isDisposed()){
			this.gc = new GC(this.cache);
		}
		return gc;
	}	
	
	public void paintImage(GC gc,int x,int y){
		gc.drawImage(this.cache,x,y);
	}
	
	public Image getImage(){
		return this.cache;
	}
	
	public void dispose(){
		if(cache != null && !cache.isDisposed()){
			cache.dispose();
		}		
		if(gc != null && !gc.isDisposed()){
			gc.dispose();
		}
	}
	
	public boolean isDisposed(){
		return (cache == null || cache.isDisposed());
	}
}
