package org.herac.tuxguitar.gui.effects;

import org.eclipse.swt.SWT;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Spinner;
import org.herac.tuxguitar.gui.SystemImages;
import org.herac.tuxguitar.gui.TuxGuitar;
import org.herac.tuxguitar.song.models.Duration;
import org.herac.tuxguitar.song.models.Note;
import org.herac.tuxguitar.song.models.effects.TrillEffect;

public class TrillEditor extends SelectionAdapter{

	public static final int WIDTH = 400;
	
	public static final int HEIGHT = 0;
		
	private Spinner fretSpinner;
	private Button sixtyFourthButton;
	private Button thirtySecondButton;
	private Button sixTeenthButton;
	
	private TrillEffect result;
	
	public TrillEditor(){
		
	}

	public TrillEffect show(final Note note){
		final Shell shell = TuxGuitar.instance().getShell();
		final Shell dialog = new Shell(shell, SWT.DIALOG_TRIM | SWT.APPLICATION_MODAL);

        dialog.setLayout(new GridLayout());
        dialog.setText(TuxGuitar.getProperty("effects.trill-editor"));
        
        
        Composite composite = new Composite(dialog,SWT.NONE);
        composite.setLayout(new GridLayout());
        composite.setLayoutData(new GridData(SWT.FILL,SWT.FILL,true,true));
        
        int horizontalSpan = 2;
        
        //-----defaults-------------------------------------------------
		int fret = note.getValue();
		Duration duration = new Duration(Duration.SIXTEENTH);
        if(note.getEffect().isTrill()){        	
        	fret = note.getEffect().getTrill().getFret();
        	duration = note.getEffect().getTrill().getDuration();
        }        
    	//---------------------------------------------------
        //------------------NOTE-----------------------------
    	//---------------------------------------------------
        Group noteGroup = makeGroup(composite,horizontalSpan, TuxGuitar.getProperty("note"));        
        noteGroup.setLayout(new GridLayout(2,false));
        
        Label fretLabel = new Label(noteGroup,SWT.NONE);
        
        fretLabel.setText(TuxGuitar.getProperty("fret") + ": ");
        //fretLabel.setLayoutData(makeGridData(1));
        
        fretSpinner = new Spinner(noteGroup,SWT.BORDER);
        fretSpinner.setLayoutData(makeGridData(1));
        fretSpinner.setSelection(fret);

    	//---------------------------------------------------
        //------------------DURATION-------------------------
    	//---------------------------------------------------
        Group durationGroup = makeGroup(composite,horizontalSpan, TuxGuitar.getProperty("duration"));
        durationGroup.setLayout(new GridLayout(3,false));
        
        sixtyFourthButton = new Button(durationGroup,SWT.RADIO);
        sixtyFourthButton.setImage(SystemImages.getDuration(Duration.SIXTY_FOURTH));
        sixtyFourthButton.setLayoutData(makeGridData(1));
        sixtyFourthButton.setSelection(duration.getValue() == Duration.SIXTY_FOURTH);
        
        thirtySecondButton = new Button(durationGroup,SWT.RADIO);
        thirtySecondButton.setImage(SystemImages.getDuration(Duration.THIRTY_SECOND));
        thirtySecondButton.setLayoutData(makeGridData(1));
        thirtySecondButton.setSelection(duration.getValue() == Duration.THIRTY_SECOND);
        
        sixTeenthButton = new Button(durationGroup,SWT.RADIO);
        sixTeenthButton.setImage(SystemImages.getDuration(Duration.SIXTEENTH));
        sixTeenthButton.setLayoutData(makeGridData(1));        
        sixTeenthButton.setSelection(duration.getValue() == Duration.SIXTEENTH);
        
    	//---------------------------------------------------
        //------------------BUTTONS--------------------------
    	//---------------------------------------------------
        Composite buttons = new Composite(dialog, SWT.NONE);
        buttons.setLayout(new GridLayout(3,false));
        buttons.setLayoutData(new GridData(SWT.END,SWT.BOTTOM,true,true));    	
        
        GridData data = new GridData(SWT.FILL,SWT.FILL,true,true);    
        data.minimumWidth = 80;
        data.minimumHeight = 25;     
        
        final Button buttonOK = new Button(buttons, SWT.PUSH);
        buttonOK.setText(TuxGuitar.getProperty("ok"));        
        buttonOK.setLayoutData(data);
        buttonOK.addSelectionListener(new SelectionAdapter() {
            public void widgetSelected(SelectionEvent arg0) {   
            	result = getTrill();
                dialog.dispose();
            }
        });

        Button buttonClean = new Button(buttons, SWT.PUSH);
        buttonClean.setText(TuxGuitar.getProperty("clean"));
        buttonClean.setLayoutData(data);
        buttonClean.addSelectionListener(new SelectionAdapter() {
            public void widgetSelected(SelectionEvent arg0) {
            	result = null;
                dialog.dispose();
            }
        });        
        
        Button buttonCancel = new Button(buttons, SWT.PUSH);
        buttonCancel.setText(TuxGuitar.getProperty("cancel"));
        buttonCancel.setLayoutData(data);
        buttonCancel.addSelectionListener(new SelectionAdapter() {
            public void widgetSelected(SelectionEvent arg0) {
            	result = note.getEffect().getTrill();
                dialog.dispose();
            }
        });

        
        dialog.pack();
        dialog.open();

        int x = shell.getBounds().x + (shell.getBounds().width - dialog.getSize().x) / 2;
        int y = shell.getBounds().y + (shell.getBounds().height - dialog.getSize().y) / 2;
        dialog.setLocation(x, y);
        
		while (!dialog.isDisposed()) {
            if (!dialog.getDisplay().readAndDispatch()) {
            	dialog.getDisplay().sleep();
            }
        }		
	
		return result;
	}
	
	private GridData resizeData(GridData data,int minWidth){
		data.minimumWidth = minWidth;
		
		return data;
	}
	
	private Group makeGroup(Composite parent,int horizontalSpan,String text){
        Group group = new Group(parent, SWT.SHADOW_ETCHED_IN);
        group.setLayoutData(makeGridData(horizontalSpan));
        group.setText(text);
        
        return group;
	}
	
	
	private GridData makeGridData(int horizontalSpan){
		GridData data = new GridData(SWT.FILL,SWT.FILL,true,true);		
		data.horizontalSpan = horizontalSpan;		
		return data;
	}	
	
	public TrillEffect getTrill(){				
		int fret = fretSpinner.getSelection();			
				
		if(sixtyFourthButton.getSelection()){
			return new TrillEffect(fret,new Duration(Duration.SIXTY_FOURTH));
		}else if(thirtySecondButton.getSelection()){
			return new TrillEffect(fret,new Duration(Duration.THIRTY_SECOND));
		}if(sixTeenthButton.getSelection()){
			return new TrillEffect(fret,new Duration(Duration.SIXTEENTH));
		}		
		return null;
	}	
	

}
