/*
 * Created on 02-dic-2005
 *
 * TODO To change the template for this generated file go to
 * Window - Preferences - Java - Code Style - Code Templates
 */
package org.herac.tuxguitar.gui.items.menu;

import java.io.File;
import java.util.List;

import org.eclipse.swt.SWT;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.MenuItem;
import org.eclipse.swt.widgets.Shell;
import org.herac.tuxguitar.gui.SystemImages;
import org.herac.tuxguitar.gui.TuxGuitar;
import org.herac.tuxguitar.gui.actions.file.ExportASCIIAction;
import org.herac.tuxguitar.gui.actions.file.ExportMidiAction;
import org.herac.tuxguitar.gui.actions.file.ExportPDFAction;
import org.herac.tuxguitar.gui.actions.file.ImportMidiAction;
import org.herac.tuxguitar.gui.actions.file.NewFileAction;
import org.herac.tuxguitar.gui.actions.file.OpenFileAction;
import org.herac.tuxguitar.gui.actions.file.PrintAction;
import org.herac.tuxguitar.gui.actions.file.PrintPreviewAction;
import org.herac.tuxguitar.gui.actions.file.SaveAsFileAction;
import org.herac.tuxguitar.gui.actions.file.SaveFileAction;
import org.herac.tuxguitar.gui.editors.TablatureEditor;
import org.herac.tuxguitar.gui.items.MenuItems;

/**
 * @author julian
 * 
 * TODO To change the template for this generated type comment go to Window - Preferences - Java - Code Style - Code Templates
 */
public class FileMenuItem implements MenuItems {
    private TablatureEditor tablatureEditor;
    private MenuItem fileMenuItem;
    private Menu menu;
    private Menu importMenu; 
    private Menu exportMenu; 
    private Menu historyMenu;
    private MenuItem newSong;
    private MenuItem open;
    private MenuItem save;
    private MenuItem saveAs;
    private MenuItem importItem;
    private MenuItem importMidi;    
    private MenuItem exportItem;
    private MenuItem exportMidi;
    private MenuItem exportPDF;
    private MenuItem exportASCII;
    private MenuItem printPreview;
    private MenuItem print;    
    private MenuItem historyItem;
    private MenuItem[] historyFiles;
    private MenuItem exit;
    
    public FileMenuItem(Shell shell,Menu parent, int style, TablatureEditor tablatureEditor) {
        this.fileMenuItem = new MenuItem(parent, style);
        this.tablatureEditor = tablatureEditor;
        this.menu = new Menu(shell, SWT.DROP_DOWN);
    }

    
    public void showItems(){  
        //---------------------------------------------------
        //--NEW--
        this.newSong = new MenuItem(this.menu, SWT.PUSH);
        this.newSong.setImage(SystemImages.NEW_IMAGE);
        this.newSong.addSelectionListener(TuxGuitar.instance().getAction(NewFileAction.NAME));
        //--OPEN--
        this.open = new MenuItem(this.menu, SWT.PUSH);
        this.open.setImage(SystemImages.OPEN_IMAGE);
        this.open.addSelectionListener(TuxGuitar.instance().getAction(OpenFileAction.NAME)); 
        //--SEPARATOR--
        new MenuItem(this.menu, SWT.SEPARATOR);
        //--SAVE--
        this.save = new MenuItem(this.menu, SWT.PUSH);
        this.save.setImage(SystemImages.SAVE_IMAGE);
        this.save.addSelectionListener(TuxGuitar.instance().getAction(SaveFileAction.NAME));       
        //--SAVE AS--
        this.saveAs = new MenuItem(this.menu, SWT.PUSH);
        this.saveAs.setImage(SystemImages.SAVE_AS_IMAGE);
        this.saveAs.addSelectionListener(TuxGuitar.instance().getAction(SaveAsFileAction.NAME));             
        //--SEPARATOR--
        new MenuItem(this.menu, SWT.SEPARATOR);
        
        //--IMPORT--
        this.importItem = new MenuItem(this.menu,SWT.CASCADE);
        this.importMenu = new Menu(this.menu.getShell(), SWT.DROP_DOWN);
        //midi
        this.importMidi = new MenuItem(this.importMenu, SWT.PUSH);
        this.importMidi.addSelectionListener(TuxGuitar.instance().getAction(ImportMidiAction.NAME));        
        
        //--EXPORT--
        this.exportItem = new MenuItem(this.menu,SWT.CASCADE);
        this.exportMenu = new Menu(this.menu.getShell(), SWT.DROP_DOWN);
        //midi
        this.exportMidi = new MenuItem(this.exportMenu, SWT.PUSH);
        this.exportMidi.addSelectionListener(TuxGuitar.instance().getAction(ExportMidiAction.NAME));
        //pdf
        this.exportPDF = new MenuItem(this.exportMenu, SWT.PUSH);
        this.exportPDF.addSelectionListener(TuxGuitar.instance().getAction(ExportPDFAction.NAME));
        //ascii
        this.exportASCII = new MenuItem(this.exportMenu, SWT.PUSH);
        this.exportASCII.addSelectionListener(TuxGuitar.instance().getAction(ExportASCIIAction.NAME));        
        //--SEPARATOR--
        new MenuItem(this.menu, SWT.SEPARATOR);
        //--PRINT PREVIEW--
        this.printPreview = new MenuItem(this.menu, SWT.PUSH);
        this.printPreview.setImage(SystemImages.PRINT_PREVIEW_IMAGE);
        this.printPreview.addSelectionListener(TuxGuitar.instance().getAction(PrintPreviewAction.NAME));          
        //--PRINT--
        this.print = new MenuItem(this.menu, SWT.PUSH);
        this.print.setImage(SystemImages.PRINT_IMAGE);
        this.print.addSelectionListener(TuxGuitar.instance().getAction(PrintAction.NAME));         
        //--SEPARATOR--
        new MenuItem(this.menu, SWT.SEPARATOR);
        
        //--HISTORY--
        this.historyItem = new MenuItem(this.menu,SWT.CASCADE);
        this.historyMenu = new Menu(this.menu.getShell(), SWT.DROP_DOWN);
        this.updateHistoryFiles();
        //--SEPARATOR--
        new MenuItem(this.menu, SWT.SEPARATOR);
        //--EXIT--
        this.exit = new MenuItem(this.menu, SWT.PUSH);        
        this.exit.addSelectionListener(new SelectionAdapter() {
            public void widgetSelected(SelectionEvent arg0) {
                tablatureEditor.getTablature().dispose();
                TuxGuitar.instance().getPlayer().close();
                System.exit(0);
            }
        });
        //---------------------------------------------------
        this.importItem.setMenu(this.importMenu);
        this.exportItem.setMenu(this.exportMenu);
        this.historyItem.setMenu(this.historyMenu);
        this.fileMenuItem.setMenu(menu);
        
        this.loadProperties();
    }

    
    private void disposeHistoryFiles(){
    	for(int i = 0;i < historyFiles.length; i++){
    		this.historyFiles[i].dispose();
    	}
    }
    
    private void updateHistoryFiles(){
    	List paths = TuxGuitar.instance().getFileHistory().getPaths();
    	this.historyFiles = new MenuItem[paths.size()];
    	for(int i = 0;i < historyFiles.length; i++){
    		String pathName = (String)paths.get(i);
    		this.historyFiles[i] = new MenuItem(this.historyMenu, SWT.PUSH);
    		this.historyFiles[i].setText(new File(pathName).getName());
    		this.historyFiles[i].setData(pathName);
    		this.historyFiles[i].addSelectionListener(TuxGuitar.instance().getAction(OpenFileAction.NAME));
    	}
    	this.historyItem.setEnabled(this.historyFiles.length > 0);
    }
    
    public void update(){
    	if(TuxGuitar.instance().getFileHistory().hasPathChanges()){
    		disposeHistoryFiles();
    		updateHistoryFiles();
    		TuxGuitar.instance().getFileHistory().setPathChanges(false);
    	}
    }
    
    public void loadProperties(){
        this.fileMenuItem.setText(TuxGuitar.getProperty("file"));  
        this.newSong.setText(TuxGuitar.getProperty("file.new"));  
        this.open.setText(TuxGuitar.getProperty("file.open"));  
        this.save.setText(TuxGuitar.getProperty("file.save"));
        this.saveAs.setText(TuxGuitar.getProperty("file.save-as"));        
        this.importItem.setText(TuxGuitar.getProperty("file.import"));
        this.importMidi.setText(TuxGuitar.getProperty("file.import-midi"));        
        this.exportItem.setText(TuxGuitar.getProperty("file.export"));
        this.exportMidi.setText(TuxGuitar.getProperty("file.export-midi"));
        this.exportPDF.setText(TuxGuitar.getProperty("file.export-pdf"));
        this.exportASCII.setText(TuxGuitar.getProperty("file.export-ascii"));
        this.printPreview.setText(TuxGuitar.getProperty("file.print-preview"));
        this.print.setText(TuxGuitar.getProperty("file.print"));
        this.historyItem.setText(TuxGuitar.getProperty("file.history"));
        this.exit.setText(TuxGuitar.getProperty("file.exit"));
    }         
}